/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.ByteBufferWriter;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.ObjToByteArraySerializer;
import org.apache.geode.internal.cache.BytesAndBitsForCompactor;
import org.apache.geode.internal.serialization.BufferDataOutputStream;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.tcp.ByteBufferInputStream;

public class HeapDataOutputStream
extends BufferDataOutputStream
implements ObjToByteArraySerializer,
ByteBufferWriter {
    public HeapDataOutputStream(KnownVersion version) {
        this(1024, version);
    }

    public HeapDataOutputStream(String s) {
        super(s);
    }

    public HeapDataOutputStream(int allocSize, KnownVersion version) {
        this(allocSize, version, false);
    }

    public HeapDataOutputStream(int allocSize) {
        this(allocSize, null, false);
    }

    public HeapDataOutputStream(int allocSize, KnownVersion version, boolean doNotCopy) {
        super(allocSize, version, doNotCopy);
    }

    public HeapDataOutputStream(ByteBuffer initialBuffer, KnownVersion version, boolean doNotCopy) {
        super(initialBuffer, version, doNotCopy);
    }

    public HeapDataOutputStream(byte[] bytes) {
        super(bytes);
    }

    public void trim() {
        this.finishWriting();
        if (this.buffer.limit() < this.buffer.capacity()) {
            ByteBuffer bb = ByteBuffer.allocate(this.buffer.limit());
            bb.put(this.buffer);
            bb.flip();
            this.buffer = bb;
        }
    }

    public void sendTo(BytesAndBitsForCompactor wrapper, byte userBits) {
        ByteBuffer bb = this.toByteBuffer();
        if (bb.hasArray() && bb.arrayOffset() == 0) {
            wrapper.setData(bb.array(), userBits, bb.limit(), true);
        } else {
            ByteBuffer tmp = ByteBuffer.allocate(bb.remaining());
            tmp.put(bb);
            tmp.flip();
            this.buffer = tmp;
            byte[] bytes = this.buffer.array();
            wrapper.setData(bytes, userBits, bytes.length, true);
        }
    }

    public int sendTo(SocketChannel chan) throws IOException {
        int result;
        this.finishWriting();
        if (this.size() == 0) {
            return 0;
        }
        if (this.chunks != null) {
            ByteBuffer[] bufs = new ByteBuffer[this.chunks.size() + 1];
            bufs = this.chunks.toArray(bufs);
            bufs[this.chunks.size()] = this.buffer;
            result = (int)chan.write(bufs);
        } else {
            result = chan.write(this.buffer);
        }
        this.size -= result;
        return result;
    }

    public void sendTo(SocketChannel chan, ByteBuffer out) throws IOException {
        this.finishWriting();
        if (this.size() == 0) {
            return;
        }
        out.clear();
        if (this.chunks != null) {
            for (ByteBuffer bb : this.chunks) {
                this.sendChunkTo(bb, chan, out);
            }
        }
        this.sendChunkTo(this.buffer, chan, out);
        this.flushBuffer(chan, out);
    }

    private void sendChunkTo(ByteBuffer in, SocketChannel sc, ByteBuffer out) throws IOException {
        int bytesSent = in.remaining();
        if (in.isDirect()) {
            this.flushBuffer(sc, out);
            while (in.remaining() > 0) {
                sc.write(in);
            }
        } else {
            int OUT_MAX = out.remaining();
            if (bytesSent <= OUT_MAX) {
                out.put(in);
            } else {
                int bytesThisTime;
                byte[] bytes = in.array();
                int off = in.arrayOffset() + in.position();
                for (int len = bytesSent; len > 0; len -= bytesThisTime) {
                    bytesThisTime = len;
                    if (bytesThisTime > OUT_MAX) {
                        bytesThisTime = OUT_MAX;
                    }
                    out.put(bytes, off, bytesThisTime);
                    off += bytesThisTime;
                    this.flushBuffer(sc, out);
                    OUT_MAX = out.remaining();
                }
                in.position(in.limit());
            }
        }
        this.size -= bytesSent;
    }

    public void sendTo(ByteBuffer out) {
        ByteBuffer bb;
        int bytesToWrite;
        this.finishWriting();
        if (out.remaining() < this.size()) {
            throw new BufferOverflowException();
        }
        if (this.chunks != null) {
            for (ByteBuffer bb2 : this.chunks) {
                int bytesToWrite2 = bb2.remaining();
                if (bytesToWrite2 <= 0) continue;
                out.put(bb2);
                this.size -= bytesToWrite2;
            }
        }
        if ((bytesToWrite = (bb = this.buffer).remaining()) > 0) {
            out.put(bb);
            this.size -= bytesToWrite;
        }
    }

    public void sendTo(OutputStream out, ByteBuffer outBuf) throws IOException {
        this.finishWriting();
        if (this.chunks != null) {
            for (ByteBuffer bb : this.chunks) {
                this.sendTo(out, outBuf, bb);
            }
        }
        this.sendTo(out, outBuf, this.buffer);
        HeapDataOutputStream.flushStream((OutputStream)out, (ByteBuffer)outBuf);
    }

    private void sendTo(OutputStream out, ByteBuffer outBuf, ByteBuffer inBuf) throws IOException {
        this.size -= HeapDataOutputStream.writeByteBufferToStream(out, outBuf, inBuf);
    }

    public static int writeByteBufferToStream(OutputStream out, ByteBuffer outBuf, ByteBuffer inBuf) throws IOException {
        int bytesToWrite = inBuf.remaining();
        if (bytesToWrite > 0) {
            if (inBuf.hasArray()) {
                HeapDataOutputStream.flushStream((OutputStream)out, (ByteBuffer)outBuf);
                out.write(inBuf.array(), inBuf.arrayOffset() + inBuf.position(), bytesToWrite);
                inBuf.position(inBuf.limit());
            } else {
                int OUT_MAX = outBuf.remaining();
                for (int bytesToWriteThisTime = bytesToWrite; bytesToWriteThisTime > OUT_MAX; bytesToWriteThisTime -= OUT_MAX) {
                    int oldLimit = inBuf.limit();
                    inBuf.limit(inBuf.position() + OUT_MAX);
                    outBuf.put(inBuf);
                    inBuf.limit(oldLimit);
                    HeapDataOutputStream.flushStream((OutputStream)out, (ByteBuffer)outBuf);
                    OUT_MAX = outBuf.remaining();
                }
                outBuf.put(inBuf);
            }
        }
        return bytesToWrite;
    }

    public void sendTo(ByteBufferWriter out) {
        this.finishWriting();
        if (this.chunks != null) {
            for (ByteBuffer bb : this.chunks) {
                this.basicSendTo(out, bb);
            }
        }
        this.basicSendTo(out, this.buffer);
    }

    private void basicSendTo(ByteBufferWriter out, ByteBuffer bb) {
        int bytesToWrite = bb.remaining();
        if (bytesToWrite > 0) {
            out.write(bb.duplicate());
            this.size -= bytesToWrite;
        }
    }

    public void sendTo(DataOutput out) throws IOException {
        ByteBuffer bb;
        int bytesToWrite;
        this.finishWriting();
        if (this.chunks != null) {
            for (ByteBuffer bb2 : this.chunks) {
                int bytesToWrite2 = bb2.remaining();
                if (bytesToWrite2 <= 0) continue;
                if (bb2.hasArray()) {
                    out.write(bb2.array(), bb2.arrayOffset() + bb2.position(), bytesToWrite2);
                    bb2.position(bb2.limit());
                } else {
                    byte[] bytes = new byte[bytesToWrite2];
                    bb2.get(bytes);
                    out.write(bytes);
                }
                this.size -= bytesToWrite2;
            }
        }
        if ((bytesToWrite = (bb = this.buffer).remaining()) > 0) {
            if (bb.hasArray()) {
                out.write(bb.array(), bb.arrayOffset() + bb.position(), bytesToWrite);
                bb.position(bb.limit());
            } else {
                byte[] bytes = new byte[bytesToWrite];
                bb.get(bytes);
                out.write(bytes);
            }
            this.size -= bytesToWrite;
        }
    }

    @Override
    public void writeAsSerializedByteArray(Object v) throws IOException {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(5);
        if (v instanceof HeapDataOutputStream) {
            HeapDataOutputStream other = (HeapDataOutputStream)v;
            other.finishWriting();
            InternalDataSerializer.writeArrayLength(other.size(), this);
            if (this.doNotCopy) {
                if (other.chunks != null) {
                    for (ByteBuffer bb : other.chunks) {
                        this.write(bb);
                    }
                }
                this.write(other.buffer);
            } else {
                other.sendTo(this);
                other.rewind();
            }
        } else {
            ByteBuffer sizeBuf = this.buffer;
            int sizePos = sizeBuf.position();
            sizeBuf.position(sizePos + 5);
            int preArraySize = this.size();
            DataSerializer.writeObject(v, this);
            int arraySize = this.size() - preArraySize;
            sizeBuf.put(sizePos, (byte)-3);
            sizeBuf.putInt(sizePos + 1, arraySize);
        }
    }

    public void write(ByteBufferInputStream.ByteSource source) {
        ByteBuffer bb = source.getBackingByteBuffer();
        if (bb != null) {
            this.write(bb);
            return;
        }
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        int remainingSpace = this.buffer.limit() - this.buffer.position();
        if (remainingSpace < source.remaining()) {
            int oldLimit = source.limit();
            source.limit(source.position() + remainingSpace);
            source.sendTo(this.buffer);
            source.limit(oldLimit);
            this.ensureCapacity(source.remaining());
        }
        source.sendTo(this.buffer);
    }
}

