/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.EntryOperation;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.WrappedCallbackArgument;

public class EntryOperationImpl
implements EntryOperation {
    private final Region region;
    private final Operation operation;
    private final Object value;
    private final Object key;
    private final Object callbackArgument;

    public EntryOperationImpl(Region region, Operation operation, Object key, Object value, Object callbackArgument) {
        this.region = region;
        this.operation = operation;
        this.key = key;
        this.value = value;
        this.callbackArgument = callbackArgument;
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public Object getCallbackArgument() {
        Object result = this.callbackArgument;
        if (result == Token.NOT_AVAILABLE) {
            result = AbstractRegion.handleNotAvailable(result);
        } else if (result instanceof WrappedCallbackArgument) {
            WrappedCallbackArgument wca = (WrappedCallbackArgument)result;
            result = wca.getOriginalCallbackArg();
        }
        return result;
    }

    @Override
    public boolean isCallbackArgumentAvailable() {
        return this.callbackArgument != Token.NOT_AVAILABLE;
    }

    public Object getNewValue() {
        return this.value;
    }

    public Object getRawNewValue() {
        return this.value;
    }
}

