/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionExpiryTask;

class RegionIdleExpiryTask
extends RegionExpiryTask {
    RegionIdleExpiryTask(LocalRegion reg) {
        super(reg);
    }

    @Override
    public long getExpirationTime() throws EntryNotFoundException {
        ExpirationAction action = this.getAction();
        if ((action == ExpirationAction.INVALIDATE || action == ExpirationAction.LOCAL_INVALIDATE) && this.getLocalRegion().isRegionInvalid()) {
            int timeout = this.getIdleAttributes().getTimeout();
            if (timeout == 0) {
                return 0L;
            }
            timeout = (int)this.normalizeToMillis(timeout);
            return (long)timeout + this.getLocalRegion().cacheTimeMillis();
        }
        return this.getIdleExpirationTime();
    }

    @Override
    protected ExpirationAction getAction() {
        return this.getIdleAttributes().getAction();
    }

    @Override
    protected void addExpiryTask() {
        this.getLocalRegion().addIdleExpiryTask(this);
    }

    @Override
    public boolean isPending() {
        return false;
    }
}

