/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class UpdateAttributesProcessor {
    private static final Logger logger = LogService.getLogger();
    protected final DistributionAdvisee advisee;
    private boolean profileExchange = false;
    private boolean removeProfile = false;
    private ReplyProcessor21 processor;

    public UpdateAttributesProcessor(DistributionAdvisee da) {
        this(da, false);
    }

    public UpdateAttributesProcessor(DistributionAdvisee da, boolean removeProfile) {
        this.advisee = da;
        this.removeProfile = removeProfile;
    }

    void distribute() {
        this.distribute(false);
    }

    public void distribute(boolean exchangeProfiles) {
        this.sendProfileUpdate(exchangeProfiles);
        this.waitForProfileResponse();
    }

    public void waitForProfileResponse() {
        if (this.processor == null) {
            return;
        }
        DistributionManager mgr = this.advisee.getDistributionManager();
        try {
            mgr.getCancelCriterion().checkCancelInProgress(null);
            try {
                this.processor.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                e.handleCause();
            }
        }
        finally {
            this.processor.cleanup();
        }
    }

    public void sendProfileUpdate(boolean exchangeProfiles) {
        DistributionManager mgr = this.advisee.getDistributionManager();
        DistributionAdvisor advisor = this.advisee.getDistributionAdvisor();
        this.profileExchange = exchangeProfiles;
        if (!exchangeProfiles && (this.removeProfile ? !advisor.isInitialized() : advisor.initializationGate())) {
            return;
        }
        Set<InternalDistributedMember> recipients = this.removeProfile ? advisor.adviseProfileRemove() : (exchangeProfiles ? advisor.adviseProfileExchange() : advisor.adviseProfileUpdate());
        if (recipients.isEmpty()) {
            return;
        }
        UpdateAttributesReplyProcessor processor = null;
        InternalDistributedSystem system = this.advisee.getSystem();
        processor = new UpdateAttributesReplyProcessor(system, recipients);
        UpdateAttributesMessage message = this.getUpdateAttributesMessage(processor, recipients);
        mgr.putOutgoing(message);
        this.processor = processor;
    }

    UpdateAttributesMessage getUpdateAttributesMessage(ReplyProcessor21 processor, Set recipients) {
        UpdateAttributesMessage msg = new UpdateAttributesMessage();
        msg.adviseePath = this.advisee.getFullPath();
        msg.setRecipients(recipients);
        if (processor != null) {
            msg.processorId = processor.getProcessorId();
        }
        msg.profile = this.advisee.getProfile();
        msg.exchangeProfiles = this.profileExchange;
        msg.removeProfile = this.removeProfile;
        return msg;
    }

    public static class ProfilesReplyMessage
    extends ReplyMessage {
        DistributionAdvisor.Profile[] profiles;

        public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, ClusterDistributionManager dm, DistributionAdvisor.Profile[] profiles) {
            Assert.assertTrue(recipient != null, "Sending a ProfilesReplyMessage to ALL");
            ProfilesReplyMessage m = new ProfilesReplyMessage();
            m.processorId = processorId;
            m.profiles = profiles;
            if (exception != null) {
                m.setException(exception);
                if (logger.isDebugEnabled()) {
                    logger.debug("Replying with exception: {}" + m, (Throwable)exception);
                }
            }
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public int getDSFID() {
            return -92;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            int length = in.readInt();
            if (length == -1) {
                this.profiles = null;
            } else {
                DistributionAdvisor.Profile[] array = new DistributionAdvisor.Profile[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = (DistributionAdvisor.Profile)DataSerializer.readObject(in);
                }
                this.profiles = array;
            }
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            if (this.profiles == null) {
                out.writeInt(-1);
            } else {
                int length = this.profiles.length;
                out.writeInt(length);
                for (DistributionAdvisor.Profile profile : this.profiles) {
                    DataSerializer.writeObject(profile, out);
                }
            }
        }

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("ProfilesReplyMessage");
            buff.append(" (processorId=");
            buff.append(this.processorId);
            if (this.profiles != null) {
                buff.append("; profiles=");
                buff.append(Arrays.asList(this.profiles));
            }
            buff.append(")");
            return buff.toString();
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }
    }

    public static class ProfileReplyMessage
    extends ReplyMessage {
        DistributionAdvisor.Profile profile;

        public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, ClusterDistributionManager dm, DistributionAdvisor.Profile profile) {
            Assert.assertTrue(recipient != null, "Sending a ProfileReplyMessage to ALL");
            ProfileReplyMessage m = new ProfileReplyMessage();
            m.processorId = processorId;
            m.profile = profile;
            if (exception != null) {
                m.setException(exception);
                if (logger.isDebugEnabled()) {
                    logger.debug("Replying with exception: {}" + m, (Throwable)exception);
                }
            }
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public int getDSFID() {
            return 107;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.profile = (DistributionAdvisor.Profile)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeObject(this.profile, out);
        }

        @Override
        public String toString() {
            return "ProfileReplyMessage (processorId=" + this.processorId + "; profile=" + this.profile + ")";
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }
    }

    public static class UpdateAttributesMessage
    extends HighPriorityDistributionMessage
    implements MessageWithReply {
        protected String adviseePath;
        protected int processorId = 0;
        protected DistributionAdvisor.Profile profile;
        protected boolean exchangeProfiles = false;
        protected boolean removeProfile = false;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        public boolean sendViaUDP() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(ClusterDistributionManager dm) {
            Throwable thr = null;
            boolean sendReply = this.processorId != 0;
            ArrayList<DistributionAdvisor.Profile> replyProfiles = null;
            try {
                if (this.profile != null) {
                    if (this.exchangeProfiles) {
                        replyProfiles = new ArrayList<DistributionAdvisor.Profile>();
                    }
                    this.profile.processIncoming(dm, this.adviseePath, this.removeProfile, this.exchangeProfiles, replyProfiles);
                }
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("<cache closed> ///{}", (Object)this);
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                thr = t;
            }
            finally {
                if (sendReply) {
                    ReplyException rex = null;
                    if (thr != null) {
                        rex = new ReplyException(thr);
                    }
                    if (replyProfiles == null || replyProfiles.size() <= 1) {
                        DistributionAdvisor.Profile p = null;
                        if (replyProfiles != null && replyProfiles.size() == 1) {
                            p = (DistributionAdvisor.Profile)replyProfiles.get(0);
                        }
                        ProfileReplyMessage.send(this.getSender(), this.processorId, rex, dm, p);
                    } else {
                        DistributionAdvisor.Profile[] profiles = new DistributionAdvisor.Profile[replyProfiles.size()];
                        replyProfiles.toArray(profiles);
                        ProfilesReplyMessage.send(this.getSender(), this.processorId, rex, dm, profiles);
                    }
                }
            }
        }

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("UpdateAttributesMessage (adviseePath=");
            buff.append(this.adviseePath);
            buff.append("; processorId=");
            buff.append(this.processorId);
            buff.append("; profile=");
            buff.append(this.profile);
            if (this.exchangeProfiles) {
                buff.append("; exchangeProfiles");
            }
            if (this.removeProfile) {
                buff.append("; removeProfile");
            }
            buff.append(")");
            return buff.toString();
        }

        public int getDSFID() {
            return 106;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.adviseePath = DataSerializer.readString(in);
            this.processorId = in.readInt();
            ReplyProcessor21.setMessageRPId(this.processorId);
            this.profile = (DistributionAdvisor.Profile)DataSerializer.readObject(in);
            this.exchangeProfiles = in.readBoolean();
            this.removeProfile = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeString(this.adviseePath, out);
            out.writeInt(this.processorId);
            DataSerializer.writeObject(this.profile, out);
            out.writeBoolean(this.exchangeProfiles);
            out.writeBoolean(this.removeProfile);
        }
    }

    class UpdateAttributesReplyProcessor
    extends ReplyProcessor21 {
        UpdateAttributesReplyProcessor(InternalDistributedSystem system, Set members) {
            super(system, (Collection)members);
        }

        @Override
        protected Set addListenerAndGetMembers() {
            DistributionAdvisor da = UpdateAttributesProcessor.this.advisee.getDistributionAdvisor();
            if (da.useAdminMembersForDefault()) {
                return this.getDistributionManager().addAllMembershipListenerAndGetAllIds(this);
            }
            return super.addListenerAndGetMembers();
        }

        @Override
        protected void removeListener() {
            DistributionAdvisor da = UpdateAttributesProcessor.this.advisee.getDistributionAdvisor();
            if (da.useAdminMembersForDefault()) {
                this.getDistributionManager().removeAllMembershipListener(this);
            } else {
                super.removeListener();
            }
        }

        @Override
        protected Set getDistributionManagerIds() {
            DistributionAdvisor da = UpdateAttributesProcessor.this.advisee.getDistributionAdvisor();
            if (da.useAdminMembersForDefault()) {
                return this.getDistributionManager().getDistributionManagerIdsIncludingAdmin();
            }
            return super.getDistributionManagerIds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof ProfilesReplyMessage) {
                    ProfilesReplyMessage reply = (ProfilesReplyMessage)msg;
                    if (reply.profiles != null) {
                        for (int i = 0; i < reply.profiles.length; ++i) {
                            UpdateAttributesProcessor.this.advisee.getDistributionAdvisor().putProfile(reply.profiles[i]);
                        }
                    }
                } else if (msg instanceof ProfileReplyMessage) {
                    ProfileReplyMessage reply = (ProfileReplyMessage)msg;
                    if (reply.profile != null) {
                        UpdateAttributesProcessor.this.advisee.getDistributionAdvisor().putProfile(reply.profile);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }
    }
}

