/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.entries.VMThinRegionEntryHeap;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMThinRegionEntryHeapStringKey1
extends VMThinRegionEntryHeap {
    private static final AtomicLongFieldUpdater<VMThinRegionEntryHeapStringKey1> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VMThinRegionEntryHeapStringKey1.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile Object value;
    private final long bits1;

    public VMThinRegionEntryHeapStringKey1(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value);
        long tempBits1 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                tempBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                tempBits1 <<= 8;
            }
            tempBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                tempBits1 |= (long)key.charAt(i);
                tempBits1 <<= 16;
            }
        }
        this.bits1 = tempBits1 |= (long)key.length();
    }

    @Override
    protected Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object value) {
        this.value = value;
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public Object getKey() {
        int keyLength = this.getKeyLength();
        char[] chars = new char[keyLength];
        long tempBits1 = this.bits1;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keyLength; ++i) {
                chars[i] = (char)((tempBits1 >>= 8) & 0xFFL);
            }
        } else {
            for (int i = 0; i < keyLength; ++i) {
                chars[i] = (char)((tempBits1 >>= 16) & 0xFFFFL);
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof String) {
            String stringKey = (String)key;
            int keyLength = this.getKeyLength();
            if (stringKey.length() == keyLength) {
                long tempBits1 = this.bits1;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keyLength; ++i) {
                        char character = (char)((tempBits1 >>= 8) & 0xFFL);
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keyLength; ++i) {
                        char character = (char)((tempBits1 >>= 16) & 0xFFFFL);
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

