/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.Statistics;
import org.apache.geode.internal.cache.eviction.EvictionCounters;
import org.apache.geode.internal.cache.eviction.EvictionStats;

class EvictionCountersImpl
implements EvictionCounters {
    private final EvictionStats stats;
    private final AtomicLong counter = new AtomicLong();
    private final AtomicLong limit = new AtomicLong();
    private final AtomicLong destroys = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();

    public EvictionCountersImpl(EvictionStats stats) {
        this.stats = stats;
    }

    @Override
    public void incEvictions() {
        this.evictions.getAndAdd(1L);
        this.stats.incEvictions();
    }

    @Override
    public long getCounter() {
        return this.counter.get();
    }

    @Override
    public long getLimit() {
        return this.limit.get();
    }

    @Override
    public void updateCounter(long delta) {
        if (delta != 0L) {
            this.counter.getAndAdd(delta);
            this.stats.updateCounter(delta);
        }
    }

    @Override
    public long getEvictions() {
        return this.evictions.get();
    }

    @Override
    public Statistics getStatistics() {
        return this.stats.getStatistics();
    }

    @Override
    public void incDestroys() {
        this.destroys.getAndAdd(1L);
        this.stats.incDestroys();
    }

    @Override
    public void close() {
        this.stats.close();
    }

    @Override
    public void setLimit(long newValue) {
        long oldValue = this.limit.get();
        if (oldValue != newValue) {
            this.limit.set(newValue);
            this.stats.setLimit(newValue);
        }
    }

    @Override
    public void resetCounter() {
        if (this.counter.get() != 0L) {
            this.counter.set(0L);
            this.stats.setCounter(0L);
        }
    }

    @Override
    public void decrementCounter(long delta) {
        if (delta != 0L) {
            long newValue = this.counter.addAndGet(-delta);
            this.stats.setCounter(newValue);
        }
    }

    @Override
    public long getDestroys() {
        return this.destroys.get();
    }

    @Override
    public void incEvaluations(long evaluations) {
        this.stats.incEvaluations(evaluations);
    }

    @Override
    public void incGreedyReturns(long greedyReturns) {
        this.stats.incGreedyReturns(greedyReturns);
    }
}

