/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.PRHARedundancyProvider;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.RecoveryRunnable;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class CreateMissingBucketsTask
extends RecoveryRunnable {
    protected static final Logger logger = LogService.getLogger();
    static final int MAX_NUMBER_INTERVALS = 60;
    private static final int SMALL_200MS_INTERVALS = 5;
    private static final int SMALL_500MS_INTERVALS = 10;
    private static final int MEDIUM_1SEC_INTERVALS = 15;
    private static final int MEDIUM_2SEC_INTERVALS = 30;
    private static final int LARGE_5SEC_INTERVALS = 45;
    private int retryCount = 0;

    public CreateMissingBucketsTask(PRHARedundancyProvider prhaRedundancyProvider) {
        super(prhaRedundancyProvider);
    }

    @Override
    public void run2() {
        if (!this.waitForColocationCompleted(this.redundancyProvider.getPartitionedRegion())) {
            return;
        }
        if (this.redundancyProvider.getPartitionedRegion().isLocallyDestroyed || this.redundancyProvider.getPartitionedRegion().isClosed) {
            return;
        }
        PartitionedRegion leaderRegion = ColocationHelper.getLeaderRegion(this.redundancyProvider.getPartitionedRegion());
        PartitionedRegion.RecoveryLock lock = leaderRegion.getRecoveryLock();
        lock.lock();
        try {
            this.createMissingBuckets(this.redundancyProvider.getPartitionedRegion());
        }
        finally {
            lock.unlock();
        }
    }

    protected void createMissingBuckets(PartitionedRegion region) {
        PartitionedRegion parentRegion = ColocationHelper.getColocatedRegion(region);
        if (parentRegion == null) {
            return;
        }
        this.createMissingBuckets(parentRegion);
        for (int i = 0; i < region.getTotalNumberOfBuckets(); ++i) {
            if (region.isClosed || region.isLocallyDestroyed) {
                return;
            }
            if (parentRegion.getRegionAdvisor().getBucketAdvisor(i).getBucketRedundancy() == region.getRegionAdvisor().getBucketAdvisor(i).getBucketRedundancy()) continue;
            region.getRedundancyProvider().createBucketAtomically(i, 0, true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForColocationCompleted(PartitionedRegion partitionedRegion) {
        int sleepInterval = 100;
        while (!ColocationHelper.isColocationComplete(partitionedRegion) && this.retryCount < 60) {
            boolean interrupted = Thread.interrupted();
            try {
                logger.info("Waiting for collocation to complete, retry number {}", (Object)this.retryCount);
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException ignore) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (partitionedRegion.isLocallyDestroyed || partitionedRegion.isClosed) {
                return false;
            }
            ++this.retryCount;
            if (this.retryCount == 5) {
                sleepInterval = 200;
                continue;
            }
            if (this.retryCount == 10) {
                sleepInterval = 500;
                continue;
            }
            if (this.retryCount == 15) {
                sleepInterval = 1000;
                continue;
            }
            if (this.retryCount == 30) {
                sleepInterval = 2000;
                continue;
            }
            if (this.retryCount != 45) continue;
            sleepInterval = 5000;
        }
        return ColocationHelper.isColocationComplete(partitionedRegion);
    }

    int getRetryCount() {
        return this.retryCount;
    }
}

