/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.client.internal.ContainsKeyOp;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;
import org.jetbrains.annotations.NotNull;

public class ContainsKey66
extends BaseCommand {
    @Immutable
    private static final ContainsKey66 singleton = new ContainsKey66();

    public static Command getCommand() {
        return singleton;
    }

    private static void writeContainsKeyResponse(boolean containsKey, Message origMsg, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        responseMsg.addObjPart(containsKey ? Boolean.TRUE : Boolean.FALSE);
        responseMsg.send(servConn);
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException {
        boolean containsKey;
        Part regionNamePart = null;
        Part keyPart = null;
        String regionName = null;
        Object key = null;
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadContainsKeyRequestTime(start - oldStart);
        regionNamePart = clientMessage.getPart(0);
        keyPart = clientMessage.getPart(1);
        ContainsKeyOp.MODE mode = ContainsKeyOp.MODE.values()[clientMessage.getPart(2).getInt()];
        regionName = regionNamePart.getCachedString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            ContainsKey66.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received containsKey request ({} bytes) from {} for region {} key {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key);
        }
        if (key == null || regionName == null) {
            String errMessage = "";
            if (key == null) {
                logger.warn("{}: The input key for the containsKey request is null", (Object)serverConnection.getName());
                errMessage = "The input key for the containsKey request is null";
            }
            if (regionName == null) {
                logger.warn("{}: The input region name for the containsKey request is null", (Object)serverConnection.getName());
                errMessage = "The input region name for the containsKey request is null";
            }
            ContainsKey66.writeErrorResponse(clientMessage, 39, errMessage, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = "was not found during containsKey request";
            ContainsKey66.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, key);
        }
        catch (NotAuthorizedException ex) {
            ContainsKey66.writeException(clientMessage, ex, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
        if (authzRequest != null) {
            try {
                authzRequest.containsKeyAuthorize(regionName, key);
            }
            catch (NotAuthorizedException ex) {
                ContainsKey66.writeException(clientMessage, ex, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        switch (mode) {
            case KEY: {
                containsKey = region.containsKey(key);
                break;
            }
            case VALUE: {
                containsKey = region.containsValue(key);
                break;
            }
            case VALUE_FOR_KEY: {
                containsKey = region.containsValueForKey(key);
                break;
            }
            default: {
                containsKey = false;
            }
        }
        long oldStart2 = start;
        start = DistributionStats.getStatTime();
        stats.incProcessContainsKeyTime(start - oldStart2);
        ContainsKey66.writeContainsKeyResponse(containsKey, clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent containsKey response for region {} key {}", (Object)serverConnection.getName(), (Object)regionName, key);
        }
        stats.incWriteContainsKeyResponseTime(DistributionStats.getStatTime() - start);
    }
}

