/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.geode.internal.datasource.AbstractPoolCache;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.PoolException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ConnectionPoolCacheImpl
extends AbstractPoolCache {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -3096029291871746431L;
    private final ConnectionPoolDataSource m_cpds;

    public ConnectionPoolCacheImpl(ConnectionPoolDataSource connectionpooldatasource, ConnectionEventListener eventListner, ConfiguredDataSourceProperties configs) throws PoolException {
        super(eventListner, configs);
        this.m_cpds = connectionpooldatasource;
        this.initializePool();
    }

    @Override
    void destroyPooledConnection(Object connectionObject) {
        block2: {
            try {
                ((PooledConnection)connectionObject).removeConnectionEventListener((ConnectionEventListener)this.connEventListner);
                ((PooledConnection)connectionObject).close();
                connectionObject = null;
            }
            catch (Exception ex) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace("AbstractPoolcache::destroyPooledConnection:Exception in closing the connection.Ignoring it. The exeption is {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    @Override
    public Object getNewPoolConnection() throws PoolException {
        if (this.m_cpds != null) {
            PooledConnection poolConn = null;
            try {
                poolConn = this.m_cpds.getPooledConnection(this.configProps.getUser(), this.configProps.getPassword());
            }
            catch (SQLException sqx) {
                throw new PoolException("ConnectionPoolCacheImpl::getNewConnection: Exception in creating new PooledConnection", sqx);
            }
            poolConn.addConnectionEventListener((ConnectionEventListener)this.connEventListner);
            return poolConn;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ConnectionPoolCacheImpl::geNewConnection: ConnectionPoolCache not intialized with ConnectionPoolDatasource");
        }
        throw new PoolException("ConnectionPoolCacheImpl::getNewConnection: ConnectionPoolCache not initialized with ConnectionPoolDatasource");
    }
}

