/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics.platform;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;
import org.apache.geode.internal.statistics.platform.ProcessStats;

public class LinuxProcessStats {
    static final int imageSizeLONG;
    static final int rssSizeLONG;
    @Immutable
    private static final StatisticsType myType;

    private LinuxProcessStats() {
    }

    public static StatisticsType getType() {
        return myType;
    }

    public static ProcessStats createProcessStats(final Statistics stats) {
        return new ProcessStats(stats){

            @Override
            public long getProcessSize() {
                return stats.getLong(rssSizeLONG);
            }
        };
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        myType = f.createType("LinuxProcessStats", "Statistics on a Linux process.", new StatisticDescriptor[]{f.createLongGauge("imageSize", "The size of the process's image in megabytes.", "megabytes"), f.createLongGauge("rssSize", "The size of the process's resident set size in megabytes. (assumes PAGESIZE=4096, specify -Dgemfire.statistics.linux.pageSize=<pagesize> to adjust)", "megabytes")});
        imageSizeLONG = myType.nameToId("imageSize");
        rssSizeLONG = myType.nameToId("rssSize");
    }
}

