/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal;

import org.apache.geode.logging.internal.spi.SessionContext;

public interface InternalSessionContext
extends SessionContext {
    public State getState();

    public static enum State {
        CREATED,
        STARTED,
        STOPPED;


        public State changeTo(State newState) {
            switch (newState) {
                case CREATED: {
                    if (this != STOPPED) {
                        throw new IllegalStateException("Session must not exist before creating");
                    }
                    return CREATED;
                }
                case STARTED: {
                    if (this != CREATED) {
                        throw new IllegalStateException("Session must be created before starting");
                    }
                    return STARTED;
                }
                case STOPPED: {
                    if (this == STARTED) break;
                    throw new IllegalStateException("Session must be started before stopping");
                }
            }
            return STOPPED;
        }
    }
}

