/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.util;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class ClasspathScanLoadHelper
implements AutoCloseable {
    private final ScanResult scanResult;

    public ClasspathScanLoadHelper(Collection<String> packagesToScan) {
        this(packagesToScan.toArray(new String[0]));
    }

    public ClasspathScanLoadHelper(String ... packagesToScan) {
        this.scanResult = new ClassGraph().acceptPackages(packagesToScan).enableClassInfo().enableAnnotationInfo().scan(1);
    }

    public Set<Class<?>> scanPackagesForClassesImplementing(Class<?> implementedInterface, String ... onlyFromPackages) {
        ClassInfoList classInfoList = this.scanResult.getClassesImplementing(implementedInterface.getName()).filter(ci -> !ci.isAbstract() && !ci.isInterface() && ci.isPublic());
        classInfoList = classInfoList.filter(ci -> Arrays.stream(onlyFromPackages).anyMatch(p -> ClasspathScanLoadHelper.classMatchesPackage(ci.getName(), p)));
        return classInfoList.loadClasses().stream().collect(Collectors.toSet());
    }

    public Set<Class<?>> scanClasspathForAnnotation(Class<?> annotation, String ... onlyFromPackages) {
        ClassInfoList classInfoList = this.scanResult.getClassesWithAnnotation(annotation.getName());
        classInfoList = classInfoList.filter(ci -> Arrays.stream(onlyFromPackages).anyMatch(p -> ClasspathScanLoadHelper.classMatchesPackage(ci.getName(), p)));
        return classInfoList.loadClasses().stream().collect(Collectors.toSet());
    }

    private static String globToRegex(String glob) {
        return "^" + glob.replace(".", "\\.").replace("*", ".*") + "$";
    }

    private static boolean classMatchesPackage(String className, String packageSpec) {
        if (!packageSpec.contains("*")) {
            return className.startsWith(packageSpec);
        }
        return className.matches(ClasspathScanLoadHelper.globToRegex(packageSpec));
    }

    @Override
    public void close() {
        if (this.scanResult != null) {
            this.scanResult.close();
        }
    }
}

