/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.util;

import java.net.UnknownHostException;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.lang.StringUtils;

public class HostUtils {
    private static final String LOCALHOST = "localhost";

    public static String getLocalHost() {
        try {
            return LocalHostUtil.getCanonicalLocalHostName();
        }
        catch (UnknownHostException ignore) {
            return LOCALHOST;
        }
    }

    public static String getLocatorId(String host, Integer port) {
        String locatorHost = host != null ? host : HostUtils.getLocalHost();
        String locatorPort = StringUtils.defaultString(port, String.valueOf(10334));
        return locatorHost.concat("[").concat(locatorPort).concat("]");
    }

    public static String getServerId(String host, Integer port) {
        String serverHost = host != null ? host : HostUtils.getLocalHost();
        String serverPort = StringUtils.defaultString(port, String.valueOf(40404));
        return serverHost.concat("[").concat(serverPort).concat("]");
    }
}

