/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.pdx.PdxInitializationException;
import org.apache.geode.pdx.internal.PeerTypeRegistration;
import org.apache.geode.pdx.internal.TypeRegistration;
import org.apache.geode.pdx.internal.TypeRegistry;

public class CheckTypeRegistryState
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private int processorId;

    public CheckTypeRegistryState() {
    }

    protected CheckTypeRegistryState(int processorId) {
        this.processorId = processorId;
    }

    public static void send(DistributionManager dm) {
        Set<InternalDistributedMember> recipients = dm.getOtherDistributionManagerIds();
        ReplyProcessor21 replyProcessor = new ReplyProcessor21(dm, recipients);
        CheckTypeRegistryState msg = new CheckTypeRegistryState(replyProcessor.getProcessorId());
        msg.setRecipients(recipients);
        dm.putOutgoing(msg);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (e.getCause() instanceof PdxInitializationException) {
                throw new PdxInitializationException("Bad PDX configuration on member " + e.getSender() + ": " + e.getCause().getMessage(), e.getCause());
            }
            throw new InternalGemFireError("Unexpected exception", e);
        }
        catch (InterruptedException e) {
            throw new InternalGemFireError("Unexpected exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        ReplyException e = null;
        try {
            TypeRegistration registry;
            TypeRegistry pdxRegistry;
            InternalCache cache = dm.getCache();
            if (cache != null && !cache.isClosed() && (pdxRegistry = cache.getPdxRegistry()) != null && (registry = pdxRegistry.getTypeRegistration()) instanceof PeerTypeRegistration) {
                PeerTypeRegistration peerRegistry = (PeerTypeRegistration)registry;
                peerRegistry.verifyConfiguration();
            }
        }
        catch (Exception ex) {
            e = new ReplyException(ex);
        }
        finally {
            ReplyMessage rm = new ReplyMessage();
            rm.setException(e);
            rm.setProcessorId(this.processorId);
            rm.setRecipient(this.getSender());
            dm.putOutgoing(rm);
        }
    }

    public int getDSFID() {
        return 2128;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = in.readInt();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.processorId);
    }
}

