/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.api.JsonSerializable;
import org.apache.geode.management.runtime.CacheServerInfo;
import org.apache.geode.management.runtime.RuntimeInfo;

@Experimental
public class MemberInformation
extends RuntimeInfo
implements Identifiable<String>,
JsonSerializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String workingDirPath;
    private String groups;
    private String logFilePath;
    private String statArchiveFilePath;
    private String serverBindAddress;
    private String locators;
    private String status;
    private long heapUsage;
    private long maxHeapSize;
    private long initHeapSize;
    private String cacheXmlFilePath;
    private String host;
    private int processId;
    private int locatorPort;
    private int httpServicePort;
    private String httpServiceBindAddress;
    private boolean isServer;
    private final List<CacheServerInfo> cacheServerList = new ArrayList<CacheServerInfo>();
    private int clientCount;
    private double cpuUsage;
    private Set<String> hostedRegions;
    private String offHeapMemorySize;
    private boolean webSSL;
    private boolean isSecured;
    private boolean isCoordinator;

    public boolean isSecured() {
        return this.isSecured;
    }

    public void setSecured(boolean secured) {
        this.isSecured = secured;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getWorkingDirPath() {
        return this.workingDirPath;
    }

    public void setWorkingDirPath(String workingDirPath) {
        this.workingDirPath = workingDirPath;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public String getStatArchiveFilePath() {
        return this.statArchiveFilePath;
    }

    public void setStatArchiveFilePath(String statArchiveFilePath) {
        this.statArchiveFilePath = statArchiveFilePath;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUsage(double cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public String getServerBindAddress() {
        return this.serverBindAddress;
    }

    public void setServerBindAddress(String serverBindAddress) {
        this.serverBindAddress = serverBindAddress;
    }

    public String getLocators() {
        return this.locators;
    }

    public void setLocators(String locators) {
        this.locators = locators;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getHeapUsage() {
        return this.heapUsage;
    }

    public void setHeapUsage(long heapUsage) {
        this.heapUsage = heapUsage;
    }

    public long getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(long maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public String getCacheXmlFilePath() {
        return this.cacheXmlFilePath;
    }

    public void setCacheXmlFilePath(String cacheXmlFilePath) {
        this.cacheXmlFilePath = cacheXmlFilePath;
    }

    public long getInitHeapSize() {
        return this.initHeapSize;
    }

    public void setInitHeapSize(long initHeapSize) {
        this.initHeapSize = initHeapSize;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public int getLocatorPort() {
        return this.locatorPort;
    }

    public void setLocatorPort(int locatorPort) {
        this.locatorPort = locatorPort;
    }

    public int getHttpServicePort() {
        return this.httpServicePort;
    }

    public void setHttpServicePort(int httpServicePort) {
        this.httpServicePort = httpServicePort;
    }

    public String getHttpServiceBindAddress() {
        return this.httpServiceBindAddress;
    }

    public void setHttpServiceBindAddress(String httpServiceBindAddress) {
        this.httpServiceBindAddress = httpServiceBindAddress;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public void setServer(boolean isServer) {
        this.isServer = isServer;
    }

    public List<CacheServerInfo> getCacheServerInfo() {
        return this.cacheServerList;
    }

    public void addCacheServerInfo(CacheServerInfo cacheServerInfo) {
        if (cacheServerInfo == null) {
            return;
        }
        this.cacheServerList.add(cacheServerInfo);
    }

    public int getClientCount() {
        return this.clientCount;
    }

    public void setClientCount(int clientCount) {
        this.clientCount = clientCount;
    }

    public Set<String> getHostedRegions() {
        return this.hostedRegions;
    }

    public void setHostedRegions(Set<String> hostedRegions) {
        this.hostedRegions = hostedRegions;
    }

    public String getOffHeapMemorySize() {
        return this.offHeapMemorySize;
    }

    public void setOffHeapMemorySize(String v) {
        this.offHeapMemorySize = v;
    }

    public boolean isWebSSL() {
        return this.webSSL;
    }

    public void setWebSSL(boolean webSSL) {
        this.webSSL = webSSL;
    }

    public boolean isCoordinator() {
        return this.isCoordinator;
    }

    public void setCoordinator(boolean coordinator) {
        this.isCoordinator = coordinator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberInformation)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MemberInformation that = (MemberInformation)o;
        return this.getHeapUsage() == that.getHeapUsage() && this.getMaxHeapSize() == that.getMaxHeapSize() && this.getInitHeapSize() == that.getInitHeapSize() && this.getProcessId() == that.getProcessId() && this.getLocatorPort() == that.getLocatorPort() && this.getHttpServicePort() == that.getHttpServicePort() && this.isServer() == that.isServer() && this.getClientCount() == that.getClientCount() && Double.compare(that.getCpuUsage(), this.getCpuUsage()) == 0 && this.isWebSSL() == that.isWebSSL() && this.isSecured() == that.isSecured() && this.isCoordinator() == that.isCoordinator() && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getWorkingDirPath(), that.getWorkingDirPath()) && Objects.equals(this.getGroups(), that.getGroups()) && Objects.equals(this.getLogFilePath(), that.getLogFilePath()) && Objects.equals(this.getStatArchiveFilePath(), that.getStatArchiveFilePath()) && Objects.equals(this.getServerBindAddress(), that.getServerBindAddress()) && Objects.equals(this.getLocators(), that.getLocators()) && Objects.equals(this.getStatus(), that.getStatus()) && Objects.equals(this.getCacheXmlFilePath(), that.getCacheXmlFilePath()) && Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getHttpServiceBindAddress(), that.getHttpServiceBindAddress()) && Objects.equals(this.cacheServerList, that.cacheServerList) && Objects.equals(this.getHostedRegions(), that.getHostedRegions()) && Objects.equals(this.getOffHeapMemorySize(), that.getOffHeapMemorySize());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getId(), this.getWorkingDirPath(), this.getGroups(), this.getLogFilePath(), this.getStatArchiveFilePath(), this.getServerBindAddress(), this.getLocators(), this.getStatus(), this.getHeapUsage(), this.getMaxHeapSize(), this.getInitHeapSize(), this.getCacheXmlFilePath(), this.getHost(), this.getProcessId(), this.getLocatorPort(), this.getHttpServicePort(), this.getHttpServiceBindAddress(), this.isServer(), this.cacheServerList, this.getClientCount(), this.getCpuUsage(), this.getHostedRegions(), this.getOffHeapMemorySize(), this.isWebSSL(), this.isSecured(), this.isCoordinator());
    }
}

