/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;

public class MemberJvmOptions {
    static final int CMS_INITIAL_OCCUPANCY_FRACTION = 60;
    private static final String SUN_NIO_CH_EXPORT = "--add-exports=java.base/sun.nio.ch=ALL-UNNAMED";
    private static final String COM_SUN_JMX_REMOTE_SECURITY_EXPORT = "--add-exports=java.management/com.sun.jmx.remote.security=ALL-UNNAMED";
    private static final String JAVA_LANG_OPEN = "--add-opens=java.base/java.lang=ALL-UNNAMED";
    private static final String JAVA_NIO_OPEN = "--add-opens=java.base/java.nio=ALL-UNNAMED";
    private static final String COM_SUN_MANAGEMENT_INTERNAL_OPEN = "--add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED";
    static final List<String> JAVA_11_OPTIONS = Arrays.asList("--add-exports=java.management/com.sun.jmx.remote.security=ALL-UNNAMED", "--add-exports=java.base/sun.nio.ch=ALL-UNNAMED", "--add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED", "--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-opens=java.base/java.nio=ALL-UNNAMED");

    public static List<String> getMemberJvmOptions() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11)) {
            return JAVA_11_OPTIONS;
        }
        return Collections.emptyList();
    }

    public static List<String> getGcJvmOptions(List<String> commandLine) {
        if (SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13)) {
            ArrayList<String> cmsOptions = new ArrayList<String>();
            String collectorKey = "-XX:+UseConcMarkSweepGC";
            if (!commandLine.contains(collectorKey)) {
                cmsOptions.add(collectorKey);
            }
            String occupancyFractionKey = "-XX:CMSInitiatingOccupancyFraction=";
            if (commandLine.stream().noneMatch(s -> s.contains(occupancyFractionKey))) {
                cmsOptions.add(occupancyFractionKey + 60);
            }
            return cmsOptions;
        }
        return Collections.emptyList();
    }
}

