/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.management.internal.cli.CliUtils;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;

public class CloseDurableCqFunction
implements InternalFunction<String[]> {
    private static final long serialVersionUID = 1L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.CloseDurableCqFunction";

    public String getId() {
        return ID;
    }

    public void execute(FunctionContext<String[]> context) {
        Cache cache = context.getCache();
        String memberNameOrId = CliUtils.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        String[] args = (String[])context.getArguments();
        String durableClientId = args[0];
        String cqName = args[1];
        context.getResultSender().lastResult((Object)this.createFunctionResult(memberNameOrId, durableClientId, cqName));
    }

    private CliFunctionResult createFunctionResult(String memberNameOrId, String durableClientId, String cqName) {
        CacheClientNotifier cacheClientNotifier = CacheClientNotifier.getInstance();
        try {
            if (cacheClientNotifier == null) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, "No client found on this server");
            }
            CacheClientProxy cacheClientProxy = cacheClientNotifier.getClientProxy(durableClientId);
            if (cacheClientProxy == null) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"No client found with client-id : {0}", (Object)durableClientId));
            }
            if (cacheClientNotifier.closeClientCq(durableClientId, cqName)) {
                return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, CliStrings.format((String)"Closed the durable cq : \"{0}\" for the durable client : \"{1}\".", (Object[])new Object[]{cqName, durableClientId}));
            }
            return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, CliStrings.format((String)"Unable to close the durable cq : \"{0}\" for the durable client : \"{1}\".", (Object[])new Object[]{cqName, durableClientId}));
        }
        catch (Exception e) {
            return new CliFunctionResult(memberNameOrId, (Object)e);
        }
    }
}

