/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.blocks.LazyRemovalCache;
import org.jgroups.util.Util;

public class UUID
implements Address {
    private static final long serialVersionUID = -6194072960039354716L;
    protected long mostSigBits;
    protected long leastSigBits;
    protected static volatile SecureRandom numberGenerator;
    protected static final LazyRemovalCache<Address, String> cache;
    protected static boolean print_uuids;
    protected static final int SIZE = 16;
    protected static final LazyRemovalCache.Printable<Address, LazyRemovalCache.Entry<String>> print_function;

    public UUID() {
    }

    public UUID(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
    }

    protected UUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        if (data.length != 16) {
            throw new RuntimeException("UUID needs a 16-byte array");
        }
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this.mostSigBits = msb;
        this.leastSigBits = lsb;
    }

    public static void add(Address uuid, String logical_name) {
        cache.add(uuid, logical_name);
    }

    public static void add(Map<Address, String> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<Address, String> entry : map.entrySet()) {
            UUID.add(entry.getKey(), entry.getValue());
        }
    }

    public static String get(Address logical_addr) {
        return cache.get(logical_addr);
    }

    public static Address getByName(String logical_name) {
        return cache.getByValue(logical_name);
    }

    public static Map<Address, String> getContents() {
        return cache.contents();
    }

    public static void remove(Address addr) {
        cache.remove(addr);
    }

    public static void removeAll(Collection<Address> mbrs) {
        cache.removeAll(mbrs);
    }

    public static void retainAll(Collection<Address> logical_addrs) {
        cache.retainAll(logical_addrs);
    }

    public static String printCache() {
        return cache.printCache(print_function);
    }

    public static UUID randomUUID() {
        return new UUID(UUID.generateRandomBytes());
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public String toString() {
        if (print_uuids) {
            return this.toStringLong();
        }
        String val = cache.get(this);
        return val != null ? val : this.toStringLong();
    }

    public String toStringLong() {
        return UUID.digits(this.mostSigBits >> 32, 8) + "-" + UUID.digits(this.mostSigBits >> 16, 4) + "-" + UUID.digits(this.mostSigBits, 4) + "-" + UUID.digits(this.leastSigBits >> 48, 4) + "-" + UUID.digits(this.leastSigBits, 12);
    }

    public static UUID fromString(String name) {
        String[] components = name.split("-");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + name);
        }
        for (int i = 0; i < 5; ++i) {
            components[i] = "0x" + components[i];
        }
        long mostSigBits = Long.decode(components[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(components[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(components[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(components[2]).longValue(), leastSigBits |= Long.decode(components[4]).longValue());
    }

    protected static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public int hashCode() {
        return (int)(this.mostSigBits >> 32 ^ this.mostSigBits ^ this.leastSigBits >> 32 ^ this.leastSigBits);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        UUID id = (UUID)obj;
        return this == id || this.mostSigBits == id.mostSigBits && this.leastSigBits == id.leastSigBits;
    }

    @Override
    public int compareTo(Address other) {
        UUID val = (UUID)other;
        if (this == val) {
            return 0;
        }
        return this.mostSigBits < val.mostSigBits ? -1 : (this.mostSigBits > val.mostSigBits ? 1 : (this.leastSigBits < val.leastSigBits ? -1 : (this.leastSigBits > val.leastSigBits ? 1 : 0)));
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeLong(this.leastSigBits);
        out.writeLong(this.mostSigBits);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.leastSigBits = in.readLong();
        this.mostSigBits = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.leastSigBits);
        out.writeLong(this.mostSigBits);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.leastSigBits = in.readLong();
        this.mostSigBits = in.readLong();
    }

    @Override
    public int size() {
        return 16;
    }

    public UUID copy() {
        return new UUID(this.mostSigBits, this.leastSigBits);
    }

    protected static byte[] generateRandomBytes() {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        return randomBytes;
    }

    static {
        String tmp;
        numberGenerator = null;
        print_uuids = false;
        print_function = new LazyRemovalCache.Printable<Address, LazyRemovalCache.Entry<String>>(){

            @Override
            public String print(Address key, LazyRemovalCache.Entry<String> entry) {
                return entry.getVal() + ": " + (key instanceof UUID ? ((UUID)key).toStringLong() : key) + "\n";
            }
        };
        int max_elements = 500;
        long max_age = 5000L;
        try {
            tmp = Util.getProperty(new String[]{"jgroups.uuid_cache.max_elements"}, null, null, "500");
            if (tmp != null) {
                max_elements = Integer.valueOf(tmp);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tmp = Util.getProperty(new String[]{"jgroups.uuid_cache.max_age"}, null, null, "120000");
            if (tmp != null) {
                max_age = Long.valueOf(tmp);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        cache = new LazyRemovalCache(max_elements, max_age);
        try {
            tmp = Util.getProperty(new String[]{"jgroups.print_uuids"}, null, null, "false");
            print_uuids = Boolean.valueOf(tmp);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

