/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteOutputStreamServer;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.util.OutputStreamAdapter;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRemoteOutputStream
extends RemoteOutputStreamServer {
    private static final long serialVersionUID = 20080212L;
    private final transient OutputStreamAdapter _outAdapter;

    public SimpleRemoteOutputStream(OutputStream out) {
        this(out, DUMMY_MONITOR);
    }

    public SimpleRemoteOutputStream(OutputStream out, RemoteStreamMonitor<RemoteOutputStreamServer> monitor) {
        super(out, monitor);
        this._outAdapter = OutputStreamAdapter.create(out);
    }

    @Override
    public boolean usingGZIPCompression() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushImpl() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            this._out.flush();
        }
    }

    @Override
    protected void writePacket(byte[] packet) throws IOException {
        this._outAdapter.writePacket(packet);
        this._monitor.localBytesMoved(this, packet.length);
    }
}

