/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio.util;

import com.healthmarketscience.rmiio.PacketInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class InputStreamAdapter {
    private InputStreamAdapter() {
    }

    public abstract InputStream getInputStream();

    public abstract byte[] readPacket() throws IOException;

    public abstract byte[] getTempBuffer();

    public abstract int readTemp() throws IOException;

    public static InputStreamAdapter create(InputStream istream, int packetSize) {
        if (istream instanceof PacketInputStream) {
            return new PacketAdapter((PacketInputStream)istream);
        }
        return new DefaultAdapter(istream, packetSize);
    }

    private static class DefaultAdapter
    extends InputStreamAdapter {
        private final InputStream _istream;
        private final byte[] _temp;

        private DefaultAdapter(InputStream istream, int packetSize) {
            this._istream = istream;
            this._temp = new byte[packetSize];
        }

        public InputStream getInputStream() {
            return this._istream;
        }

        public byte[] readPacket() throws IOException {
            return PacketInputStream.readPacket(this._istream, this._temp);
        }

        public byte[] getTempBuffer() {
            return this._temp;
        }

        public int readTemp() throws IOException {
            return this._istream.read(this._temp, 0, this._temp.length);
        }
    }

    private static class PacketAdapter
    extends InputStreamAdapter {
        private final PacketInputStream _pistream;
        private byte[] _temp;

        private PacketAdapter(PacketInputStream pistream) {
            this._pistream = pistream;
        }

        public PacketInputStream getInputStream() {
            return this._pistream;
        }

        public byte[] readPacket() throws IOException {
            return this._pistream.readPacket();
        }

        public byte[] getTempBuffer() {
            return this._temp;
        }

        public int readTemp() throws IOException {
            this._temp = this._pistream.readPacket();
            return this._temp != null ? this._temp.length : -1;
        }
    }
}

