/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.serialization.AbstractVersion;

@Immutable
public class KnownVersion
extends AbstractVersion {
    private final transient String name;
    private final transient String productName;
    private final transient String methodSuffix;
    private final byte major;
    private final byte minor;
    private final byte release;
    private final byte patch;
    private final boolean modifiesClientServerProtocol;
    public static final int HIGHEST_VERSION = 150;
    @Immutable
    private static final KnownVersion[] VALUES = new KnownVersion[151];
    static final byte TOKEN_ORDINAL = -1;
    static final int TOKEN_ORDINAL_INT = 255;
    @Immutable
    public static final KnownVersion TOKEN = new KnownVersion("", "TOKEN", -1, 0, 0, 0, -1, true);
    private static final short GFE_81_ORDINAL = 35;
    @Immutable
    public static final KnownVersion GFE_81 = new KnownVersion("GFE", "8.1", 8, 1, 0, 0, 35, true);
    private static final short GFE_90_ORDINAL = 45;
    @Immutable
    public static final KnownVersion GFE_90 = new KnownVersion("GFE", "9.0", 9, 0, 0, 0, 45, true);
    private static final short GEODE_1_1_0_ORDINAL = 50;
    @Immutable
    public static final KnownVersion GEODE_1_1_0 = new KnownVersion("GEODE", "1.1.0", 1, 1, 0, 0, 50, true);
    private static final short GEODE_1_1_1_ORDINAL = 55;
    @Immutable
    public static final KnownVersion GEODE_1_1_1 = new KnownVersion("GEODE", "1.1.1", 1, 1, 1, 0, 55, true);
    private static final short GEODE_1_2_0_ORDINAL = 65;
    @Immutable
    public static final KnownVersion GEODE_1_2_0 = new KnownVersion("GEODE", "1.2.0", 1, 2, 0, 0, 65, true);
    private static final short GEODE_1_3_0_ORDINAL = 70;
    @Immutable
    public static final KnownVersion GEODE_1_3_0 = new KnownVersion("GEODE", "1.3.0", 1, 3, 0, 0, 70, true);
    private static final short GEODE_1_4_0_ORDINAL = 75;
    @Immutable
    public static final KnownVersion GEODE_1_4_0 = new KnownVersion("GEODE", "1.4.0", 1, 4, 0, 0, 75, true);
    private static final short GEODE_1_5_0_ORDINAL = 80;
    @Immutable
    public static final KnownVersion GEODE_1_5_0 = new KnownVersion("GEODE", "1.5.0", 1, 5, 0, 0, 80, true);
    private static final short GEODE_1_6_0_ORDINAL = 85;
    @Immutable
    public static final KnownVersion GEODE_1_6_0 = new KnownVersion("GEODE", "1.6.0", 1, 6, 0, 0, 85, true);
    private static final short GEODE_1_7_0_ORDINAL = 90;
    @Immutable
    public static final KnownVersion GEODE_1_7_0 = new KnownVersion("GEODE", "1.7.0", 1, 7, 0, 0, 90, true);
    private static final short GEODE_1_8_0_ORDINAL = 95;
    @Immutable
    public static final KnownVersion GEODE_1_8_0 = new KnownVersion("GEODE", "1.8.0", 1, 8, 0, 0, 95, true);
    private static final short GEODE_1_9_0_ORDINAL = 100;
    @Immutable
    public static final KnownVersion GEODE_1_9_0 = new KnownVersion("GEODE", "1.9.0", 1, 9, 0, 0, 100, true);
    private static final byte GEODE_1_10_0_ORDINAL = 105;
    @Immutable
    public static final KnownVersion GEODE_1_10_0 = new KnownVersion("GEODE", "1.10.0", 1, 10, 0, 0, 105, true);
    private static final short GEODE_1_11_0_ORDINAL = 110;
    @Immutable
    public static final KnownVersion GEODE_1_11_0 = new KnownVersion("GEODE", "1.11.0", 1, 11, 0, 0, 110, true);
    private static final short GEODE_1_12_0_ORDINAL = 115;
    @Immutable
    public static final KnownVersion GEODE_1_12_0 = new KnownVersion("GEODE", "1.12.0", 1, 12, 0, 0, 115, true);
    private static final short GEODE_1_12_1_ORDINAL = 116;
    @Immutable
    public static final KnownVersion GEODE_1_12_1 = new KnownVersion("GEODE", "1.12.1", 1, 12, 1, 0, 116, true);
    private static final short GEODE_1_13_0_ORDINAL = 120;
    @Immutable
    public static final KnownVersion GEODE_1_13_0 = new KnownVersion("GEODE", "1.13.0", 1, 13, 0, 0, 120, true);
    private static final short GEODE_1_13_2_ORDINAL = 121;
    @Immutable
    public static final KnownVersion GEODE_1_13_2 = new KnownVersion("GEODE", "1.13.2", 1, 13, 1, 0, 121, true);
    private static final short GEODE_1_14_0_ORDINAL = 125;
    @Immutable
    public static final KnownVersion GEODE_1_14_0 = new KnownVersion("GEODE", "1.14.0", 1, 14, 0, 0, 125, true);
    private static final short GEODE_1_15_0_ORDINAL = 150;
    @Immutable
    public static final KnownVersion GEODE_1_15_0 = new KnownVersion("GEODE", "1.15.0", 1, 15, 0, 0, 150, true);
    @Immutable
    public static final KnownVersion OLDEST = GFE_81;
    @Immutable
    public static final KnownVersion CURRENT = GEODE_1_15_0;
    @Immutable
    public static final short CURRENT_ORDINAL = CURRENT.ordinal();
    private static final short validOrdinalForTesting = 2;
    @Immutable
    public static final KnownVersion TEST_VERSION = new KnownVersion("TEST", "VERSION", 0, 0, 0, 0, 2, true);

    private KnownVersion(String productName, String name, byte major, byte minor, byte release, byte patch, short ordinal) {
        this(productName, name, major, minor, release, patch, ordinal, false);
    }

    private KnownVersion(String productName, String name, byte major, byte minor, byte release, byte patch, short ordinal, boolean modifiesClientServerProtocol) {
        super(ordinal);
        this.productName = productName;
        this.name = name;
        this.major = major;
        this.minor = minor;
        this.release = release;
        this.patch = patch;
        this.modifiesClientServerProtocol = modifiesClientServerProtocol;
        this.methodSuffix = this.productName + "_" + this.major + "_" + this.minor + "_" + this.release + "_" + this.patch;
        if (ordinal != -1) {
            KnownVersion.VALUES[ordinal] = this;
        }
    }

    public static KnownVersion getCurrentVersion() {
        return CURRENT;
    }

    public KnownVersion getClientServerProtocolVersion() {
        for (short i = this.ordinal(); i >= 0; i = (short)(i - 1)) {
            if (VALUES[i] == null || !KnownVersion.VALUES[i].modifiesClientServerProtocol) continue;
            return VALUES[i];
        }
        throw new IllegalStateException("There is no valid clientServerProtocolVersion for " + this);
    }

    public static String unsupportedVersionMessage(short ordinal) {
        return String.format("Peer or client version with ordinal %s not supported. Highest known version is %s", ordinal, KnownVersion.CURRENT.name);
    }

    public String getMethodSuffix() {
        return this.methodSuffix;
    }

    public String getName() {
        return this.name;
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public short getRelease() {
        return this.release;
    }

    public short getPatch() {
        return this.patch;
    }

    @Override
    public String toString() {
        return this.productName + " " + this.name;
    }

    public static Iterable<? extends KnownVersion> getAllVersions() {
        return Arrays.stream(VALUES).filter(x -> x != null && x != TEST_VERSION).collect(Collectors.toList());
    }

    public static KnownVersion getKnownVersion(short ordinal) {
        if (ordinal == -1) {
            return TOKEN;
        }
        if (ordinal < -1 || ordinal >= VALUES.length) {
            return null;
        }
        return VALUES[ordinal];
    }

    public boolean hasClientServerProtocolChange() {
        return this.modifiesClientServerProtocol;
    }
}

