/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;

public class QueueACLsManager {
    private static final Log LOG = LogFactory.getLog(QueueACLsManager.class);
    private ResourceScheduler scheduler;
    private boolean isACLsEnable;
    private YarnAuthorizationProvider authorizer;

    @VisibleForTesting
    public QueueACLsManager() {
        this(null, new Configuration());
    }

    public QueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        this.scheduler = scheduler;
        this.isACLsEnable = conf.getBoolean("yarn.acl.enable", false);
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
    }

    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, RMApp app, String remoteAddress, List<String> forwardedAddresses) {
        if (!this.isACLsEnable) {
            return true;
        }
        if (this.scheduler instanceof CapacityScheduler) {
            CSQueue queue = ((CapacityScheduler)this.scheduler).getQueue(app.getQueue());
            if (queue == null) {
                LOG.error((Object)("Queue " + app.getQueue() + " does not exist for " + app.getApplicationId()));
                return true;
            }
            return this.authorizer.checkPermission(new AccessRequest(queue.getPrivilegedEntity(), callerUGI, SchedulerUtils.toAccessType(acl), app.getApplicationId().toString(), app.getName(), remoteAddress, forwardedAddresses));
        }
        return this.scheduler.checkAccess(callerUGI, acl, app.getQueue());
    }
}

