/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class BackupObserver
implements RegionCoprocessor,
RegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(BackupObserver.class);

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void postBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> stagingFamilyPaths, Map<byte[], List<Path>> finalPaths) throws IOException {
        Configuration cfg = ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration();
        if (finalPaths == null) {
            return;
        }
        if (!BackupManager.isBackupEnabled(cfg)) {
            LOG.debug("skipping recording bulk load in postBulkLoadHFile since backup is disabled");
            return;
        }
        this.registerBulkLoad(ctx, finalPaths);
    }

    public void preCommitStoreFile(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] family, List<Pair<Path, Path>> pairs) throws IOException {
        Configuration cfg = ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration();
        if (pairs == null || pairs.isEmpty() || !BackupManager.isBackupEnabled(cfg)) {
            LOG.debug("skipping recording bulk load in preCommitStoreFile since backup is disabled");
            return;
        }
        ArrayList<Object> hfiles = new ArrayList<Object>(pairs.size());
        for (Pair<Path, Path> pair : pairs) {
            hfiles.add(pair.getSecond());
        }
        this.registerBulkLoad(ctx, Collections.singletonMap(family, hfiles));
    }

    private void registerBulkLoad(ObserverContext<? extends RegionCoprocessorEnvironment> ctx, Map<byte[], List<Path>> cfToHFilePaths) throws IOException {
        Configuration cfg = ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration();
        RegionInfo region = ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegionInfo();
        TableName tableName = region.getTable();
        try (Connection connection = ConnectionFactory.createConnection((Configuration)cfg);
             BackupSystemTable tbl = new BackupSystemTable(connection);){
            Set<TableName> fullyBackedUpTables = tbl.getTablesIncludedInBackups();
            if (fullyBackedUpTables.contains(tableName)) {
                tbl.registerBulkLoad(tableName, region.getEncodedNameAsBytes(), cfToHFilePaths);
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Table {} has not gone through full backup - skipping.", (Object)tableName);
            }
        }
    }
}

