/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.ByteArrayInputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.ipc.SimpleByteBufAllocator;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@Category(value={RPCTests.class, MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestNettyRpcServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNettyRpcServer.class);
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final int NUM_ROWS = 100;
    private static final int MIN_LEN = 1000;
    private static final int MAX_LEN = 1000000;
    protected static final LoadTestKVGenerator GENERATOR = new LoadTestKVGenerator(1000, 1000000);
    protected static HBaseTestingUtility TEST_UTIL;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();
    @Parameterized.Parameter
    public String allocatorType;
    private static final String CERTIFICATE = "-----BEGIN CERTIFICATE-----\nMIIEITCCAwmgAwIBAgIUaLL8vLOhWLCLXVHEJqXJhfmsTB8wDQYJKoZIhvcNAQEL\nBQAwgawxCzAJBgNVBAYTAlVTMRYwFAYDVQQIDA1NYXNzYWNodXNldHRzMRIwEAYD\nVQQHDAlDYW1icmlkZ2UxGDAWBgNVBAoMD25ldHR5IHRlc3QgY2FzZTEYMBYGA1UE\nCwwPbmV0dHkgdGVzdCBjYXNlMRgwFgYDVQQDDA9uZXR0eSB0ZXN0IGNhc2UxIzAh\nBgkqhkiG9w0BCQEWFGNjb25uZWxsQGh1YnNwb3QuY29tMB4XDTI0MDEyMTE5MzMy\nMFoXDTI1MDEyMDE5MzMyMFowgawxCzAJBgNVBAYTAlVTMRYwFAYDVQQIDA1NYXNz\nYWNodXNldHRzMRIwEAYDVQQHDAlDYW1icmlkZ2UxGDAWBgNVBAoMD25ldHR5IHRl\nc3QgY2FzZTEYMBYGA1UECwwPbmV0dHkgdGVzdCBjYXNlMRgwFgYDVQQDDA9uZXR0\neSB0ZXN0IGNhc2UxIzAhBgkqhkiG9w0BCQEWFGNjb25uZWxsQGh1YnNwb3QuY29t\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAy+qzEZpQMjVdLj0siUcG\ny8LIHOW4S+tgHIKFkF865qWq6FVGbROe2Z0f5W6yIamZkdxzptT0iv+8S5okNNeW\n2NbsN/HNJIRtWfxku1Jh1gBqSkAYIjXyq7+20hIaJTzzxqike9M/Lc14EGb33Ja/\nkDPRV3UtiM3Ntf3eALXKbrWptkbgQngCaTgtfg8IkMAEpP270wZ9fW0lDHv3NPPt\nZt0QSJzWSqWfu+l4ayvcUQYyNJesx9YmTHSJu69lvT4QApoX8FEiHfNCJ28R50CS\naIgOpCWUvkH7rqx0p9q393uJRS/S6RlLbU30xUN1fNrVmP/XAapfy+R0PSgiUi8o\nEQIDAQABozkwNzAWBgNVHRIEDzANggt3d3cuZm9vLmNvbTAdBgNVHQ4EFgQUl4FD\nY8jJ/JHJR68YqPsGUjUJuwgwDQYJKoZIhvcNAQELBQADggEBADVzivYz2M0qsWUc\njXjCHymwTIr+7ud10um53FbYEAfKWsIY8Pp35fKpFzUwc5wVdCnLU86K/YMKRzNB\nzL2Auow3PJFRvXecOv7dWxNlNneLDcwbVrdNRu6nQXmZUgyz0oUKuJbF+JGtI+7W\nkRw7yhBfki+UCSQWeDqvaWzgmA4Us0N8NFq3euAs4xFbMMPMQWrT9Z7DGchCeRiB\ndkQBvh88vbR3v2Saq14W4Wt5rj2++vXWGQSeAQL6nGbOwc3ohW6isNNV0eGQQTmS\nkhS2d/JDZq2XL5RGexf3CA6YYzWiTr9YZHNjuobvLH7mVnA2c8n6Zty/UhfnuK1x\nJbkleFk=\n-----END CERTIFICATE-----";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"pooled"}, {"unpooled"}, {"heap"}, {SimpleByteBufAllocator.class.getName()});
    }

    @Before
    public void setup() throws Exception {
        if (TEST_UTIL == null) {
            TEST_UTIL = new HBaseTestingUtility();
        }
        TEST_UTIL.getConfiguration().set("hbase.rpc.server.impl", NettyRpcServer.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.netty.rpcserver.allocator", this.allocatorType);
        TEST_UTIL.startMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testNettyRpcServer() throws Exception {
        this.doTest(this.name.getTableName());
    }

    protected void doTest(TableName tableName) throws Exception {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionSplitPolicyClassName(DisabledRegionSplitPolicy.class.getName()).build();
        try (Table table = TEST_UTIL.createTable(desc, (byte[][])new byte[][]{FAMILY}, TEST_UTIL.getConfiguration());){
            byte[] rowKey;
            int i;
            for (i = 0; i < 100; ++i) {
                rowKey = Bytes.toBytes((String)LoadTestKVGenerator.md5PrefixedKey((long)i));
                byte[] v = GENERATOR.generateRandomSizeValue((byte[][])new byte[][]{rowKey, QUALIFIER});
                table.put(new Put(rowKey).addColumn(FAMILY, QUALIFIER, v));
            }
            for (i = 0; i < 100; ++i) {
                rowKey = Bytes.toBytes((String)LoadTestKVGenerator.md5PrefixedKey((long)i));
                Result r = table.get(new Get(rowKey).addColumn(FAMILY, QUALIFIER));
                Assert.assertNotNull((String)"Result was empty", (Object)r);
                byte[] v = r.getValue(FAMILY, QUALIFIER);
                Assert.assertNotNull((String)"Result did not contain expected value", (Object)v);
                Assert.assertTrue((String)"Value was not verified", (boolean)LoadTestKVGenerator.verify((byte[])v, (byte[][])new byte[][]{rowKey, QUALIFIER}));
            }
        }
    }

    @Test
    public void testHandshakeCompleteHandler() throws SSLPeerUnverifiedException, CertificateException {
        NettyServerRpcConnection conn = (NettyServerRpcConnection)Mockito.mock(NettyServerRpcConnection.class);
        SslHandler sslHandler = (SslHandler)Mockito.mock(SslHandler.class);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", 5555);
        SSLEngine engine = (SSLEngine)Mockito.mock(SSLEngine.class);
        SSLSession session = (SSLSession)Mockito.mock(SSLSession.class);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CERTIFICATE.getBytes(StandardCharsets.UTF_8)));
        Object[] certificates = new Certificate[]{x509Certificate};
        Mockito.when((Object)sslHandler.engine()).thenReturn((Object)engine);
        Mockito.when((Object)engine.getSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getPeerCertificates()).thenReturn((Object)certificates);
        NettyRpcServer.sslHandshakeCompleteHandler((NettyServerRpcConnection)conn, (SslHandler)sslHandler, (SocketAddress)remoteAddress);
        Assert.assertArrayEquals((Object[])certificates, (Object[])conn.clientCertificateChain);
    }
}

