/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.master.procedure.TruncateTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestTruncateTableProcedureWithRecovery
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTruncateTableProcedureWithRecovery.class);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.snapshot.before.destructive.action.enabled", true);
        TestTableDDLProcedureBase.setupCluster();
    }

    @Test
    public void testRecoverySnapshotRollback() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String[] families = new String[]{"f1", "f2"};
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, null, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, new byte[0][], families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getAdmin().disableTable(tableName);
        long procId = procExec.submitProcedure((Procedure)new FailingTruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((String)"Procedure should have failed", (boolean)result.isFailed());
        boolean snapshotFound = false;
        for (SnapshotDescription snapshot : UTIL.getAdmin().listSnapshots()) {
            if (!snapshot.getName().startsWith("auto_" + tableName.getNameAsString())) continue;
            snapshotFound = true;
            break;
        }
        Assert.assertTrue((String)"Recovery snapshot should have been cleaned up during rollback", (!snapshotFound ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverySnapshotAndRestore() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName restoredTableName = TableName.valueOf((String)(this.name.getMethodName() + "_restored"));
        String[] families = new String[]{"f1", "f2"};
        MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, null, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, new byte[0][], families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        Assert.assertEquals((long)0L, (long)UTIL.countRows(tableName));
        String recoverySnapshotName = null;
        for (SnapshotDescription snapshot : UTIL.getAdmin().listSnapshots()) {
            if (!snapshot.getName().startsWith("auto_" + tableName.getNameAsString())) continue;
            recoverySnapshotName = snapshot.getName();
            break;
        }
        Assert.assertTrue((String)"Recovery snapshot should exist", (recoverySnapshotName != null ? 1 : 0) != 0);
        UTIL.getAdmin().cloneSnapshot(recoverySnapshotName, restoredTableName);
        UTIL.waitUntilAllRegionsAssigned(restoredTableName);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(restoredTableName));
        UTIL.getAdmin().disableTable(restoredTableName);
        UTIL.getAdmin().deleteTable(restoredTableName);
    }

    public static class FailingTruncateTableProcedure
    extends TruncateTableProcedure {
        private boolean failOnce = false;

        public FailingTruncateTableProcedure() {
        }

        public FailingTruncateTableProcedure(MasterProcedureEnv env, TableName tableName, boolean preserveSplits) throws HBaseIOException {
            super(env, tableName, preserveSplits);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.TruncateTableState state) throws InterruptedException {
            if (!this.failOnce && state == MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_CLEAR_FS_LAYOUT) {
                this.failOnce = true;
                throw new RuntimeException("Simulated failure");
            }
            return super.executeFromState(env, state);
        }
    }
}

