/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.AverageIntervalRateLimiter;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.quotas.ThrottleQuotaTestUtil;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestBlockBytesScannedQuota {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlockBytesScannedQuota.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockBytesScannedQuota.class);
    private static final int REFRESH_TIME = 5000;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final TableName TABLE_NAME = TableName.valueOf((String)"BlockBytesScannedQuotaTest");
    private static final long MAX_SCANNER_RESULT_SIZE = 0x6400000L;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        TEST_UTIL.getConfiguration().setLong("hbase.server.scanner.max.result.size", 0x6400000L);
        TEST_UTIL.getConfiguration().setClass("hbase.quota.rate.limiter", AverageIntervalRateLimiter.class, RateLimiter.class);
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 5000);
        TEST_UTIL.getConfiguration().setFloat("hfile.block.cache.size", 0.0f);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        EnvironmentEdgeManager.reset();
        TEST_UTIL.deleteTable(TABLE_NAME);
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        ThrottleQuotaTestUtil.clearQuotaCache(TEST_UTIL);
    }

    @Test
    public void testBBSGet() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        int blockSize = admin.getDescriptor(TABLE_NAME).getColumnFamily(FAMILY).getBlocksize();
        Table table = admin.getConnection().getTable(TABLE_NAME);
        ThrottleQuotaTestUtil.doPuts(10000, FAMILY, QUALIFIER, table);
        TEST_UTIL.flush(TABLE_NAME);
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.READ_SIZE, (long)Math.round(10.1 * (double)blockSize), (TimeUnit)TimeUnit.SECONDS));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doGets(20, FAMILY, QUALIFIER, table), 10L, 1L);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        this.testTraffic(() -> ThrottleQuotaTestUtil.doGets(20, FAMILY, QUALIFIER, table), 10L, 1L);
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAME);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doGets(100, FAMILY, QUALIFIER, table), 100L, 0L);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doGets(100, FAMILY, QUALIFIER, table), 100L, 0L);
    }

    @Test
    public void testBBSScan() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        int blockSize = admin.getDescriptor(TABLE_NAME).getColumnFamily(FAMILY).getBlocksize();
        Table table = admin.getConnection().getTable(TABLE_NAME);
        ThrottleQuotaTestUtil.doPuts(10000, FAMILY, QUALIFIER, table);
        TEST_UTIL.flush(TABLE_NAME);
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)blockSize, (TimeUnit)TimeUnit.SECONDS));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        this.testTraffic(() -> ThrottleQuotaTestUtil.doScans(5, table, 1), 1L, 0L);
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAME);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doScans(100, table, 1), 100L, 0L);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doScans(100, table, 1), 100L, 0L);
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)Math.round(3.1 * (double)blockSize), (TimeUnit)TimeUnit.SECONDS));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)Math.round(50.1 * (double)blockSize), (TimeUnit)TimeUnit.SECONDS));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        this.testTraffic(() -> ThrottleQuotaTestUtil.doScans(100, table, 1), 75L, 25L);
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        this.testTraffic(() -> ThrottleQuotaTestUtil.doScans(10000, table, 10000), 10000L, 0L);
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAME);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doScans(100, table, 1), 100L, 0L);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doScans(100, table, 1), 100L, 0L);
    }

    @Test
    public void testSmallScanNeverBlockedByLargeEstimate() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        Table table = admin.getConnection().getTable(TABLE_NAME);
        ThrottleQuotaTestUtil.doPuts(10000, FAMILY, QUALIFIER, table);
        TEST_UTIL.flush(TABLE_NAME);
        long limit = 0x6300000L;
        Assert.assertTrue((limit <= 0x6400000L ? 1 : 0) != 0);
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)limit, (TimeUnit)TimeUnit.SECONDS));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        this.testTraffic(() -> ThrottleQuotaTestUtil.doScans(10000, table, 1), 10000L, 0L);
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAME);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doScans(100, table, 1), 100L, 0L);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doScans(100, table, 1), 100L, 0L);
    }

    @Test
    public void testBBSMultiGet() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        int blockSize = admin.getDescriptor(TABLE_NAME).getColumnFamily(FAMILY).getBlocksize();
        Table table = admin.getConnection().getTable(TABLE_NAME);
        int rowCount = 10000;
        ThrottleQuotaTestUtil.doPuts(rowCount, FAMILY, QUALIFIER, table);
        TEST_UTIL.flush(TABLE_NAME);
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)blockSize, (TimeUnit)TimeUnit.SECONDS));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        this.testTraffic(() -> ThrottleQuotaTestUtil.doMultiGets(10, 10, rowCount, FAMILY, QUALIFIER, table), 1L, 1L);
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAME);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doMultiGets(100, 10, rowCount, FAMILY, QUALIFIER, table), 100L, 0L);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doMultiGets(100, 10, rowCount, FAMILY, QUALIFIER, table), 100L, 0L);
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)Math.round(100.1 * (double)blockSize), (TimeUnit)TimeUnit.SECONDS));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doMultiGets(20, 10, rowCount, FAMILY, QUALIFIER, table), 10L, 1L);
        ThrottleQuotaTestUtil.waitMinuteQuota();
        this.testTraffic(() -> ThrottleQuotaTestUtil.doMultiGets(20, 10, rowCount, FAMILY, QUALIFIER, table), 10L, 1L);
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAME);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doMultiGets(100, 10, rowCount, FAMILY, QUALIFIER, table), 100L, 0L);
        this.testTraffic(() -> ThrottleQuotaTestUtil.doMultiGets(100, 10, rowCount, FAMILY, QUALIFIER, table), 100L, 0L);
    }

    private void testTraffic(Callable<Long> trafficCallable, long expectedSuccess, long marginOfError) throws Exception {
        TEST_UTIL.waitFor(5000L, () -> {
            boolean success;
            long actualSuccess;
            try {
                actualSuccess = (Long)trafficCallable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            LOG.info("Traffic test yielded {} successful requests. Expected {} +/- {}", new Object[]{actualSuccess, expectedSuccess, marginOfError});
            boolean bl = success = actualSuccess >= expectedSuccess - marginOfError && actualSuccess <= expectedSuccess + marginOfError;
            if (!success) {
                ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
                ThrottleQuotaTestUtil.waitMinuteQuota();
            }
            return success;
        });
    }
}

