/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupAdmin;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupRequest;
import org.apache.hadoop.hbase.backup.BackupRestoreConstants;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.RestoreRequest;
import org.apache.hadoop.hbase.backup.impl.BackupAdminImpl;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomRsExceptMetaAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.PeriodicRandomActionPolicy;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestBackupRestore
extends IntegrationTestBase {
    private static final String CLASS_NAME = IntegrationTestBackupRestore.class.getSimpleName();
    protected static final Logger LOG = LoggerFactory.getLogger(IntegrationTestBackupRestore.class);
    protected static final String NUMBER_OF_TABLES_KEY = "num_tables";
    protected static final String COLUMN_NAME = "f";
    protected static final String REGION_COUNT_KEY = "regions_per_rs";
    protected static final String REGIONSERVER_COUNT_KEY = "region_servers";
    protected static final String ROWS_PER_ITERATION_KEY = "rows_in_iteration";
    protected static final String NUM_ITERATIONS_KEY = "num_iterations";
    protected static final int DEFAULT_REGION_COUNT = 10;
    protected static final int DEFAULT_REGIONSERVER_COUNT = 5;
    protected static final int DEFAULT_NUMBER_OF_TABLES = 1;
    protected static final int DEFAULT_NUM_ITERATIONS = 10;
    protected static final int DEFAULT_ROWS_IN_ITERATION = 10000;
    protected static final String SLEEP_TIME_KEY = "sleeptime";
    protected static final long SLEEP_TIME_DEFAULT = 50000L;
    protected static int rowsInIteration;
    protected static int regionsCountPerServer;
    protected static int regionServerCount;
    protected static int numIterations;
    protected static int numTables;
    protected static TableName[] tableNames;
    protected long sleepTime;
    protected static Object lock;
    private static String BACKUP_ROOT_DIR;

    @Override
    @Before
    public void setUp() throws Exception {
        this.util = new IntegrationTestingUtility();
        Configuration conf = this.util.getConfiguration();
        regionsCountPerServer = conf.getInt(REGION_COUNT_KEY, 10);
        regionServerCount = conf.getInt(REGIONSERVER_COUNT_KEY, 5);
        rowsInIteration = conf.getInt(ROWS_PER_ITERATION_KEY, 10000);
        numIterations = conf.getInt(NUM_ITERATIONS_KEY, 10);
        numTables = conf.getInt(NUMBER_OF_TABLES_KEY, 1);
        this.sleepTime = conf.getLong(SLEEP_TIME_KEY, 50000L);
        this.enableBackup(conf);
        LOG.info("Initializing cluster with {} region servers.", (Object)regionServerCount);
        this.util.initializeCluster(regionServerCount);
        LOG.info("Cluster initialized and ready");
    }

    @After
    public void tearDown() throws IOException {
        LOG.info("Cleaning up after test.");
        if (this.util.isDistributedCluster()) {
            this.deleteTablesIfAny();
            LOG.info("Cleaning up after test. Deleted tables");
            this.cleanUpBackupDir();
        }
        LOG.info("Restoring cluster.");
        this.util.restoreCluster();
        LOG.info("Cluster restored.");
    }

    @Override
    public void setUpMonkey() throws Exception {
        PeriodicRandomActionPolicy p = new PeriodicRandomActionPolicy(this.sleepTime, new RestartRandomRsExceptMetaAction(this.sleepTime));
        this.monkey = new PolicyBasedChaosMonkey(this.util, p);
        this.startMonkey();
    }

    private void deleteTablesIfAny() throws IOException {
        for (TableName table : tableNames) {
            this.util.deleteTableIfAny(table);
        }
    }

    private void createTables() throws Exception {
        tableNames = new TableName[numTables];
        for (int i = 0; i < numTables; ++i) {
            IntegrationTestBackupRestore.tableNames[i] = TableName.valueOf((String)(CLASS_NAME + ".table." + i));
        }
        for (TableName table : tableNames) {
            this.createTable(table);
        }
    }

    private void enableBackup(Configuration conf) {
        conf.setBoolean("hbase.backup.enable", true);
        BackupManager.decorateMasterConfiguration((Configuration)conf);
        BackupManager.decorateRegionServerConfiguration((Configuration)conf);
    }

    private void cleanUpBackupDir() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.util.getConfiguration());
        fs.delete(new Path(BACKUP_ROOT_DIR), true);
    }

    @Test
    public void testBackupRestore() throws Exception {
        BACKUP_ROOT_DIR = this.util.getDataTestDirOnTestFS() + "/" + BACKUP_ROOT_DIR;
        this.createTables();
        this.runTestMulti();
    }

    private void runTestMulti() throws Exception {
        LOG.info("IT backup & restore started");
        Thread[] workers = new Thread[numTables];
        BackupAndRestoreThread[] backupAndRestoreThreads = new BackupAndRestoreThread[numTables];
        for (int i = 0; i < numTables; ++i) {
            BackupAndRestoreThread backupAndRestoreThread;
            TableName table = tableNames[i];
            backupAndRestoreThreads[i] = backupAndRestoreThread = new BackupAndRestoreThread(table);
            workers[i] = new Thread(backupAndRestoreThread);
            workers[i].start();
        }
        Throwable error = null;
        for (int i = 0; i < numTables; ++i) {
            Uninterruptibles.joinUninterruptibly((Thread)workers[i]);
            Throwable threadThrowable = backupAndRestoreThreads[i].getThrowable();
            if (threadThrowable == null) continue;
            if (error == null) {
                error = threadThrowable;
                continue;
            }
            error.addSuppressed(threadThrowable);
        }
        if (error != null) {
            throw new AssertionError("An error occurred in a backup and restore thread", error);
        }
        LOG.info("IT backup & restore finished");
    }

    private void createTable(TableName tableName) throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        TableDescriptor desc = builder.build();
        ColumnFamilyDescriptorBuilder cbuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])COLUMN_NAME.getBytes(Charset.defaultCharset()));
        ColumnFamilyDescriptor[] columns = new ColumnFamilyDescriptor[]{cbuilder.build()};
        LOG.info("Creating table {} with {} splits.", (Object)tableName, (Object)(regionsCountPerServer * regionServerCount));
        long startTime = EnvironmentEdgeManager.currentTime();
        HBaseTestingUtility.createPreSplitLoadTestTable((Configuration)this.util.getConfiguration(), (TableDescriptor)desc, (ColumnFamilyDescriptor[])columns, (int)regionsCountPerServer);
        this.util.waitTableAvailable(tableName);
        long endTime = EnvironmentEdgeManager.currentTime();
        LOG.info("Pre-split table created successfully in {}ms.", (Object)(endTime - startTime));
    }

    private void loadData(TableName table, int numRows) throws IOException {
        Connection conn = this.util.getConnection();
        Table t1 = conn.getTable(table);
        this.util.loadRandomRows(t1, new byte[]{102}, 100, numRows);
        conn.getAdmin().flush(TableName.valueOf((byte[])table.getName()));
    }

    private String backup(BackupRequest request, BackupAdmin client) throws IOException {
        return client.backupTables(request);
    }

    private void restore(RestoreRequest request, BackupAdmin client) throws IOException {
        client.restore(request);
    }

    private void merge(String[] backupIds, BackupAdmin client) throws IOException {
        client.mergeBackups(backupIds);
    }

    private void runTestSingle(TableName table) throws IOException {
        ArrayList<String> backupIds = new ArrayList<String>();
        try (Connection conn = this.util.getConnection();
             Admin admin = conn.getAdmin();
             BackupAdminImpl client = new BackupAdminImpl(conn);){
            this.loadData(table, rowsInIteration);
            LOG.info("create full backup image for {}", (Object)table);
            ArrayList tables = Lists.newArrayList((Object[])new TableName[]{table});
            BackupRequest.Builder builder = new BackupRequest.Builder();
            BackupRequest request = builder.withBackupType(BackupType.FULL).withTableList((List)tables).withTargetRootDir(BACKUP_ROOT_DIR).build();
            String backupIdFull = this.backup(request, (BackupAdmin)client);
            Assert.assertTrue((boolean)this.checkSucceeded(backupIdFull));
            backupIds.add(backupIdFull);
            int count = 1;
            while (count++ < numIterations) {
                this.loadData(table, rowsInIteration);
                builder = new BackupRequest.Builder();
                request = builder.withBackupType(BackupType.INCREMENTAL).withTableList((List)tables).withTargetRootDir(BACKUP_ROOT_DIR).build();
                String backupId = this.backup(request, (BackupAdmin)client);
                Assert.assertTrue((boolean)this.checkSucceeded(backupId));
                backupIds.add(backupId);
                String previousBackupId = (String)backupIds.get(backupIds.size() - 2);
                this.restoreVerifyTable(conn, (BackupAdmin)client, table, previousBackupId, rowsInIteration * (count - 1));
                this.restoreVerifyTable(conn, (BackupAdmin)client, table, backupId, rowsInIteration * count);
            }
            String[] incBackupIds = this.allIncremental(backupIds);
            this.merge(incBackupIds, (BackupAdmin)client);
            String backupId = incBackupIds[incBackupIds.length - 1];
            TableName[] tablesRestoreIncMultiple = new TableName[]{table};
            this.restore(this.createRestoreRequest(BACKUP_ROOT_DIR, backupId, false, tablesRestoreIncMultiple, null, true), (BackupAdmin)client);
            Table hTable = conn.getTable(table);
            Assert.assertEquals((long)this.util.countRows(hTable), (long)(rowsInIteration * numIterations));
            hTable.close();
            LOG.info("{} loop {} finished.", (Object)Thread.currentThread().getName(), (Object)(count - 1));
        }
    }

    private void restoreVerifyTable(Connection conn, BackupAdmin client, TableName table, String backupId, long expectedRows) throws IOException {
        TableName[] tablesRestoreIncMultiple = new TableName[]{table};
        this.restore(this.createRestoreRequest(BACKUP_ROOT_DIR, backupId, false, tablesRestoreIncMultiple, null, true), client);
        Table hTable = conn.getTable(table);
        Assert.assertEquals((long)expectedRows, (long)this.util.countRows(hTable));
        hTable.close();
    }

    private String[] allIncremental(List<String> backupIds) {
        int size = backupIds.size();
        backupIds = backupIds.subList(1, size);
        String[] arr = new String[size - 1];
        backupIds.toArray(arr);
        return arr;
    }

    protected boolean checkSucceeded(String backupId) throws IOException {
        BackupInfo status = this.getBackupInfo(backupId);
        if (status == null) {
            return false;
        }
        return status.getState() == BackupInfo.BackupState.COMPLETE;
    }

    private BackupInfo getBackupInfo(String backupId) throws IOException {
        try (BackupSystemTable table = new BackupSystemTable(this.util.getConnection());){
            BackupInfo backupInfo = table.readBackupInfo(backupId);
            return backupInfo;
        }
    }

    public RestoreRequest createRestoreRequest(String backupRootDir, String backupId, boolean check, TableName[] fromTables, TableName[] toTables, boolean isOverwrite) {
        RestoreRequest.Builder builder = new RestoreRequest.Builder();
        return builder.withBackupRootDir(backupRootDir).withBackupId(backupId).withCheck(check).withFromTables(fromTables).withToTables(toTables).withOvewrite(isOverwrite).build();
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        this.enableBackup(this.getConf());
        LOG.debug("Initializing/checking cluster has {} servers", (Object)regionServerCount);
        this.util.initializeCluster(regionServerCount);
        LOG.debug("Done initializing/checking cluster");
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        if (!BackupManager.isBackupEnabled((Configuration)this.getConf())) {
            System.err.println(BackupRestoreConstants.ENABLE_BACKUP);
            return -1;
        }
        System.out.println(BackupRestoreConstants.VERIFY_BACKUP);
        this.testBackupRestore();
        return 0;
    }

    @Override
    public TableName getTablename() {
        return null;
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return null;
    }

    @Override
    protected void addOptions() {
        this.addOptWithArg(REGIONSERVER_COUNT_KEY, "Total number of region servers. Default: '5'");
        this.addOptWithArg(REGION_COUNT_KEY, "Total number of regions. Default: 10");
        this.addOptWithArg(ROWS_PER_ITERATION_KEY, "Total number of data rows to be loaded during one iteration. Default: 10000");
        this.addOptWithArg(NUM_ITERATIONS_KEY, "Total number iterations. Default: 10");
        this.addOptWithArg(NUMBER_OF_TABLES_KEY, "Total number of tables in the test. Default: 1");
        this.addOptWithArg(SLEEP_TIME_KEY, "Sleep time of chaos monkey in ms to restart random region server. Default: 50000");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        super.processOptions(cmd);
        regionsCountPerServer = Integer.parseInt(cmd.getOptionValue(REGION_COUNT_KEY, Integer.toString(10)));
        regionServerCount = Integer.parseInt(cmd.getOptionValue(REGIONSERVER_COUNT_KEY, Integer.toString(5)));
        rowsInIteration = Integer.parseInt(cmd.getOptionValue(ROWS_PER_ITERATION_KEY, Integer.toString(10000)));
        numIterations = Integer.parseInt(cmd.getOptionValue(NUM_ITERATIONS_KEY, Integer.toString(10)));
        numTables = Integer.parseInt(cmd.getOptionValue(NUMBER_OF_TABLES_KEY, Integer.toString(1)));
        this.sleepTime = Long.parseLong(cmd.getOptionValue(SLEEP_TIME_KEY, Long.toString(50000L)));
        LOG.info(MoreObjects.toStringHelper((String)"Parsed Options").add(REGION_COUNT_KEY, regionsCountPerServer).add(REGIONSERVER_COUNT_KEY, regionServerCount).add(ROWS_PER_ITERATION_KEY, rowsInIteration).add(NUM_ITERATIONS_KEY, numIterations).add(NUMBER_OF_TABLES_KEY, numTables).add(SLEEP_TIME_KEY, this.sleepTime).toString());
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int status = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestBackupRestore(), (String[])args);
        System.exit(status);
    }

    static {
        lock = new Object();
        BACKUP_ROOT_DIR = "backupIT";
    }

    protected class BackupAndRestoreThread
    implements Runnable {
        private final TableName table;
        private Throwable throwable;

        public BackupAndRestoreThread(TableName table) {
            this.table = table;
            this.throwable = null;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public void run() {
            try {
                IntegrationTestBackupRestore.this.runTestSingle(this.table);
            }
            catch (Throwable t) {
                LOG.error("An error occurred in thread {} when performing a backup and restore with table {}: ", new Object[]{Thread.currentThread().getName(), this.table.getNameAsString(), t});
                this.throwable = t;
            }
        }
    }
}

