/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.io.File;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.directory.server.core.api.InstanceLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService {
    private static final String DIRECTORY_CACHESERVICE_XML = "directory-cacheservice.xml";
    private static final Logger LOG = LoggerFactory.getLogger(CacheService.class);
    private CacheManager cacheManager;
    private boolean initialized;

    public CacheService() {
    }

    public CacheService(CacheManager cachemanager) {
        this.cacheManager = cachemanager;
        if (cachemanager != null) {
            this.initialized = true;
        }
    }

    public void initialize(InstanceLayout layout) {
        Configuration cc;
        if (this.initialized) {
            LOG.debug("CacheService was already initialized, returning");
            return;
        }
        if (this.cacheManager != null && this.cacheManager.getStatus() == Status.STATUS_ALIVE) {
            LOG.warn("cache service was already initialized and is alive");
            this.initialized = true;
            return;
        }
        File configFile = new File(layout.getConfDirectory(), DIRECTORY_CACHESERVICE_XML);
        if (!configFile.exists()) {
            LOG.info("no custom cache configuration was set, loading the default cache configuration");
            cc = ConfigurationFactory.parseConfiguration((URL)this.getClass().getClassLoader().getResource(DIRECTORY_CACHESERVICE_XML));
        } else {
            LOG.info("loading cache configuration from the file {}", (Object)configFile);
            cc = ConfigurationFactory.parseConfiguration((File)configFile);
        }
        cc.getDiskStoreConfiguration().setPath(layout.getCacheDirectory().getAbsolutePath());
        this.cacheManager = new CacheManager(cc);
        this.initialized = true;
    }

    public void destroy() {
        if (!this.initialized) {
            return;
        }
        LOG.info("clearing all the caches");
        this.initialized = false;
        this.cacheManager.clearAll();
        this.cacheManager.shutdown();
    }

    public Cache getCache(String name) {
        if (!this.initialized) {
            throw new IllegalStateException("CacheService was not initialized");
        }
        LOG.info("fetching the cache named {}", (Object)name);
        Cache cache = this.cacheManager.getCache(name);
        if (cache == null) {
            this.cacheManager.addCache(name);
            cache = this.cacheManager.getCache(name);
        }
        return cache;
    }

    public void remove(String name) {
        this.cacheManager.removeCache(name);
    }

    public void attach(Cache cache) {
        this.cacheManager.addCache(cache);
    }
}

