/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractCloseTableRegionsProcedure<TState extends Enum<?>>
extends AbstractStateMachineTableProcedure<TState> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCloseTableRegionsProcedure.class);
    protected TableName tableName;
    private RetryCounter retryCounter;

    protected AbstractCloseTableRegionsProcedure() {
    }

    protected AbstractCloseTableRegionsProcedure(TableName tableName) {
        this.tableName = tableName;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_EDIT;
    }

    private StateMachineProcedure.Flow schedule(MasterProcedureEnv env) throws ProcedureSuspendedException {
        MutableBoolean submitted = new MutableBoolean(false);
        int inTransitionCount = this.submitUnassignProcedure(env, p -> {
            submitted.setTrue();
            this.addChildProcedure((Procedure[])new TransitRegionStateProcedure[]{p});
        });
        if (inTransitionCount > 0 && submitted.isFalse()) {
            if (this.retryCounter == null) {
                this.retryCounter = ProcedureUtil.createRetryCounter((Configuration)env.getMasterConfiguration());
            }
            long backoffMillis = this.retryCounter.getBackoffTimeAndIncrementAttempts();
            LOG.info("There are still {} region(s) in transition for closing regions of table {} when executing {}, suspend {}secs and try again later", new Object[]{inTransitionCount, this.tableName, this.getClass().getSimpleName(), backoffMillis / 1000L});
            this.suspend((int)backoffMillis, true);
        }
        this.setNextState(this.getConfirmState());
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private StateMachineProcedure.Flow confirm(MasterProcedureEnv env) {
        int unclosedCount = this.numberOfUnclosedRegions(env);
        if (unclosedCount > 0) {
            LOG.info("There are still {} unclosed region(s) for closing regions of table {} when executing {}, continue...", new Object[]{unclosedCount, this.tableName, this.getClass().getSimpleName()});
            this.setNextState(this.getInitialState());
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
        return StateMachineProcedure.Flow.NO_MORE_STATE;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, TState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, state);
        if (state == this.getInitialState()) {
            return this.schedule(env);
        }
        if (state == this.getConfirmState()) {
            return this.confirm(env);
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected void rollbackState(MasterProcedureEnv env, TState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront((Procedure)this);
        return false;
    }

    protected abstract TState getConfirmState();

    protected abstract int submitUnassignProcedure(MasterProcedureEnv var1, Consumer<TransitRegionStateProcedure> var2);

    protected abstract int numberOfUnclosedRegions(MasterProcedureEnv var1);
}

