/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import com.headius.options.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.RubyInstanceConfig;
import org.jruby.compiler.ClassLoaderMode;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.Category;

public class Options {
    private static final List<Option> _loadedOptions = new ArrayList<Option>(240);
    private static final boolean INVOKEDYNAMIC_DEFAULT = Options.calculateInvokedynamicDefault();
    public static final String IR_PRINT_PATTERN_NO_PATTERN_STRING = "<NO_PATTERN>";
    public static final Option<Boolean> PARSER_WARN_USELESSS_USE_OF = Options.bool(Category.PARSER, "parser.warn.useless_use_of", true, "Warn about potentially useless expressions in void contents.");
    public static final Option<Boolean> PARSER_WARN_NOT_REACHED = Options.bool(Category.PARSER, "parser.warn.not_reached", true, "Warn about statements that can never be reached.");
    public static final Option<Boolean> PARSER_WARN_LOCAL_SHADOWING = Options.bool(Category.PARSER, "parser.warn.shadowing_local", false, "Warn about shadowing local variables.");
    public static final Option<Boolean> PARSER_WARN_REGEX_CONDITION = Options.bool(Category.PARSER, "parser.warn.regex_condition", true, "Warn about regex literals in conditions.");
    public static final Option<Boolean> PARSER_WARN_ARGUMENT_PREFIX = Options.bool(Category.PARSER, "parser.warn.argument_prefix", true, "Warn about splat operators being interpreted as argument prefixes.");
    public static final Option<Boolean> PARSER_WARN_AMBIGUOUS_ARGUMENTS = Options.bool(Category.PARSER, "parser.warn.ambiguous_argument", true, "Warn about ambiguous arguments.");
    public static final Option<Boolean> PARSER_WARN_FLAGS_IGNORED = Options.bool(Category.PARSER, "parser.warn.flags_ignored", true, "Warn about ignored regex flags being ignored.");
    public static final Option<RubyInstanceConfig.CompileMode> COMPILE_MODE = Options.enumeration(Category.COMPILER, "compile.mode", RubyInstanceConfig.CompileMode.class, RubyInstanceConfig.CompileMode.JIT, "Set compilation mode. JIT = at runtime; FORCE = before execution.");
    public static final Option<Boolean> COMPILE_DUMP = Options.bool(Category.COMPILER, "compile.dump", false, "Dump to console all bytecode generated at runtime.");
    public static final Option<Boolean> COMPILE_INVOKEDYNAMIC = Options.bool(Category.COMPILER, "compile.invokedynamic", INVOKEDYNAMIC_DEFAULT, "Use invokedynamic for optimizing Ruby code.");
    public static final Option<Boolean> COMPILE_CACHE_CLASSES = Options.bool(Category.COMPILER, "compile.cache.classes", false, "Use cache of compiled sript classes");
    public static final Option<Boolean> COMPILE_CACHE_CLASSES_LOGGING = Options.bool(Category.COMPILER, "compile.cache.classes.logging", false, "Log whether cached script classes are being saved or used");
    public static final Option<Integer> INVOKEDYNAMIC_MAXFAIL = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.maxfail", 1000, "Maximum call site failures after which to inline cache.");
    public static final Option<Integer> INVOKEDYNAMIC_MAXPOLY = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.maxpoly", 6, "Maximum polymorphism of PIC binding.");
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_BINDING = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.binding", false, "Log binding of invokedynamic call sites.");
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_CONSTANTS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.constants", false, "Log invokedynamic-based constant lookups.");
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_GLOBALS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.globals", false, "Log invokedynamic-based global lookups.");
    public static final Option<Boolean> INVOKEDYNAMIC_CLASS_VALUES = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.class.values", false, "Use ClassValue to store class-specific data.");
    public static final Option<Integer> INVOKEDYNAMIC_GLOBAL_MAXFAIL = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.global.maxfail", 0, "Maximum global cache failures after which to use slow path.");
    public static final Option<Boolean> INVOKEDYNAMIC_HANDLES = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.handles", false, "Use MethodHandles rather than generated code to bind Ruby methods.");
    public static final Option<Boolean> INVOKEDYNAMIC_YIELD = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.yield", true, "Bind yields directly using invokedynamic.");
    public static final Option<Integer> JIT_THRESHOLD = Options.integer(Category.JIT, "jit.threshold", 50, "Set the JIT threshold to the specified method invocation count.");
    public static final Option<Integer> JIT_MAX = Options.integer(Category.JIT, "jit.max", 10000, "Set the max count of active methods eligible for JIT-compilation.");
    public static final Option<Integer> JIT_MAXSIZE = Options.integer(Category.JIT, "jit.maxsize", 1000, "Set the max size (in IR instructions) for a method to be eligible to JIT.");
    public static final Option<Boolean> JIT_LOGGING = Options.bool(Category.JIT, "jit.logging", false, "Enable JIT logging (reports successful compilation).");
    public static final Option<Boolean> JIT_LOGGING_VERBOSE = Options.bool(Category.JIT, "jit.logging.verbose", false, "Enable verbose JIT logging (reports failed compilation).");
    public static final Option<Integer> JIT_LOGEVERY = Options.integer(Category.JIT, "jit.logEvery", 0, "Log a message every n methods JIT compiled.");
    public static final Option<String> JIT_EXCLUDE = Options.string(Category.JIT, "jit.exclude", "", "Exclude methods from JIT. <ModClsName or '-'>::<method_name>, comma-delimited.");
    public static final Option<Boolean> JIT_BACKGROUND = Options.bool(Category.JIT, "jit.background", JIT_THRESHOLD.load() != 0, "Run the JIT compiler in a background thread. Off if jit.threshold=0.");
    public static final Option<Boolean> JIT_KERNEL = Options.bool(Category.JIT, "jit.kernel", false, "Run the JIT compiler while the pure-Ruby kernel is booting.");
    public static final Option<ClassLoaderMode> JIT_LOADER_MODE = Options.enumeration(Category.JIT, "jit.loader.mode", ClassLoaderMode.class, ClassLoaderMode.UNIQUE, "Set JIT class loader to use. UNIQUE class loader per class; SHARED loader for all classes");
    public static final Option<String> IR_DEBUG_IGV = Options.string(Category.IR, "ir.debug.igv", (String)null, "Specify file:line of scope to jump to IGV");
    public static final Option<Boolean> IR_DEBUG = Options.bool(Category.IR, "ir.debug", false, "Debug generation of JRuby IR.");
    public static final Option<Boolean> IR_PROFILE = Options.bool(Category.IR, "ir.profile", false, "[EXPT]: Profile IR code during interpretation.");
    public static final Option<Boolean> IR_COMPILER_DEBUG = Options.bool(Category.IR, "ir.compiler.debug", false, "Debug compilation of JRuby IR.");
    public static final Option<Boolean> IR_VISUALIZER = Options.bool(Category.IR, "ir.visualizer", false, "Visualization of JRuby IR.");
    public static final Option<Boolean> IR_UNBOXING = Options.bool(Category.IR, "ir.unboxing", false, "Implement unboxing opts.");
    public static final Option<String> IR_COMPILER_PASSES = Options.string(Category.IR, "ir.passes", "Specify comma delimeted list of passes to run.");
    public static final Option<String> IR_JIT_PASSES = Options.string(Category.IR, "ir.jit.passes", "Specify comma delimeted list of passes to run before JIT.");
    public static final Option<Boolean> IR_READING = Options.bool(Category.IR, "ir.reading", false, "Read JRuby IR file.");
    public static final Option<Boolean> IR_READING_DEBUG = Options.bool(Category.IR, "ir.reading.debug", false, "Debug reading JRuby IR file.");
    public static final Option<Boolean> IR_WRITING = Options.bool(Category.IR, "ir.writing", false, "Write JRuby IR file.");
    public static final Option<Boolean> IR_INLINER = Options.bool(Category.IR, "ir.inliner", false, "Enable the inliner.");
    public static final Option<Integer> IR_INLINER_THRESHOLD = Options.integer(Category.IR, "ir.inliner.threshold", 20, "Enable the inliner.");
    public static final Option<Boolean> IR_INLINER_VERBOSE = Options.bool(Category.IR, "ir.inliner.verbose", false, "Report inlining activity.");
    public static final Option<Boolean> IR_WRITING_DEBUG = Options.bool(Category.IR, "ir.writing.debug", false, "Debug writing JRuby IR file.");
    public static final Option<Boolean> IR_PRINT_OPT = Options.bool(Category.IR, "ir.print.opt", false, "Print the IR CFG before and after each optimization pass.");
    public static final Option<Boolean> IR_PRINT_ALL = Options.bool(Category.IR, "ir.print.all", false, "Enable ir.print and include IR executed during JRuby's boot phase.");
    public static final Option<Boolean> IR_PRINT = Options.bool(Category.IR, "ir.print", IR_PRINT_ALL.load(), "Print the final IR to be run before starting to execute each body of code.");
    public static final Option<Boolean> IR_PRINT_COLOR = Options.bool(Category.IR, "ir.print.color", false, "Print the final IR with color highlighting.");
    public static final Option<String> IR_PRINT_PATTERN = Options.string(Category.IR, "ir.print.pattern", "<NO_PATTERN>", "A pattern to limit IR print output to specific scopes.");
    public static final Option<Boolean> NATIVE_ENABLED = Options.bool(Category.NATIVE, "native.enabled", true, "Enable/disable native code, including POSIX features and C exts.");
    public static final Option<Boolean> NATIVE_VERBOSE = Options.bool(Category.NATIVE, "native.verbose", false, "Enable verbose logging of native extension loading.");
    public static final Option<Boolean> FFI_COMPILE_DUMP = Options.bool(Category.NATIVE, "ffi.compile.dump", false, "Dump bytecode-generated FFI stubs to console.");
    public static final Option<Integer> FFI_COMPILE_THRESHOLD = Options.integer(Category.NATIVE, "ffi.compile.threshold", 100, "Number of FFI invocations before generating a bytecode stub.");
    public static final Option<Boolean> FFI_COMPILE_REIFY = Options.bool(Category.NATIVE, "ffi.compile.reify", false, "Reify FFI compiled classes.");
    public static final Option<Boolean> NATIVE_STDIO = Options.bool(Category.NATIVE, "native.stdio", true, "Use native wrappers around the default stdio descriptors.");
    public static final Option<Boolean> NATIVE_PTHREAD_KILL = Options.bool(Category.NATIVE, "native.pthread_kill", true, "Use pthread_kill to interrupt blocking kernel calls.");
    public static final Option<Boolean> NATIVE_POPEN = Options.bool(Category.NATIVE, "native.popen", true, "Use native calls to posix_spawn for subprocess execution.");
    public static final Option<Integer> THREADPOOL_MIN = Options.integer(Category.THREADPOOL, "thread.pool.min", 0, "The minimum number of threads to keep alive in the pool.");
    public static final Option<Integer> THREADPOOL_MAX = Options.integer(Category.THREADPOOL, "thread.pool.max", Integer.MAX_VALUE, "The maximum number of threads to allow in the pool.");
    public static final Option<Integer> THREADPOOL_TTL = Options.integer(Category.THREADPOOL, "thread.pool.ttl", 60, "The maximum number of seconds to keep alive an idle thread.");
    public static final Option<Integer> FIBER_THREADPOOL_TTL = Options.integer(Category.THREADPOOL, "fiber.thread.pool.ttl", 60, "The maximum number of seconds to keep alive a pooled fiber thread.");
    public static final Option<Boolean> FIBER_VTHREADS = Options.bool(Category.THREADPOOL, "fiber.vthread", true, "Use JDK virtual threads for Ruby Fibers.");
    public static final Option<Boolean> CLASSLOADER_DELEGATE = Options.bool(Category.MISCELLANEOUS, "classloader.delegate", true, "In some cases of classloader conflicts it might help not to delegate first to the parent classloader but to load first from the jruby-classloader.");
    public static final Option<Boolean> OBJECTSPACE_ENABLED = Options.bool(Category.MISCELLANEOUS, "objectspace.enabled", false, "Enable or disable ObjectSpace.each_object.");
    public static final Option<Boolean> SIPHASH_ENABLED = Options.bool(Category.MISCELLANEOUS, "siphash.enabled", false, "Enable or disable SipHash for String hash function.");
    public static final Option<Boolean> LAUNCH_INPROC = Options.bool(Category.MISCELLANEOUS, "launch.inproc", false, "Set in-process launching of e.g. system('ruby ...').");
    public static final Option<String> BYTECODE_VERSION = Options.string(Category.MISCELLANEOUS, "bytecode.version", SafePropertyAccessor.getProperty("java.specification.version", "1.8"), "Specify the major Java bytecode version.");
    public static final Option<Boolean> MANAGEMENT_ENABLED = Options.bool(Category.MISCELLANEOUS, "management.enabled", false, "Set whether JMX management is enabled.");
    public static final Option<Boolean> JUMP_BACKTRACE = Options.bool(Category.MISCELLANEOUS, "jump.backtrace", false, "Make non-local flow jumps generate backtraces.");
    public static final Option<Boolean> PROCESS_NOUNWRAP = Options.bool(Category.MISCELLANEOUS, "process.noUnwrap", false, "Do not unwrap process streams (issue on some recent JVMs).");
    public static final Option<Boolean> REIFY_CLASSES = Options.bool(Category.MISCELLANEOUS, "reify.classes", false, "Generate a real Java class and methods for every Ruby class.");
    public static final Option<Boolean> REIFY_FFI = Options.bool(Category.MISCELLANEOUS, "reify.ffi", false, "Reify FFI memory structures.");
    public static final Option<Boolean> REIFY_LOGERRORS = Options.bool(Category.MISCELLANEOUS, "reify.logErrors", false, "Log errors during reification (reify.classes=true).");
    public static final Option<Boolean> BACKTRACE_COLOR = Options.bool(Category.MISCELLANEOUS, "backtrace.color", false, "Enable colorized backtraces.");
    public static final Option<String> BACKTRACE_STYLE = Options.string(Category.MISCELLANEOUS, "backtrace.style", new String[]{"normal", "raw", "full", "mri"}, "normal", "Set the style of exception backtraces.");
    public static final Option<Boolean> BACKTRACE_MASK = Options.bool(Category.MISCELLANEOUS, "backtrace.mask", false, "Mask .java lines in Ruby backtraces.");
    public static final Option<Boolean> NATIVE_EXEC = Options.bool(Category.MISCELLANEOUS, "native.exec", true, "Do a true process-obliterating native exec for Kernel#exec.");
    public static final Option<Boolean> CONSISTENT_HASHING = Options.bool(Category.MISCELLANEOUS, "consistent.hashing", false, "Generate consistent object hashes across JVMs");
    public static final Option<Boolean> VOLATILE_VARIABLES = Options.bool(Category.MISCELLANEOUS, "volatile.variables", false, "Always ensure volatile semantics for instance variables.");
    public static final Option<Boolean> REIFY_VARIABLES = Options.bool(Category.MISCELLANEOUS, "reify.variables", REIFY_CLASSES.load() == false && VOLATILE_VARIABLES.load() == false, "Expand instance vars into Java fields");
    public static final Option<Integer> REIFY_VARIABLES_MAX = Options.integer(Category.MISCELLANEOUS, "reify.variables.max", 50, "Maximum number of reified instance variable fields");
    public static final Option<Boolean> REIFY_VARIABLES_NAME = Options.bool(Category.MISCELLANEOUS, "reify.variables.name", false, "Reify variables into a class named after the Ruby class");
    public static final Option<String> PREFERRED_PRNG = Options.string(Category.MISCELLANEOUS, "preferred.prng", "NativePRNGNonBlocking", "Set the preferred JDK-supported random number generator to use.");
    public static final Option<Boolean> USE_FIXNUM_CACHE = Options.bool(Category.MISCELLANEOUS, "fixnum.cache", true, "Use a cache of low-valued Fixnum objects.");
    public static final Option<Integer> FIXNUM_CACHE_RANGE = Options.integer(Category.MISCELLANEOUS, "fixnum.cache.size", 256, "Values to retrieve from Fixnum cache, in the range -X..(X-1).");
    public static final Option<Boolean> PACKED_ARRAYS = Options.bool(Category.MISCELLANEOUS, "packed.arrays", true, "Toggle whether to use \"packed\" arrays for small tuples.");
    public static final Option<Boolean> REGEXP_INTERRUPTIBLE = Options.bool(Category.MISCELLANEOUS, "regexp.interruptible", true, "Allow regexp operations to be interuptible from Ruby.");
    public static final Option<Integer> JAR_CACHE_EXPIRATION = Options.integer(Category.MISCELLANEOUS, "jar.cache.expiration", 750, "The time (ms) between checks if a JAR file containing resources has been updated.");
    public static final Option<Boolean> DEBUG_LOADSERVICE = Options.bool(Category.DEBUG, "debug.loadService", false, "Log require/load file searches.");
    public static final Option<Boolean> DEBUG_LOADSERVICE_TIMING = Options.bool(Category.DEBUG, "debug.loadService.timing", false, "Log require/load parse+evaluate times.");
    public static final Option<Boolean> DEBUG_LAUNCH = Options.bool(Category.DEBUG, "debug.launch", false, "Log externally-launched processes.");
    public static final Option<Boolean> DEBUG_FULLTRACE = Options.bool(Category.DEBUG, "debug.fullTrace", false, "Set whether full traces are enabled (c-call/c-return).");
    public static final Option<Boolean> DEBUG_SCRIPTRESOLUTION = Options.bool(Category.DEBUG, "debug.scriptResolution", false, "Print which script is executed by '-S' flag.");
    public static final Option<Boolean> DEBUG_PARSER = Options.bool(Category.DEBUG, "debug.parser", false, "disables JRuby impl script loads and prints parse exceptions");
    public static final Option<Boolean> ERRNO_BACKTRACE = Options.bool(Category.DEBUG, "errno.backtrace", false, "Generate backtraces for heavily-used Errno exceptions (EAGAIN).");
    public static final Option<Boolean> STOPITERATION_BACKTRACE = Options.bool(Category.DEBUG, "stop_iteration.backtrace", false, "Generate backtraces for heavily-used Errno exceptions (EAGAIN).");
    public static final Option<Boolean> LOG_EXCEPTIONS = Options.bool(Category.DEBUG, "log.exceptions", false, "Log every time an exception is constructed.");
    public static final Option<Boolean> LOG_BACKTRACES = Options.bool(Category.DEBUG, "log.backtraces", false, "Log every time an exception backtrace is generated.");
    public static final Option<Boolean> LOG_CALLERS = Options.bool(Category.DEBUG, "log.callers", false, "Log every time a Kernel#caller backtrace is generated.");
    public static final Option<Boolean> LOG_WARNINGS = Options.bool(Category.DEBUG, "log.warnings", false, "Log every time a built-in warning backtrace is generated.");
    public static final Option<Boolean> LOG_SINGLETONS = Options.bool(Category.DEBUG, "log.singletons", false, "Log every time a singleton class is created.");
    public static final Option<Boolean> LOG_SINGLETONS_VERBOSE = Options.bool(Category.DEBUG, "log.singletons.verbose", false, "Log a stack trace every time a singleton class is created.");
    public static final Option<String> LOGGER_CLASS = Options.string(Category.DEBUG, "logger.class", new String[]{"class name"}, "org.jruby.util.log.StandardErrorLogger", "Use specified class for logging.");
    public static final Option<Boolean> DUMP_INSTANCE_VARS = Options.bool(Category.DEBUG, "dump.variables", false, "Dump class + instance var names on first new of Object subclasses.");
    public static final Option<Boolean> REWRITE_JAVA_TRACE = Options.bool(Category.DEBUG, "rewrite.java.trace", true, "Rewrite stack traces from exceptions raised in Java calls.");
    public static final Option<Boolean> JI_SETACCESSIBLE = Options.bool(Category.JAVA_INTEGRATION, "ji.setAccessible", true, "Try to set inaccessible Java methods to be accessible.");
    public static final Option<Boolean> JI_UPPER_CASE_PACKAGE_NAME_ALLOWED = Options.bool(Category.JAVA_INTEGRATION, "ji.upper.case.package.name.allowed", false, "Allow Capitalized Java package names.");
    public static final Option<Boolean> INTERFACES_USEPROXY = Options.bool(Category.JAVA_INTEGRATION, "interfaces.useProxy", false, "Use java.lang.reflect.Proxy for interface impl.");
    public static final Option<Boolean> JI_NEWSTYLEEXTENSION = Options.bool(Category.JAVA_INTEGRATION, "ji.newStyleExtension", false, "Extend Java classes without using a proxy object.");
    public static final Option<Boolean> JI_OBJECTPROXYCACHE = Options.bool(Category.JAVA_INTEGRATION, "ji.objectProxyCache", false, "Cache Java object wrappers between calls.");
    public static final Option<String> JI_PROXYCLASSFACTORY = Options.string(Category.JAVA_INTEGRATION, "ji.proxyClassFactory", "Allow external envs to replace JI proxy class factory");
    public static final Option<Boolean> JI_AMBIGUOUS_CALLS_DEBUG = Options.bool(Category.JAVA_INTEGRATION, "ji.ambiguous.calls.debug", false, "Toggle verbose reporting of all ambiguous calls to Java objects");
    public static final Option<Boolean> AOT_LOADCLASSES = Options.bool(Category.JAVA_INTEGRATION, "aot.loadClasses", false, "Look for .class before .rb to load AOT-compiled code");
    public static final Option<Boolean> JI_LOAD_LAZY = Options.bool(Category.JAVA_INTEGRATION, "ji.load.lazy", true, "Load Java support (class extensions) lazily on demand or ahead of time.");
    public static final Option<Boolean> JI_CLOSE_CLASSLOADER = Options.bool(Category.JAVA_INTEGRATION, "ji.close.classloader", false, "Close the JRubyClassLoader used by each runtime");
    public static final Option<String> JI_NESTED_JAR_TMPDIR = Options.string(Category.JAVA_INTEGRATION, "ji.nested.jar.tmpdir", "Use specified dir as a base for unpacking nested jar files.");
    public static final Option<Integer> PROFILE_MAX_METHODS = Options.integer(Category.PROFILING, "profile.max.methods", 100000, "Maximum number of methods to consider for profiling.");
    public static final Option<Boolean> CLI_AUTOSPLIT = Options.bool(Category.CLI, "cli.autosplit", false, "Split $_ into $F for -p or -n. Same as -a.");
    public static final Option<Boolean> CLI_DEBUG = Options.bool(Category.CLI, "cli.debug", false, "Enable debug mode logging. Same as -d.");
    public static final Option<Boolean> CLI_PROCESS_LINE_ENDS = Options.bool(Category.CLI, "cli.process.line.ends", false, "Enable line ending processing. Same as -l.");
    public static final Option<Boolean> CLI_ASSUME_LOOP = Options.bool(Category.CLI, "cli.assume.loop", false, "Wrap execution with a gets() loop. Same as -n.");
    public static final Option<Boolean> CLI_ASSUME_PRINT = Options.bool(Category.CLI, "cli.assume.print", false, "Print $_ after each execution of script. Same as -p.");
    public static final Option<Boolean> CLI_VERBOSE = Options.bool(Category.CLI, "cli.verbose", false, "Verbose mode, as -w or -W2. Sets default for cli.warning.level.");
    public static final Option<RubyInstanceConfig.Verbosity> CLI_WARNING_LEVEL = Options.enumeration(Category.CLI, "cli.warning.level", RubyInstanceConfig.Verbosity.class, Options.calculateVerbosityDefault(), "Warning level (off=0,normal=1,on=2). Same as -W.");
    public static final Option<Boolean> CLI_PARSER_DEBUG = Options.bool(Category.CLI, "cli.parser.debug", false, "Enable parser debug logging. Same as -y.");
    public static final Option<Boolean> CLI_VERSION = Options.bool(Category.CLI, "cli.version", false, "Print version to stderr. Same as --version.");
    public static final Option<Boolean> CLI_BYTECODE = Options.bool(Category.CLI, "cli.bytecode", false, "Print target script bytecode to stderr. Same as --bytecode.");
    public static final Option<Boolean> CLI_COPYRIGHT = Options.bool(Category.CLI, "cli.copyright", false, "Print copyright to stderr. Same as --copyright but runs script.");
    public static final Option<Boolean> CLI_CHECK_SYNTAX = Options.bool(Category.CLI, "cli.check.syntax", false, "Check syntax of target script. Same as -c but runs script.");
    public static final Option<String> CLI_AUTOSPLIT_SEPARATOR = Options.string(Category.CLI, "cli.autosplit.separator", "Set autosplit separator. Same as -F.");
    public static final Option<KCode> CLI_KCODE = Options.enumeration(Category.CLI, "cli.kcode", KCode.class, KCode.NONE, "Set kcode character set. Same as -K (1.8).");
    public static final Option<Boolean> CLI_HELP = Options.bool(Category.CLI, "cli.help", false, "Print command-line usage. Same as --help but runs script.");
    public static final Option<Boolean> CLI_PROPERTIES = Options.bool(Category.CLI, "cli.properties", false, "Print config properties. Same as --properties but runs script.");
    public static final Option<String> CLI_ENCODING_INTERNAL = Options.string(Category.CLI, "cli.encoding.internal", "Encoding name to use internally.");
    public static final Option<String> CLI_ENCODING_EXTERNAL = Options.string(Category.CLI, "cli.encoding.external", "Encoding name to treat external data.");
    public static final Option<String> CLI_ENCODING_SOURCE = Options.string(Category.CLI, "cli.encoding.source", "Encoding name to treat source code.");
    public static final Option<String> CLI_RECORD_SEPARATOR = Options.string(Category.CLI, "cli.record.separator", "\n", "Default record separator.");
    public static final Option<String> CLI_BACKUP_EXTENSION = Options.string(Category.CLI, "cli.backup.extension", "Backup extension for in-place ARGV files. Same as -i.");
    public static final Option<RubyInstanceConfig.ProfilingMode> CLI_PROFILING_MODE = Options.enumeration(Category.CLI, "cli.profiling.mode", RubyInstanceConfig.ProfilingMode.class, RubyInstanceConfig.ProfilingMode.OFF, "Enable instrumented profiling modes.");
    public static final Option<String> CLI_PROFILING_SERVICE = Options.string(Category.CLI, "cli.profiling.service", "Profiling service class to use.");
    public static final Option<Boolean> CLI_RUBYGEMS_ENABLE = Options.bool(Category.CLI, "cli.rubygems.enable", true, "Enable/disable RubyGems.");
    public static final Option<Boolean> CLI_DID_YOU_MEAN_ENABLE = Options.bool(Category.CLI, "cli.did_you_mean.enable", true, "Enable/disable did_you_mean.");
    public static final Option<Boolean> CLI_RUBYOPT_ENABLE = Options.bool(Category.CLI, "cli.rubyopt.enable", true, "Enable/disable RUBYOPT processing at start.");
    public static final Option<Boolean> CLI_STRIP_HEADER = Options.bool(Category.CLI, "cli.strip.header", false, "Strip text before shebang in script. Same as -x.");
    public static final Option<Boolean> CLI_LOAD_GEMFILE = Options.bool(Category.CLI, "cli.load.gemfile", false, "Load a bundler Gemfile in cwd before running. Same as -G.");
    public static final Collection<Option> PROPERTIES = Collections.unmodifiableCollection(_loadedOptions);
    @Deprecated
    public static final Option<Boolean> PARSER_WARN_GROUPED_EXPRESSIONS = Options.bool(Category.PARSER, "parser.warn.grouped_expressions", true, "Warn about interpreting (...) as a grouped expression.");
    @Deprecated
    public static final Option<Boolean> COMPILE_FASTOPS = Options.bool(Category.COMPILER, "compile.fastops", true, "Turn on fast operators for Fixnum and Float.");
    @Deprecated
    public static final Option<Boolean> COMPILE_THREADLESS = Options.bool(Category.COMPILER, "compile.threadless", false, "(EXPERIMENTAL) Turn on compilation without polling for \"unsafe\" thread events.");
    @Deprecated
    public static final Option<Integer> COMPILE_CHAINSIZE = Options.integer(Category.COMPILER, "compile.chainsize", 500, "Set the number of lines at which compiled bodies are \"chained\".");
    @Deprecated
    public static final Option<Boolean> COMPILE_PEEPHOLE = Options.bool(Category.COMPILER, "compile.peephole", true, "Enable or disable peephole optimizations.");
    @Deprecated
    public static final Option<Boolean> COMPILE_NOGUARDS = Options.bool(Category.COMPILER, "compile.noguards", false, "Compile calls without guards, for experimentation.");
    @Deprecated
    public static final Option<Boolean> COMPILE_FASTEST = Options.bool(Category.COMPILER, "compile.fastest", false, "Compile with all \"mostly harmless\" compiler optimizations.");
    @Deprecated
    public static final Option<Boolean> COMPILE_FASTSEND = Options.bool(Category.COMPILER, "compile.fastsend", false, "Compile obj.__send__(<literal>, ...) as obj.<literal>(...).");
    @Deprecated
    public static final Option<Boolean> COMPILE_FASTMASGN = Options.bool(Category.COMPILER, "compile.fastMasgn", false, "Return true from multiple assignment instead of a new array.");
    @Deprecated
    public static final Option<Integer> COMPILE_OUTLINE_CASECOUNT = Options.integer(Category.COMPILER, "compile.outline.casecount", 50, "Outline when bodies when number of cases exceeds this value.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_SAFE = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.safe", false, "Enable all safe (but maybe not fast) uses of invokedynamic.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation", true, "Enable invokedynamic for method invocations.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_INDIRECT = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.indirect", true, "Also bind indirect method invokers to invokedynamic.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_JAVA = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.java", true, "Bind Ruby to Java invocations with invokedynamic.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_ATTR = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.attr", true, "Bind Ruby attribute invocations directly to invokedynamic.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_FFI = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.ffi", true, "Bind Ruby FFI invocations directly to invokedynamic.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_FASTOPS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.fastops", true, "Bind Fixnum and Float math using optimized logic.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache", true, "Use invokedynamic to load cached values like literals and constants.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_CONSTANTS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.constants", true, "Use invokedynamic to load constants.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_LITERALS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.literals", true, "Use invokedynamic to load literals.");
    @Deprecated
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_IVARS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.ivars", true, "Use invokedynamic to get/set instance variables.");
    @Deprecated
    public static final Option<String> JIT_CODECACHE = Options.string(Category.JIT, "jit.codeCache", new String[]{"dir"}, "Save jitted methods to <dir> as they're compiled, for future runs.");
    @Deprecated
    public static final Option<Boolean> JIT_CACHE = Options.bool(Category.JIT, "jit.cache", COMPILE_INVOKEDYNAMIC.load() == false, "(DEPRECATED) Cache jitted method in-memory bodies across runtimes and loads.");
    public static final Option<Boolean> INVOKEDYNAMIC_ALL = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.all", false, "Enable all possible uses of invokedynamic.");
    @Deprecated
    public static final Option<Boolean> JIT_DUMPING = Options.bool(Category.JIT, "jit.dumping", false, "Enable stdout dumping of JITed bytecode.");
    @Deprecated
    public static final Option<Boolean> JIT_DEBUG = Options.bool(Category.JIT, "jit.debug", false, "Log loading of JITed bytecode.");
    @Deprecated
    public static final Option<String> IR_INLINE_COMPILER_PASSES = Options.string(Category.IR, "ir.inline_passes", "Specify comma delimeted list of passes to run after inlining a method.");
    @Deprecated
    public static final Option<Boolean> FFI_COMPILE_INVOKEDYNAMIC = Options.bool(Category.NATIVE, "ffi.compile.invokedynamic", false, "Use invokedynamic to bind FFI invocations.");
    @Deprecated
    public static final Option<Boolean> PREFER_IPV4 = Options.bool(Category.MISCELLANEOUS, "net.preferIPv4", false, "(DEPRECATED) Prefer IPv4 network stack");
    @Deprecated
    public static final Option<Boolean> NATIVE_NET_PROTOCOL = Options.bool(Category.MISCELLANEOUS, "native.net.protocol", false, "Use native impls for parts of net/protocol.");
    @Deprecated
    public static final Option<String> THREAD_DUMP_SIGNAL = Options.string(Category.MISCELLANEOUS, "thread.dump.signal", new String[]{"USR1", "USR2", "etc"}, "USR2", "Set the signal used for dumping thread stacks.");
    @Deprecated
    public static final Option<Boolean> FIBER_COROUTINES = Options.bool(Category.MISCELLANEOUS, "fiber.coroutines", false, "Use JVM coroutines for Fiber.");
    @Deprecated
    public static final Option<Boolean> GLOBAL_REQUIRE_LOCK = Options.bool(Category.MISCELLANEOUS, "global.require.lock", false, "Use a single global lock for requires.");
    @Deprecated
    public static final Option<Boolean> REFLECTED_HANDLES = Options.bool(Category.MISCELLANEOUS, "reflected.handles", false, "Use reflection for binding methods, not generated bytecode.");
    @Deprecated
    public static final Option<Boolean> ENUMERATOR_LIGHTWEIGHT = Options.bool(Category.MISCELLANEOUS, "enumerator.lightweight", true, "Use lightweight Enumerator#next logic when possible.");
    @Deprecated
    public static final Option<Boolean> FCNTL_LOCKING = Options.bool(Category.MISCELLANEOUS, "file.flock.fcntl", true, "Use fcntl rather than flock for File#flock");
    @Deprecated
    public static final Option<Boolean> RECORD_LEXICAL_HIERARCHY = Options.bool(Category.MISCELLANEOUS, "record.lexical.hierarchy", false, "Maintain children static scopes to support scope dumping.");
    @Deprecated
    public static final Option<Boolean> JI_LOGCANSETACCESSIBLE = Options.bool(Category.JAVA_INTEGRATION, "ji.logCanSetAccessible", false, "Log whether setAccessible is working.");
    @Deprecated
    public static final Option<Boolean> JAVA_HANDLES = Options.bool(Category.JAVA_INTEGRATION, "java.handles", false, "Use generated handles instead of reflection for calling Java.");

    public static String dump() {
        return "# JRuby configuration options with current values\n" + Option.formatValues(_loadedOptions);
    }

    private static Option<String> string(Category category, String name2, String[] options2, String defval, String description) {
        Option<String> option = Option.string("jruby", name2, category, options2, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String defval, String description) {
        Option<String> option = Option.string("jruby", name2, (Enum)category, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String[] options2, String description) {
        Option<String> option = Option.string("jruby", name2, (Enum)category, options2, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String description) {
        Option<String> option = Option.string("jruby", name2, category, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<Boolean> bool(Category category, String name2, Boolean defval, String description) {
        Option<Boolean> option = Option.bool("jruby", name2, category, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<Integer> integer(Category category, String name2, Integer defval, String description) {
        Option<Integer> option = Option.integer("jruby", name2, (Enum)category, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static <T extends Enum<T>> Option<T> enumeration(Category category, String name2, Class<T> enumClass, T defval, String description) {
        Option<Class<T>> option = defval == null ? Option.enumeration("jruby", name2, (Enum)category, enumClass, description) : Option.enumeration("jruby", name2, (Enum)category, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static boolean calculateInvokedynamicDefault() {
        return false;
    }

    private static RubyInstanceConfig.Verbosity calculateVerbosityDefault() {
        Boolean verbose = CLI_VERBOSE.load();
        if (verbose == null) {
            return RubyInstanceConfig.Verbosity.NIL;
        }
        return verbose != false ? RubyInstanceConfig.Verbosity.TRUE : RubyInstanceConfig.Verbosity.FALSE;
    }

    public static void listPrefix(String prefix) {
        Options.list(SearchMode.PREFIX, prefix);
    }

    public static void listContains(String substring) {
        Options.list(SearchMode.CONTAINS, substring);
    }

    private static void list(SearchMode mode2, String string2) {
        for (Option option : PROPERTIES) {
            boolean include2 = false;
            switch (mode2) {
                case PREFIX: {
                    include2 = option.shortName().startsWith(string2);
                    break;
                }
                case CONTAINS: {
                    include2 = option.shortName().contains(string2);
                }
            }
            if (!include2) continue;
            System.out.printf("%s=%s\n", option.shortName(), option.load());
        }
    }

    public static Set<String> getPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>(PROPERTIES.size() + 1, 1.0f);
        Options.addPropertyNames(propertyNames);
        return Collections.unmodifiableSet(propertyNames);
    }

    static void addPropertyNames(Set<String> propertyNames) {
        for (Option option : PROPERTIES) {
            propertyNames.add(option.propertyName());
        }
    }

    private static enum SearchMode {
        PREFIX,
        CONTAINS;

    }
}

