/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.exceptions.X509Exception;
import org.apache.hadoop.hbase.io.FileChangeWatcher;
import org.apache.hadoop.hbase.io.crypto.tls.X509Util;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.ipc.NettyRpcConnection;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class NettyRpcClient
extends AbstractRpcClient<NettyRpcConnection> {
    final EventLoopGroup group;
    final Class<? extends Channel> channelClass;
    private final boolean shutdownGroupWhenClose;
    private final AtomicReference<SslContext> sslContextForClient = new AtomicReference();
    private final AtomicReference<FileChangeWatcher> keyStoreWatcher = new AtomicReference();
    private final AtomicReference<FileChangeWatcher> trustStoreWatcher = new AtomicReference();

    public NettyRpcClient(Configuration configuration, String clusterId, SocketAddress localAddress, MetricsConnection metrics) {
        this(configuration, clusterId, localAddress, metrics, Collections.emptyMap());
    }

    public NettyRpcClient(Configuration configuration, String clusterId, SocketAddress localAddress, MetricsConnection metrics, Map<String, byte[]> connectionAttributes) {
        super(configuration, clusterId, localAddress, metrics, connectionAttributes);
        Pair<EventLoopGroup, Class<? extends Channel>> groupAndChannelClass = NettyRpcClientConfigHelper.getEventLoopConfig(this.conf);
        if (groupAndChannelClass == null) {
            int threadCount = this.conf.getInt("hbase.netty.eventloop.rpcclient.thread.count", 0);
            this.group = new NioEventLoopGroup(threadCount, new DefaultThreadFactory("RPCClient(own)-NioEventLoopGroup", true, 5));
            this.channelClass = NioSocketChannel.class;
            this.shutdownGroupWhenClose = true;
        } else {
            this.group = groupAndChannelClass.getFirst();
            this.channelClass = groupAndChannelClass.getSecond();
            this.shutdownGroupWhenClose = false;
        }
    }

    public NettyRpcClient(Configuration configuration) {
        this(configuration, "default-cluster", null, null, Collections.emptyMap());
    }

    @Override
    protected NettyRpcConnection createConnection(ConnectionId remoteId) throws IOException {
        return new NettyRpcConnection(this, remoteId);
    }

    @Override
    protected void closeInternal() {
        FileChangeWatcher ts;
        FileChangeWatcher ks;
        if (this.shutdownGroupWhenClose) {
            NettyFutureUtils.consume(this.group.shutdownGracefully());
        }
        if ((ks = (FileChangeWatcher)this.keyStoreWatcher.getAndSet(null)) != null) {
            ks.stop();
        }
        if ((ts = (FileChangeWatcher)this.trustStoreWatcher.getAndSet(null)) != null) {
            ts.stop();
        }
    }

    SslContext getSslContext() throws X509Exception, IOException {
        SslContext result = this.sslContextForClient.get();
        if (result == null) {
            result = X509Util.createSslContextForClient(this.conf);
            if (!this.sslContextForClient.compareAndSet(null, result)) {
                result = this.sslContextForClient.get();
            } else if (this.keyStoreWatcher.get() == null && this.trustStoreWatcher.get() == null && this.conf.getBoolean("hbase.rpc.tls.certReload", false)) {
                X509Util.enableCertFileReloading(this.conf, this.keyStoreWatcher, this.trustStoreWatcher, () -> this.sslContextForClient.set(null));
            }
        }
        return result;
    }
}

