/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowMapReduceTests;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@Category(value={VerySlowMapReduceTests.class, LargeTests.class})
public class TestExportSnapshot {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExportSnapshot.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestExportSnapshot.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    @Rule
    public final TestName testName = new TestName();
    protected TableName tableName;
    private byte[] emptySnapshotName;
    private byte[] snapshotName;
    private int tableNumFiles;
    private Admin admin;

    public static void setUpBaseConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setInt("mapreduce.job.maxtaskfailures.per.tracker", 100);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestExportSnapshot.setUpBaseConf(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getAdmin();
        this.tableName = TableName.valueOf((String)("testtb-" + this.testName.getMethodName()));
        this.snapshotName = Bytes.toBytes((String)("snaptb0-" + this.testName.getMethodName()));
        this.emptySnapshotName = Bytes.toBytes((String)("emptySnaptb0-" + this.testName.getMethodName()));
        this.createTable(this.tableName);
        this.admin.snapshot(this.emptySnapshotName, this.tableName);
        SnapshotTestingUtils.loadData((HBaseTestingUtility)TEST_UTIL, (TableName)this.tableName, (int)50, (byte[][])new byte[][]{FAMILY});
        this.tableNumFiles = this.admin.getTableRegions(this.tableName).size();
        this.admin.snapshot(this.snapshotName, this.tableName);
    }

    protected void createTable(TableName tableName) throws Exception {
        SnapshotTestingUtils.createPreSplitTable((HBaseTestingUtility)TEST_UTIL, (TableName)tableName, (int)2, (byte[][])new byte[][]{FAMILY});
    }

    protected RegionPredicate getBypassRegionPredicate() {
        return null;
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
        SnapshotTestingUtils.deleteAllSnapshots((Admin)TEST_UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory((HBaseTestingUtility)TEST_UTIL);
    }

    @Test
    public void testExportFileSystemState() throws Exception {
        this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles);
    }

    @Test
    public void testExportFileSystemStateWithMergeRegion() throws Exception {
        this.admin.compactionSwitch(false, this.admin.getRegionServers().stream().map(a -> a.getServerName()).collect(Collectors.toList()));
        TableName tableName0 = TableName.valueOf((String)("testtb-" + this.testName.getMethodName() + "-1"));
        byte[] snapshotName0 = Bytes.toBytes((String)("snaptb0-" + this.testName.getMethodName() + "-1"));
        this.admin.createTable(TableDescriptorBuilder.newBuilder((TableName)tableName0).setColumnFamilies((Collection)Lists.newArrayList((Object[])new ColumnFamilyDescriptor[]{ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).build()})).build(), (byte[][])new byte[][]{Bytes.toBytes((String)"2")});
        try (Table table = this.admin.getConnection().getTable(tableName0);){
            table.put(new Put(Bytes.toBytes((String)"1")).addColumn(FAMILY, null, Bytes.toBytes((String)"1")));
            table.put(new Put(Bytes.toBytes((String)"2")).addColumn(FAMILY, null, Bytes.toBytes((String)"2")));
        }
        List regions = this.admin.getRegions(tableName0);
        Assert.assertEquals((long)2L, (long)regions.size());
        this.tableNumFiles = regions.size();
        this.admin.mergeRegionsAsync((byte[][])new byte[][]{((RegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((RegionInfo)regions.get(1)).getEncodedNameAsBytes()}, true).get();
        this.admin.snapshot(snapshotName0, tableName0);
        this.testExportFileSystemState(tableName0, snapshotName0, snapshotName0, this.tableNumFiles);
        TEST_UTIL.deleteTable(tableName0);
    }

    @Test
    public void testExportFileSystemStateWithSplitRegion() throws Exception {
        this.admin.compactionSwitch(false, this.admin.getRegionServers().stream().map(ServerName::getServerName).collect(Collectors.toList()));
        TableName splitTableName = TableName.valueOf((String)this.testName.getMethodName());
        String splitTableSnap = "snapshot-" + this.testName.getMethodName();
        this.admin.createTable(TableDescriptorBuilder.newBuilder((TableName)splitTableName).setColumnFamilies((Collection)Lists.newArrayList((Object[])new ColumnFamilyDescriptor[]{ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).build()})).build());
        Path output = TEST_UTIL.getDataTestDir("output/cf");
        TEST_UTIL.getTestFileSystem().mkdirs(output);
        HFileTestUtil.createHFile((Configuration)TEST_UTIL.getConfiguration(), (FileSystem)TEST_UTIL.getTestFileSystem(), (Path)new Path(output, "test_file"), (byte[])FAMILY, (byte[])Bytes.toBytes((String)"q"), (byte[])Bytes.toBytes((String)"1"), (byte[])Bytes.toBytes((String)"9"), (int)9999999);
        BulkLoadHFilesTool tool = new BulkLoadHFilesTool(TEST_UTIL.getConfiguration());
        tool.run(new String[]{output.getParent().toString(), splitTableName.getNameAsString()});
        List regions = this.admin.getRegions(splitTableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        this.tableNumFiles = regions.size();
        this.admin.splitRegionAsync(((RegionInfo)regions.get(0)).getEncodedNameAsBytes(), Bytes.toBytes((String)"5")).get();
        regions = this.admin.getRegions(splitTableName);
        Assert.assertEquals((long)2L, (long)regions.size());
        this.admin.snapshot(splitTableSnap, splitTableName);
        Configuration tmpConf = TEST_UTIL.getConfiguration();
        tmpConf.setInt("snapshot.export.buffer.size", 1);
        tmpConf.setInt("snapshot.export.default.map.group", 1);
        TestExportSnapshot.testExportFileSystemState(tmpConf, splitTableName, Bytes.toBytes((String)splitTableSnap), Bytes.toBytes((String)splitTableSnap), this.tableNumFiles, TEST_UTIL.getDefaultRootDirPath(), this.getHdfsDestinationDir(), false, false, this.getBypassRegionPredicate(), true, false);
        TEST_UTIL.deleteTable(splitTableName);
    }

    @Test
    public void testExportFileSystemStateWithSkipTmp() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("snapshot.export.skip.tmp", true);
        try {
            this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles);
        }
        finally {
            TEST_UTIL.getConfiguration().setBoolean("snapshot.export.skip.tmp", false);
        }
    }

    @Test
    public void testEmptyExportFileSystemState() throws Exception {
        this.testExportFileSystemState(this.tableName, this.emptySnapshotName, this.emptySnapshotName, 0);
    }

    @Test
    public void testConsecutiveExports() throws Exception {
        Path copyDir = TestExportSnapshot.getLocalDestinationDir(TEST_UTIL);
        this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles, copyDir, false);
        this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles, copyDir, true);
        TestExportSnapshot.removeExportDir(copyDir);
    }

    @Test
    public void testExportWithChecksum() throws Exception {
        Path copyLocalDir = TestExportSnapshot.getLocalDestinationDir(TEST_UTIL);
        TestExportSnapshot.testExportFileSystemState(TEST_UTIL.getConfiguration(), this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles, TEST_UTIL.getDefaultRootDirPath(), copyLocalDir, false, false, this.getBypassRegionPredicate(), false, true);
        Path copyHdfsDir = this.getHdfsDestinationDir();
        TestExportSnapshot.testExportFileSystemState(TEST_UTIL.getConfiguration(), this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles, TEST_UTIL.getDefaultRootDirPath(), copyHdfsDir, false, false, this.getBypassRegionPredicate(), true, true);
    }

    @Test
    public void testExportWithTargetName() throws Exception {
        byte[] targetName = Bytes.toBytes((String)"testExportWithTargetName");
        this.testExportFileSystemState(this.tableName, this.snapshotName, targetName, this.tableNumFiles);
    }

    @Test
    public void testExportWithResetTtl() throws Exception {
        String name = "testExportWithResetTtl";
        TableName tableName = TableName.valueOf((String)name);
        String snapshotNameStr = "snaptb-" + name;
        byte[] snapshotName = Bytes.toBytes((String)snapshotNameStr);
        Long ttl = 100000L;
        try {
            this.createTable(tableName);
            SnapshotTestingUtils.loadData((HBaseTestingUtility)TEST_UTIL, (TableName)tableName, (int)50, (byte[][])new byte[][]{FAMILY});
            int tableNumFiles = this.admin.getRegions(tableName).size();
            HashMap<String, Long> props = new HashMap<String, Long>();
            props.put("TTL", ttl);
            this.admin.snapshot(snapshotNameStr, tableName, props);
            Optional<Long> ttlOpt = this.admin.listSnapshots().stream().filter(s -> s.getName().equals(snapshotNameStr)).map(SnapshotDescription::getTtl).findAny();
            Assert.assertTrue((boolean)ttlOpt.isPresent());
            Assert.assertEquals((Object)ttl, (Object)ttlOpt.get());
            this.testExportFileSystemState(tableName, snapshotName, snapshotName, tableNumFiles, this.getHdfsDestinationDir(), false, true);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    @Test
    public void testExportExpiredSnapshot() throws Exception {
        String name = "testExportExpiredSnapshot";
        TableName tableName = TableName.valueOf((String)name);
        String snapshotName = "snapshot-" + name;
        this.createTable(tableName);
        SnapshotTestingUtils.loadData((HBaseTestingUtility)TEST_UTIL, (TableName)tableName, (int)50, (byte[][])new byte[][]{FAMILY});
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("TTL", 10);
        SnapshotDescription snapshotDescription = new SnapshotDescription(snapshotName, tableName, SnapshotType.FLUSH, null, EnvironmentEdgeManager.currentTime(), -1, properties);
        this.admin.snapshot(snapshotDescription);
        boolean isExist = this.admin.listSnapshots().stream().anyMatch(ele -> snapshotName.equals(ele.getName()));
        Assert.assertTrue((boolean)isExist);
        for (int retry = 6; !SnapshotDescriptionUtils.isExpiredSnapshot((long)snapshotDescription.getTtl(), (long)snapshotDescription.getCreationTime(), (long)EnvironmentEdgeManager.currentTime()) && retry > 0; --retry) {
            Thread.sleep(10000L);
        }
        boolean isExpiredSnapshot = SnapshotDescriptionUtils.isExpiredSnapshot((long)snapshotDescription.getTtl(), (long)snapshotDescription.getCreationTime(), (long)EnvironmentEdgeManager.currentTime());
        Assert.assertTrue((boolean)isExpiredSnapshot);
        int res = TestExportSnapshot.runExportSnapshot(TEST_UTIL.getConfiguration(), snapshotName, snapshotName, TEST_UTIL.getDefaultRootDirPath(), this.getHdfsDestinationDir(), false, false, false, true, true);
        Assert.assertTrue((res == 1 ? 1 : 0) != 0);
    }

    private void testExportFileSystemState(TableName tableName, byte[] snapshotName, byte[] targetName, int filesExpected) throws Exception {
        this.testExportFileSystemState(tableName, snapshotName, targetName, filesExpected, this.getHdfsDestinationDir(), false);
    }

    protected void testExportFileSystemState(TableName tableName, byte[] snapshotName, byte[] targetName, int filesExpected, Path copyDir, boolean overwrite) throws Exception {
        this.testExportFileSystemState(tableName, snapshotName, targetName, filesExpected, copyDir, overwrite, false);
    }

    protected void testExportFileSystemState(TableName tableName, byte[] snapshotName, byte[] targetName, int filesExpected, Path copyDir, boolean overwrite, boolean resetTtl) throws Exception {
        TestExportSnapshot.testExportFileSystemState(TEST_UTIL.getConfiguration(), tableName, snapshotName, targetName, filesExpected, TEST_UTIL.getDefaultRootDirPath(), copyDir, overwrite, resetTtl, this.getBypassRegionPredicate(), true, false);
    }

    protected static void testExportFileSystemState(Configuration conf, TableName tableName, byte[] snapshotName, byte[] targetName, int filesExpected, Path srcDir, Path rawTgtDir, boolean overwrite, boolean resetTtl, RegionPredicate bypassregionPredicate, boolean success, boolean checksumVerify) throws Exception {
        FileSystem tgtFs = rawTgtDir.getFileSystem(conf);
        FileSystem srcFs = srcDir.getFileSystem(conf);
        Path tgtDir = rawTgtDir.makeQualified(tgtFs.getUri(), tgtFs.getWorkingDirectory());
        int res = TestExportSnapshot.runExportSnapshot(conf, Bytes.toString((byte[])snapshotName), Bytes.toString((byte[])targetName), srcDir, rawTgtDir, overwrite, resetTtl, checksumVerify, true, true);
        Assert.assertEquals((String)("success " + success + ", res=" + res), (long)(success ? 0L : 1L), (long)res);
        if (!success) {
            Path targetDir = new Path(".hbase-snapshot", Bytes.toString((byte[])targetName));
            Assert.assertFalse((String)(tgtDir.toString() + " " + targetDir.toString()), (boolean)tgtFs.exists(new Path(tgtDir, targetDir)));
            return;
        }
        LOG.info("Exported snapshot");
        FileStatus[] rootFiles = tgtFs.listStatus(tgtDir);
        Assert.assertEquals((long)(filesExpected > 0 ? 2L : 1L), (long)rootFiles.length);
        for (FileStatus fileStatus : rootFiles) {
            String name = fileStatus.getPath().getName();
            Assert.assertTrue((String)fileStatus.toString(), (boolean)fileStatus.isDirectory());
            Assert.assertTrue((String)name.toString(), (name.equals(".hbase-snapshot") || name.equals("archive") ? 1 : 0) != 0);
        }
        LOG.info("Verified filesystem state");
        Path snapshotDir = new Path(".hbase-snapshot", Bytes.toString((byte[])snapshotName));
        Path targetDir = new Path(".hbase-snapshot", Bytes.toString((byte[])targetName));
        TestExportSnapshot.verifySnapshotDir(srcFs, new Path(srcDir, snapshotDir), tgtFs, new Path(tgtDir, targetDir));
        Set<String> snapshotFiles = TestExportSnapshot.verifySnapshot(conf, tgtFs, tgtDir, tableName, Bytes.toString((byte[])targetName), resetTtl, bypassregionPredicate);
        Assert.assertEquals((long)filesExpected, (long)snapshotFiles.size());
    }

    protected static void verifySnapshotDir(FileSystem fs1, Path root1, FileSystem fs2, Path root2) throws IOException {
        Assert.assertEquals(TestExportSnapshot.listFiles(fs1, root1, root1), TestExportSnapshot.listFiles(fs2, root2, root2));
    }

    protected static Set<String> verifySnapshot(Configuration conf, final FileSystem fs, Path rootDir, final TableName tableName, String snapshotName, boolean resetTtl, final RegionPredicate bypassregionPredicate) throws IOException {
        Path exportedSnapshot = new Path(rootDir, new Path(".hbase-snapshot", snapshotName));
        final HashSet<String> snapshotFiles = new HashSet<String>();
        final Path exportedArchive = new Path(rootDir, "archive");
        SnapshotReferenceUtil.visitReferencedFiles((Configuration)conf, (FileSystem)fs, (Path)exportedSnapshot, (SnapshotReferenceUtil.SnapshotVisitor)new SnapshotReferenceUtil.SnapshotVisitor(){

            public void storeFile(RegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                if (bypassregionPredicate != null && bypassregionPredicate.evaluate(regionInfo)) {
                    return;
                }
                if (!storeFile.hasReference() && !StoreFileInfo.isReference((String)storeFile.getName())) {
                    String hfile = storeFile.getName();
                    snapshotFiles.add(hfile);
                    this.verifyNonEmptyFile(new Path(exportedArchive, new Path(CommonFSUtils.getTableDir((Path)new Path("./"), (TableName)tableName), new Path(regionInfo.getEncodedName(), new Path(family, hfile)))));
                } else {
                    Pair referredToRegionAndFile = StoreFileInfo.getReferredToRegionAndFile((String)storeFile.getName());
                    String region = (String)referredToRegionAndFile.getFirst();
                    String hfile = (String)referredToRegionAndFile.getSecond();
                    snapshotFiles.add(hfile);
                    this.verifyNonEmptyFile(new Path(exportedArchive, new Path(CommonFSUtils.getTableDir((Path)new Path("./"), (TableName)tableName), new Path(region, new Path(family, hfile)))));
                }
            }

            private void verifyNonEmptyFile(Path path) throws IOException {
                Assert.assertTrue((String)(path + " should exists"), (boolean)fs.exists(path));
                Assert.assertTrue((String)(path + " should not be empty"), (fs.getFileStatus(path).getLen() > 0L ? 1 : 0) != 0);
            }
        });
        SnapshotProtos.SnapshotDescription desc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)exportedSnapshot);
        Assert.assertTrue((boolean)desc.getName().equals(snapshotName));
        Assert.assertTrue((boolean)desc.getTable().equals(tableName.getNameAsString()));
        if (resetTtl) {
            Assert.assertEquals((long)0L, (long)desc.getTtl());
        }
        return snapshotFiles;
    }

    private static Set<String> listFiles(FileSystem fs, Path root, Path dir) throws IOException {
        HashSet<String> files = new HashSet<String>();
        LOG.debug("List files in {} in root {} at {}", new Object[]{fs, root, dir});
        int rootPrefix = root.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString().length();
        FileStatus[] list = CommonFSUtils.listStatus((FileSystem)fs, (Path)dir);
        if (list != null) {
            for (FileStatus fstat : list) {
                LOG.debug(Objects.toString(fstat.getPath()));
                if (fstat.isDirectory()) {
                    files.addAll(TestExportSnapshot.listFiles(fs, root, fstat.getPath()));
                    continue;
                }
                files.add(fstat.getPath().makeQualified(fs).toString().substring(rootPrefix));
            }
        }
        return files;
    }

    private Path getHdfsDestinationDir() {
        Path rootDir = TEST_UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        Path path = new Path(new Path(rootDir, "export-test"), "export-" + EnvironmentEdgeManager.currentTime());
        LOG.info("HDFS export destination path: " + path);
        return path;
    }

    static Path getLocalDestinationDir(HBaseTestingUtility htu) {
        Path path = htu.getDataTestDir("local-export-" + EnvironmentEdgeManager.currentTime());
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)htu.getConfiguration());
            LOG.info("Local export destination path: " + path);
            return path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void removeExportDir(Path path) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)new Configuration());
        fs.delete(path, true);
    }

    private static int runExportSnapshot(Configuration conf, String sourceSnapshotName, String targetSnapshotName, Path srcDir, Path rawTgtDir, boolean overwrite, boolean resetTtl, boolean checksumVerify, boolean noSourceVerify, boolean noTargetVerify) throws Exception {
        FileSystem tgtFs = rawTgtDir.getFileSystem(conf);
        FileSystem srcFs = srcDir.getFileSystem(conf);
        Path tgtDir = rawTgtDir.makeQualified(tgtFs.getUri(), tgtFs.getWorkingDirectory());
        LOG.info("tgtFsUri={}, tgtDir={}, rawTgtDir={}, srcFsUri={}, srcDir={}", new Object[]{tgtFs.getUri(), tgtDir, rawTgtDir, srcFs.getUri(), srcDir});
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("--snapshot");
        opts.add(sourceSnapshotName);
        opts.add("--copy-to");
        opts.add(tgtDir.toString());
        if (!targetSnapshotName.equals(sourceSnapshotName)) {
            opts.add("--target");
            opts.add(targetSnapshotName);
        }
        if (overwrite) {
            opts.add("--overwrite");
        }
        if (resetTtl) {
            opts.add("--reset-ttl");
        }
        if (!checksumVerify) {
            opts.add("--no-checksum-verify");
        }
        if (!noSourceVerify) {
            opts.add("--no-source-verify");
        }
        if (!noTargetVerify) {
            opts.add("--no-target-verify");
        }
        return ToolRunner.run((Configuration)conf, (Tool)new ExportSnapshot(), (String[])opts.toArray(new String[opts.size()]));
    }

    protected static interface RegionPredicate {
        public boolean evaluate(RegionInfo var1);
    }
}

