/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestChoreService {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestChoreService.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestChoreService.class);
    private static final Configuration CONF = HBaseConfiguration.create();
    @Rule
    public TestName name = new TestName();
    private int initialCorePoolSize = 3;
    private ChoreService service;

    @Before
    public void setUp() {
        this.service = new ChoreService(this.name.getMethodName(), this.initialCorePoolSize, false);
    }

    @After
    public void tearDown() {
        this.shutdownService(this.service);
    }

    @Test
    public void testInitialChorePrecedence() throws InterruptedException {
        int period = 100;
        int failureThreshold = 5;
        FailInitialChore chore = new FailInitialChore("chore", 100, 5);
        this.service.scheduleChore((ScheduledChore)chore);
        int loopCount = 0;
        boolean brokeOutOfLoop = false;
        while (!chore.isInitialChoreComplete() && chore.isScheduled()) {
            Thread.sleep(500L);
            if (++loopCount <= 3) continue;
            brokeOutOfLoop = true;
            break;
        }
        Assert.assertFalse((boolean)brokeOutOfLoop);
    }

    @Test
    public void testCancelChore() throws InterruptedException {
        int period = 100;
        DoNothingChore chore = new DoNothingChore("chore", 100);
        this.service.scheduleChore((ScheduledChore)chore);
        Assert.assertTrue((boolean)chore.isScheduled());
        chore.cancel(true);
        Assert.assertFalse((boolean)chore.isScheduled());
        Assert.assertTrue((this.service.getNumberOfScheduledChores() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testScheduledChoreConstruction() {
        String NAME = "chore";
        int PERIOD = 100;
        long VALID_DELAY = 0L;
        long INVALID_DELAY = -100L;
        TimeUnit UNIT = TimeUnit.NANOSECONDS;
        ScheduledChore chore1 = new ScheduledChore("chore", new SampleStopper(), 100, 0L, UNIT){

            protected void chore() {
            }
        };
        Assert.assertEquals((String)"Name construction failed", (Object)"chore", (Object)chore1.getName());
        Assert.assertEquals((String)"Period construction failed", (long)100L, (long)chore1.getPeriod());
        Assert.assertEquals((String)"Initial Delay construction failed", (long)0L, (long)chore1.getInitialDelay());
        Assert.assertEquals((String)"TimeUnit construction failed", (Object)((Object)UNIT), (Object)((Object)chore1.getTimeUnit()));
        ScheduledChore invalidDelayChore = new ScheduledChore("chore", new SampleStopper(), 100, -100L, UNIT){

            protected void chore() {
            }
        };
        Assert.assertEquals((String)"Initial Delay should be set to 0 when invalid", (long)0L, (long)invalidDelayChore.getInitialDelay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChoreServiceConstruction() throws InterruptedException {
        int corePoolSize = 10;
        boolean defaultCorePoolSize = true;
        ChoreService customInit = new ChoreService("testChoreServiceConstruction_custom", 10, false);
        try {
            Assert.assertEquals((long)10L, (long)customInit.getCorePoolSize());
        }
        finally {
            this.shutdownService(customInit);
        }
        ChoreService defaultInit = new ChoreService("testChoreServiceConstruction_default");
        try {
            Assert.assertEquals((long)1L, (long)defaultInit.getCorePoolSize());
        }
        finally {
            this.shutdownService(defaultInit);
        }
        ChoreService invalidInit = new ChoreService("testChoreServiceConstruction_invalid", -10, false);
        try {
            Assert.assertEquals((long)1L, (long)invalidInit.getCorePoolSize());
        }
        finally {
            this.shutdownService(invalidInit);
        }
    }

    @Test
    public void testFrequencyOfChores() throws InterruptedException {
        int period = 100;
        int delta = 20;
        CountingChore chore = new CountingChore("countingChore", 100);
        this.service.scheduleChore((ScheduledChore)chore);
        Thread.sleep(1020L);
        Assert.assertEquals((String)"10 periods have elapsed.", (long)11L, (long)chore.getCountOfChoreCalls());
        Thread.sleep(1020L);
        Assert.assertEquals((String)"20 periods have elapsed.", (long)21L, (long)chore.getCountOfChoreCalls());
    }

    public void shutdownService(ChoreService service) {
        service.shutdown();
        Waiter.waitFor(CONF, 1000L, () -> service.isTerminated());
    }

    @Test
    public void testForceTrigger() throws InterruptedException {
        int period = 100;
        int delta = 10;
        CountingChore chore = new CountingChore("countingChore", 100);
        this.service.scheduleChore((ScheduledChore)chore);
        Thread.sleep(1010L);
        Assert.assertEquals((String)"10 periods have elapsed.", (long)11L, (long)chore.getCountOfChoreCalls());
        chore.triggerNow();
        Thread.sleep(10L);
        chore.triggerNow();
        Thread.sleep(10L);
        chore.triggerNow();
        Thread.sleep(10L);
        chore.triggerNow();
        Thread.sleep(10L);
        chore.triggerNow();
        Thread.sleep(10L);
        Assert.assertEquals((String)"Trigger was called 5 times after 10 periods.", (long)16L, (long)chore.getCountOfChoreCalls());
        Thread.sleep(1010L);
        Assert.assertTrue((String)("Expected at least 16 invocations, instead got " + chore.getCountOfChoreCalls()), (chore.getCountOfChoreCalls() > 16 ? 1 : 0) != 0);
    }

    @Test
    public void testCorePoolIncrease() throws InterruptedException {
        Assert.assertEquals((String)"Setting core pool size gave unexpected results.", (long)this.initialCorePoolSize, (long)this.service.getCorePoolSize());
        int slowChorePeriod = 100;
        SlowChore slowChore1 = new SlowChore("slowChore1", 100);
        SlowChore slowChore2 = new SlowChore("slowChore2", 100);
        SlowChore slowChore3 = new SlowChore("slowChore3", 100);
        this.service.scheduleChore((ScheduledChore)slowChore1);
        this.service.scheduleChore((ScheduledChore)slowChore2);
        this.service.scheduleChore((ScheduledChore)slowChore3);
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Should not create more pools than scheduled chores", (long)3L, (long)this.service.getCorePoolSize());
        SlowChore slowChore4 = new SlowChore("slowChore4", 100);
        this.service.scheduleChore((ScheduledChore)slowChore4);
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)4L, (long)this.service.getCorePoolSize());
        SlowChore slowChore5 = new SlowChore("slowChore5", 100);
        this.service.scheduleChore((ScheduledChore)slowChore5);
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)5L, (long)this.service.getCorePoolSize());
    }

    @Test
    public void testCorePoolDecrease() throws InterruptedException {
        int chorePeriod = 100;
        SlowChore slowChore1 = new SlowChore("slowChore1", 100);
        SlowChore slowChore2 = new SlowChore("slowChore2", 100);
        SlowChore slowChore3 = new SlowChore("slowChore3", 100);
        this.service.scheduleChore((ScheduledChore)slowChore1);
        this.service.scheduleChore((ScheduledChore)slowChore2);
        this.service.scheduleChore((ScheduledChore)slowChore3);
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Should not create more pools than scheduled chores", (long)this.service.getNumberOfScheduledChores(), (long)this.service.getCorePoolSize());
        SlowChore slowChore4 = new SlowChore("slowChore4", 100);
        this.service.scheduleChore((ScheduledChore)slowChore4);
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)this.service.getNumberOfScheduledChores(), (long)this.service.getCorePoolSize());
        SlowChore slowChore5 = new SlowChore("slowChore5", 100);
        this.service.scheduleChore((ScheduledChore)slowChore5);
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)this.service.getNumberOfScheduledChores(), (long)this.service.getCorePoolSize());
        Assert.assertEquals((long)5L, (long)this.service.getNumberOfChoresMissingStartTime());
        slowChore5.cancel();
        Thread.sleep(1000L);
        Assert.assertEquals((long)Math.max(1, this.service.getNumberOfScheduledChores()), (long)this.service.getCorePoolSize());
        Assert.assertEquals((long)4L, (long)this.service.getNumberOfChoresMissingStartTime());
        slowChore4.cancel();
        Thread.sleep(1000L);
        Assert.assertEquals((long)Math.max(1, this.service.getNumberOfScheduledChores()), (long)this.service.getCorePoolSize());
        Assert.assertEquals((long)3L, (long)this.service.getNumberOfChoresMissingStartTime());
        slowChore3.cancel();
        Thread.sleep(1000L);
        Assert.assertEquals((long)Math.max(1, this.service.getNumberOfScheduledChores()), (long)this.service.getCorePoolSize());
        Assert.assertEquals((long)2L, (long)this.service.getNumberOfChoresMissingStartTime());
        slowChore2.cancel();
        Thread.sleep(1000L);
        Assert.assertEquals((long)Math.max(1, this.service.getNumberOfScheduledChores()), (long)this.service.getCorePoolSize());
        Assert.assertEquals((long)1L, (long)this.service.getNumberOfChoresMissingStartTime());
        slowChore1.cancel();
        Thread.sleep(1000L);
        Assert.assertEquals((long)Math.max(1, this.service.getNumberOfScheduledChores()), (long)this.service.getCorePoolSize());
        Assert.assertEquals((long)0L, (long)this.service.getNumberOfChoresMissingStartTime());
    }

    @Test
    public void testNumberOfRunningChores() throws InterruptedException {
        int period = 100;
        int sleepTime = 5;
        DoNothingChore dn1 = new DoNothingChore("dn1", 100);
        DoNothingChore dn2 = new DoNothingChore("dn2", 100);
        DoNothingChore dn3 = new DoNothingChore("dn3", 100);
        DoNothingChore dn4 = new DoNothingChore("dn4", 100);
        DoNothingChore dn5 = new DoNothingChore("dn5", 100);
        this.service.scheduleChore((ScheduledChore)dn1);
        this.service.scheduleChore((ScheduledChore)dn2);
        this.service.scheduleChore((ScheduledChore)dn3);
        this.service.scheduleChore((ScheduledChore)dn4);
        this.service.scheduleChore((ScheduledChore)dn5);
        Thread.sleep(5L);
        Assert.assertEquals((String)"Scheduled chore mismatch", (long)5L, (long)this.service.getNumberOfScheduledChores());
        dn1.cancel();
        Thread.sleep(5L);
        Assert.assertEquals((String)"Scheduled chore mismatch", (long)4L, (long)this.service.getNumberOfScheduledChores());
        dn2.cancel();
        dn3.cancel();
        dn4.cancel();
        Thread.sleep(5L);
        Assert.assertEquals((String)"Scheduled chore mismatch", (long)1L, (long)this.service.getNumberOfScheduledChores());
        dn5.cancel();
        Thread.sleep(5L);
        Assert.assertEquals((String)"Scheduled chore mismatch", (long)0L, (long)this.service.getNumberOfScheduledChores());
    }

    @Test
    public void testNumberOfChoresMissingStartTime() throws InterruptedException {
        int period = 100;
        int sleepTime = 2000;
        SlowChore sc1 = new SlowChore("sc1", 100);
        SlowChore sc2 = new SlowChore("sc2", 100);
        SlowChore sc3 = new SlowChore("sc3", 100);
        SlowChore sc4 = new SlowChore("sc4", 100);
        SlowChore sc5 = new SlowChore("sc5", 100);
        this.service.scheduleChore((ScheduledChore)sc1);
        this.service.scheduleChore((ScheduledChore)sc2);
        this.service.scheduleChore((ScheduledChore)sc3);
        this.service.scheduleChore((ScheduledChore)sc4);
        this.service.scheduleChore((ScheduledChore)sc5);
        Thread.sleep(2000L);
        Assert.assertEquals((long)5L, (long)this.service.getNumberOfChoresMissingStartTime());
        sc1.cancel();
        Thread.sleep(2000L);
        Assert.assertEquals((long)4L, (long)this.service.getNumberOfChoresMissingStartTime());
        sc2.cancel();
        sc3.cancel();
        sc4.cancel();
        Thread.sleep(2000L);
        Assert.assertEquals((long)1L, (long)this.service.getNumberOfChoresMissingStartTime());
        sc5.cancel();
        Thread.sleep(2000L);
        Assert.assertEquals((long)0L, (long)this.service.getNumberOfChoresMissingStartTime());
    }

    @Test
    public void testMaximumChoreServiceThreads() throws InterruptedException {
        int period = 100;
        int sleepTime = 500;
        SlowChore sc1 = new SlowChore("sc1", 100);
        SlowChore sc2 = new SlowChore("sc2", 100);
        SlowChore sc3 = new SlowChore("sc3", 100);
        SlowChore sc4 = new SlowChore("sc4", 100);
        SlowChore sc5 = new SlowChore("sc5", 100);
        this.service.scheduleChore((ScheduledChore)sc1);
        this.service.scheduleChore((ScheduledChore)sc2);
        this.service.scheduleChore((ScheduledChore)sc3);
        this.service.scheduleChore((ScheduledChore)sc4);
        this.service.scheduleChore((ScheduledChore)sc5);
        Thread.sleep(500L);
        Assert.assertTrue((this.service.getCorePoolSize() <= this.service.getNumberOfScheduledChores() ? 1 : 0) != 0);
        SlowChore sc6 = new SlowChore("sc6", 100);
        SlowChore sc7 = new SlowChore("sc7", 100);
        SlowChore sc8 = new SlowChore("sc8", 100);
        SlowChore sc9 = new SlowChore("sc9", 100);
        SlowChore sc10 = new SlowChore("sc10", 100);
        this.service.scheduleChore((ScheduledChore)sc6);
        this.service.scheduleChore((ScheduledChore)sc7);
        this.service.scheduleChore((ScheduledChore)sc8);
        this.service.scheduleChore((ScheduledChore)sc9);
        this.service.scheduleChore((ScheduledChore)sc10);
        Thread.sleep(500L);
        Assert.assertTrue((this.service.getCorePoolSize() <= this.service.getNumberOfScheduledChores() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangingChoreServices() throws InterruptedException {
        int period = 100;
        int sleepTime = 10;
        ChoreService anotherService = new ChoreService(this.name.getMethodName() + "_2");
        DoNothingChore chore = new DoNothingChore("sample", 100);
        try {
            Assert.assertFalse((boolean)chore.isScheduled());
            Assert.assertFalse((boolean)this.service.isChoreScheduled((ScheduledChore)chore));
            Assert.assertFalse((boolean)anotherService.isChoreScheduled((ScheduledChore)chore));
            Assert.assertTrue((chore.getChoreService() == null ? 1 : 0) != 0);
            this.service.scheduleChore((ScheduledChore)chore);
            Thread.sleep(10L);
            Assert.assertTrue((boolean)chore.isScheduled());
            Assert.assertTrue((boolean)this.service.isChoreScheduled((ScheduledChore)chore));
            Assert.assertFalse((boolean)anotherService.isChoreScheduled((ScheduledChore)chore));
            Assert.assertFalse((chore.getChoreService() == null ? 1 : 0) != 0);
            anotherService.scheduleChore((ScheduledChore)chore);
            Thread.sleep(10L);
            Assert.assertTrue((boolean)chore.isScheduled());
            Assert.assertFalse((boolean)this.service.isChoreScheduled((ScheduledChore)chore));
            Assert.assertTrue((boolean)anotherService.isChoreScheduled((ScheduledChore)chore));
            Assert.assertFalse((chore.getChoreService() == null ? 1 : 0) != 0);
            chore.cancel();
            Assert.assertFalse((boolean)chore.isScheduled());
            Assert.assertFalse((boolean)this.service.isChoreScheduled((ScheduledChore)chore));
            Assert.assertFalse((boolean)anotherService.isChoreScheduled((ScheduledChore)chore));
            Assert.assertTrue((chore.getChoreService() == null ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(anotherService);
        }
    }

    @Test
    public void testStopperForScheduledChores() throws InterruptedException {
        SampleStopper stopperForGroup1 = new SampleStopper();
        SampleStopper stopperForGroup2 = new SampleStopper();
        int period = 100;
        int delta = 10;
        DoNothingChore chore1_group1 = new DoNothingChore("c1g1", stopperForGroup1, 100);
        DoNothingChore chore2_group1 = new DoNothingChore("c2g1", stopperForGroup1, 100);
        DoNothingChore chore3_group1 = new DoNothingChore("c3g1", stopperForGroup1, 100);
        DoNothingChore chore1_group2 = new DoNothingChore("c1g2", stopperForGroup2, 100);
        DoNothingChore chore2_group2 = new DoNothingChore("c2g2", stopperForGroup2, 100);
        DoNothingChore chore3_group2 = new DoNothingChore("c3g2", stopperForGroup2, 100);
        this.service.scheduleChore((ScheduledChore)chore1_group1);
        this.service.scheduleChore((ScheduledChore)chore2_group1);
        this.service.scheduleChore((ScheduledChore)chore3_group1);
        this.service.scheduleChore((ScheduledChore)chore1_group2);
        this.service.scheduleChore((ScheduledChore)chore2_group2);
        this.service.scheduleChore((ScheduledChore)chore3_group2);
        Thread.sleep(10L);
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)chore1_group1.isScheduled());
        Assert.assertTrue((boolean)chore2_group1.isScheduled());
        Assert.assertTrue((boolean)chore3_group1.isScheduled());
        Assert.assertTrue((boolean)chore1_group2.isScheduled());
        Assert.assertTrue((boolean)chore2_group2.isScheduled());
        Assert.assertTrue((boolean)chore3_group2.isScheduled());
        stopperForGroup1.stop("test stopping group 1");
        Thread.sleep(100L);
        Assert.assertFalse((boolean)chore1_group1.isScheduled());
        Assert.assertFalse((boolean)chore2_group1.isScheduled());
        Assert.assertFalse((boolean)chore3_group1.isScheduled());
        Assert.assertTrue((boolean)chore1_group2.isScheduled());
        Assert.assertTrue((boolean)chore2_group2.isScheduled());
        Assert.assertTrue((boolean)chore3_group2.isScheduled());
        stopperForGroup2.stop("test stopping group 2");
        Thread.sleep(100L);
        Assert.assertFalse((boolean)chore1_group1.isScheduled());
        Assert.assertFalse((boolean)chore2_group1.isScheduled());
        Assert.assertFalse((boolean)chore3_group1.isScheduled());
        Assert.assertFalse((boolean)chore1_group2.isScheduled());
        Assert.assertFalse((boolean)chore2_group2.isScheduled());
        Assert.assertFalse((boolean)chore3_group2.isScheduled());
    }

    @Test
    public void testShutdownCancelsScheduledChores() throws InterruptedException {
        int period = 100;
        DoNothingChore successChore1 = new DoNothingChore("sc1", 100);
        DoNothingChore successChore2 = new DoNothingChore("sc2", 100);
        DoNothingChore successChore3 = new DoNothingChore("sc3", 100);
        Assert.assertTrue((boolean)this.service.scheduleChore((ScheduledChore)successChore1));
        Assert.assertTrue((boolean)successChore1.isScheduled());
        Assert.assertTrue((boolean)this.service.scheduleChore((ScheduledChore)successChore2));
        Assert.assertTrue((boolean)successChore2.isScheduled());
        Assert.assertTrue((boolean)this.service.scheduleChore((ScheduledChore)successChore3));
        Assert.assertTrue((boolean)successChore3.isScheduled());
        this.shutdownService(this.service);
        Assert.assertFalse((boolean)successChore1.isScheduled());
        Assert.assertFalse((boolean)successChore2.isScheduled());
        Assert.assertFalse((boolean)successChore3.isScheduled());
    }

    @Test
    public void testShutdownWorksWhileChoresAreExecuting() throws InterruptedException {
        int period = 100;
        int sleep = 500;
        SleepingChore slowChore1 = new SleepingChore("sc1", 100, 500);
        SleepingChore slowChore2 = new SleepingChore("sc2", 100, 500);
        SleepingChore slowChore3 = new SleepingChore("sc3", 100, 500);
        Assert.assertTrue((boolean)this.service.scheduleChore((ScheduledChore)slowChore1));
        Assert.assertTrue((boolean)this.service.scheduleChore((ScheduledChore)slowChore2));
        Assert.assertTrue((boolean)this.service.scheduleChore((ScheduledChore)slowChore3));
        Thread.sleep(250L);
        this.shutdownService(this.service);
        Assert.assertFalse((boolean)slowChore1.isScheduled());
        Assert.assertFalse((boolean)slowChore2.isScheduled());
        Assert.assertFalse((boolean)slowChore3.isScheduled());
        Assert.assertTrue((boolean)this.service.isShutdown());
        Thread.sleep(5L);
        Assert.assertTrue((boolean)this.service.isTerminated());
    }

    @Test
    public void testShutdownRejectsNewSchedules() throws InterruptedException {
        int period = 100;
        DoNothingChore successChore1 = new DoNothingChore("sc1", 100);
        DoNothingChore successChore2 = new DoNothingChore("sc2", 100);
        DoNothingChore successChore3 = new DoNothingChore("sc3", 100);
        DoNothingChore failChore1 = new DoNothingChore("fc1", 100);
        DoNothingChore failChore2 = new DoNothingChore("fc2", 100);
        DoNothingChore failChore3 = new DoNothingChore("fc3", 100);
        Assert.assertTrue((boolean)this.service.scheduleChore((ScheduledChore)successChore1));
        Assert.assertTrue((boolean)successChore1.isScheduled());
        Assert.assertTrue((boolean)this.service.scheduleChore((ScheduledChore)successChore2));
        Assert.assertTrue((boolean)successChore2.isScheduled());
        Assert.assertTrue((boolean)this.service.scheduleChore((ScheduledChore)successChore3));
        Assert.assertTrue((boolean)successChore3.isScheduled());
        this.shutdownService(this.service);
        Assert.assertFalse((boolean)this.service.scheduleChore((ScheduledChore)failChore1));
        Assert.assertFalse((boolean)failChore1.isScheduled());
        Assert.assertFalse((boolean)this.service.scheduleChore((ScheduledChore)failChore2));
        Assert.assertFalse((boolean)failChore2.isScheduled());
        Assert.assertFalse((boolean)this.service.scheduleChore((ScheduledChore)failChore3));
        Assert.assertFalse((boolean)failChore3.isScheduled());
    }

    @Test
    public void testInitialDelay() {
        final SampleStopper stopper = new SampleStopper();
        this.service.scheduleChore(new ScheduledChore("chore", stopper, 1000, 2000L){

            protected void chore() {
                stopper.stop("test");
            }
        });
        Waiter.waitFor(CONF, 5000L, () -> stopper.isStopped());
    }

    @Test
    public void testCleanupWithStopper() {
        SampleStopper stopper = new SampleStopper();
        DoNothingChore chore = (DoNothingChore)((Object)Mockito.spy((Object)((Object)new DoNothingChore("chore", stopper, 10))));
        this.service.scheduleChore((ScheduledChore)chore);
        Assert.assertTrue((boolean)chore.isScheduled());
        ((DoNothingChore)((Object)Mockito.verify((Object)((Object)chore), (VerificationMode)Mockito.never()))).cleanup();
        stopper.stop("test");
        Waiter.waitFor(CONF, 200L, () -> !chore.isScheduled());
        ((DoNothingChore)((Object)Mockito.verify((Object)((Object)chore), (VerificationMode)Mockito.atLeastOnce()))).cleanup();
    }

    @Test
    public void testCleanupWithShutdown() {
        DoNothingChore chore = (DoNothingChore)((Object)Mockito.spy((Object)((Object)new DoNothingChore("chore", 10))));
        this.service.scheduleChore((ScheduledChore)chore);
        Assert.assertTrue((boolean)chore.isScheduled());
        ((DoNothingChore)((Object)Mockito.verify((Object)((Object)chore), (VerificationMode)Mockito.never()))).cleanup();
        chore.shutdown(true);
        Waiter.waitFor(CONF, 200L, () -> !chore.isScheduled());
        ((DoNothingChore)((Object)Mockito.verify((Object)((Object)chore), (VerificationMode)Mockito.atLeastOnce()))).cleanup();
    }

    public static class FailInitialChore
    extends ScheduledChore {
        private int numberOfFailures = 0;
        private int failureThreshold;

        public FailInitialChore(String name, int period, int failThreshold) {
            this(name, new SampleStopper(), period, failThreshold);
        }

        public FailInitialChore(String name, Stoppable stopper, int period, int failThreshold) {
            super(name, stopper, period);
            this.failureThreshold = failThreshold;
        }

        protected boolean initialChore() {
            if (this.numberOfFailures < this.failureThreshold) {
                ++this.numberOfFailures;
                return false;
            }
            return true;
        }

        protected void chore() {
            Assert.assertTrue((this.numberOfFailures == this.failureThreshold ? 1 : 0) != 0);
            this.cancel(false);
        }
    }

    private static class CountingChore
    extends ScheduledChore {
        private int countOfChoreCalls = 0;
        private boolean outputOnTicks = false;

        public CountingChore(String name, int period) {
            this(name, new SampleStopper(), period);
        }

        public CountingChore(String name, Stoppable stopper, int period) {
            this(name, stopper, period, false);
        }

        public CountingChore(String name, Stoppable stopper, int period, boolean outputOnTicks) {
            super(name, stopper, period);
            this.outputOnTicks = outputOnTicks;
        }

        protected boolean initialChore() {
            ++this.countOfChoreCalls;
            if (this.outputOnTicks) {
                this.outputTickCount();
            }
            return true;
        }

        protected void chore() {
            ++this.countOfChoreCalls;
            if (this.outputOnTicks) {
                this.outputTickCount();
            }
        }

        private void outputTickCount() {
            LOG.info("Chore: " + this.getName() + ". Count of chore calls: " + this.countOfChoreCalls);
        }

        public int getCountOfChoreCalls() {
            return this.countOfChoreCalls;
        }
    }

    private static class SleepingChore
    extends ScheduledChore {
        private int sleepTime;

        public SleepingChore(String name, int chorePeriod, int sleepTime) {
            this(name, new SampleStopper(), chorePeriod, sleepTime);
        }

        public SleepingChore(String name, Stoppable stopper, int period, int sleepTime) {
            super(name, stopper, period);
            this.sleepTime = sleepTime;
        }

        protected boolean initialChore() {
            Threads.sleep((long)this.sleepTime);
            return true;
        }

        protected void chore() {
            Threads.sleep((long)this.sleepTime);
        }
    }

    private static class DoNothingChore
    extends ScheduledChore {
        public DoNothingChore(String name, int period) {
            super(name, (Stoppable)new SampleStopper(), period);
        }

        public DoNothingChore(String name, Stoppable stopper, int period) {
            super(name, stopper, period);
        }

        protected void chore() {
        }
    }

    private static class SlowChore
    extends ScheduledChore {
        public SlowChore(String name, int period) {
            this(name, new SampleStopper(), period);
        }

        public SlowChore(String name, Stoppable stopper, int period) {
            super(name, stopper, period);
        }

        protected boolean initialChore() {
            Threads.sleep((long)(this.getPeriod() * 2));
            return true;
        }

        protected void chore() {
            Threads.sleep((long)(this.getPeriod() * 2));
        }
    }

    private static class SampleStopper
    implements Stoppable {
        private boolean stopped = false;

        private SampleStopper() {
        }

        public void stop(String why) {
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }
}

