/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContext;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;

public class X509TestContextProvider {
    private final Configuration conf;
    private final File tempDir;
    private final LoadingCache<CacheKey, X509TestContext> ctxs = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, X509TestContext>(){

        public X509TestContext load(CacheKey key) throws Exception {
            return X509TestContext.newBuilder(X509TestContextProvider.this.conf).setTempDir(X509TestContextProvider.this.tempDir).setKeyStorePassword(key.keyPassword).setKeyStoreKeyType(key.certKeyType).setTrustStorePassword(key.keyPassword).setTrustStoreKeyType(key.caKeyType).build();
        }
    });

    public X509TestContextProvider(Configuration conf, File tempDir) {
        this.conf = conf;
        this.tempDir = tempDir;
    }

    public X509TestContext get(X509KeyType caKeyType, X509KeyType certKeyType, char[] keyPassword) {
        return (X509TestContext)this.ctxs.getUnchecked((Object)new CacheKey(caKeyType, certKeyType, keyPassword));
    }

    static Collection<Object[]> defaultParams() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int paramIndex = 0;
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (X509KeyType certKeyType : X509KeyType.values()) {
                for (char[] keyPassword : new char[][]{"".toCharArray(), "pa$$w0rd".toCharArray()}) {
                    params.add(new Object[]{caKeyType, certKeyType, keyPassword, paramIndex++});
                }
            }
        }
        return params;
    }

    private static final class CacheKey {
        private final X509KeyType caKeyType;
        private final X509KeyType certKeyType;
        private final char[] keyPassword;

        CacheKey(X509KeyType caKeyType, X509KeyType certKeyType, char[] keyPassword) {
            this.caKeyType = caKeyType;
            this.certKeyType = certKeyType;
            this.keyPassword = keyPassword;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.caKeyType, this.certKeyType, Arrays.hashCode(this.keyPassword)});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.caKeyType == other.caKeyType && this.certKeyType == other.certKeyType && Arrays.equals(this.keyPassword, other.keyPassword);
        }
    }
}

