/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.CreateStoreFileWriterParams;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FSProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class StoreFileTrackerBase
implements StoreFileTracker {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFileTrackerBase.class);
    protected final Configuration conf;
    protected final boolean isPrimaryReplica;
    protected final StoreContext ctx;
    private volatile boolean cacheOnWriteLogged;

    protected StoreFileTrackerBase(Configuration conf, boolean isPrimaryReplica, StoreContext ctx) {
        this.conf = conf;
        this.isPrimaryReplica = isPrimaryReplica;
        this.ctx = ctx;
    }

    @Override
    public final List<StoreFileInfo> load() throws IOException {
        return this.doLoadStoreFiles(!this.isPrimaryReplica);
    }

    @Override
    public final void add(Collection<StoreFileInfo> newFiles) throws IOException {
        if (this.isPrimaryReplica) {
            this.doAddNewStoreFiles(newFiles);
        }
    }

    @Override
    public final void replace(Collection<StoreFileInfo> compactedFiles, Collection<StoreFileInfo> newFiles) throws IOException {
        if (this.isPrimaryReplica) {
            this.doAddCompactionResults(compactedFiles, newFiles);
        }
    }

    @Override
    public final void set(List<StoreFileInfo> files) throws IOException {
        if (this.isPrimaryReplica) {
            this.doSetStoreFiles(files);
        }
    }

    @Override
    public TableDescriptorBuilder updateWithTrackerConfigs(TableDescriptorBuilder builder) {
        builder.setValue("hbase.store.file-tracker.impl", this.getTrackerName());
        return builder;
    }

    protected final String getTrackerName() {
        return StoreFileTrackerFactory.getStoreFileTrackerName(this.getClass());
    }

    private HFileContext createFileContext(Compression.Algorithm compression, boolean includeMVCCReadpoint, boolean includesTag, Encryption.Context encryptionContext) {
        if (compression == null) {
            compression = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        ColumnFamilyDescriptor family = this.ctx.getFamily();
        HFileContext hFileContext = new HFileContextBuilder().withIncludesMvcc(includeMVCCReadpoint).withIncludesTags(includesTag).withCompression(compression).withCompressTags(family.isCompressTags()).withChecksumType(StoreUtils.getChecksumType(this.conf)).withBytesPerCheckSum(StoreUtils.getBytesPerChecksum(this.conf)).withBlockSize(family.getBlocksize()).withHBaseCheckSum(true).withDataBlockEncoding(family.getDataBlockEncoding()).withEncryptionContext(encryptionContext).withCreateTime(EnvironmentEdgeManager.currentTime()).withColumnFamily(family.getName()).withTableName(this.ctx.getTableName().getName()).withCellComparator(this.ctx.getComparator()).withIndexBlockEncoding(family.getIndexBlockEncoding()).build();
        return hFileContext;
    }

    @Override
    public final StoreFileWriter createWriter(CreateStoreFileWriterParams params) throws IOException {
        if (!this.isPrimaryReplica) {
            throw new IllegalStateException("Should not call create writer on secondary replicas");
        }
        CacheConfig cacheConf = this.ctx.getCacheConf();
        CacheConfig writerCacheConf = new CacheConfig(cacheConf);
        long totalCompactedFilesSize = params.totalCompactedFilesSize();
        if (params.isCompaction()) {
            boolean cacheCompactedBlocksOnWrite = cacheConf.shouldCacheCompactedBlocksOnWrite();
            if (cacheCompactedBlocksOnWrite && totalCompactedFilesSize <= cacheConf.getCacheCompactedBlocksOnWriteThreshold()) {
                writerCacheConf.enableCacheOnWrite();
                if (!this.cacheOnWriteLogged) {
                    LOG.info("For {} , cacheCompactedBlocksOnWrite is true, hence enabled cacheOnWrite for Data blocks, Index blocks and Bloom filter blocks", (Object)this);
                    this.cacheOnWriteLogged = true;
                }
            } else {
                writerCacheConf.setCacheDataOnWrite(false);
                if (totalCompactedFilesSize > cacheConf.getCacheCompactedBlocksOnWriteThreshold()) {
                    LOG.debug("For {}, setting cacheCompactedBlocksOnWrite as false as total size of compacted files - {}, is greater than cacheCompactedBlocksOnWriteThreshold - {}", new Object[]{this, totalCompactedFilesSize, cacheConf.getCacheCompactedBlocksOnWriteThreshold()});
                }
            }
        } else {
            boolean shouldCacheDataOnWrite = cacheConf.shouldCacheDataOnWrite();
            if (shouldCacheDataOnWrite) {
                writerCacheConf.enableCacheOnWrite();
                if (!this.cacheOnWriteLogged) {
                    LOG.info("For {} , cacheDataOnWrite is true, hence enabled cacheOnWrite for Index blocks and Bloom filter blocks", (Object)this);
                    this.cacheOnWriteLogged = true;
                }
            }
        }
        Encryption.Context encryptionContext = this.ctx.getEncryptionContext();
        HFileContext hFileContext = this.createFileContext(params.compression(), params.includeMVCCReadpoint(), params.includesTag(), encryptionContext);
        Path outputDir = this.requireWritingToTmpDirFirst() ? new Path(this.ctx.getRegionFileSystem().getTempDir(), this.ctx.getFamily().getNameAsString()) : this.ctx.getFamilyStoreDirectoryPath();
        StoreFileWriter.Builder builder = new StoreFileWriter.Builder(this.conf, writerCacheConf, this.ctx.getRegionFileSystem().getFileSystem()).withOutputDir(outputDir).withBloomType(this.ctx.getBloomFilterType()).withMaxKeyCount(params.maxKeyCount()).withFavoredNodes(this.ctx.getFavoredNodes()).withFileContext(hFileContext).withShouldDropCacheBehind(params.shouldDropBehind()).withCompactedFilesSupplier(this.ctx.getCompactedFilesSupplier()).withFileStoragePolicy(params.fileStoragePolicy()).withWriterCreationTracker(params.writerCreationTracker()).withMaxVersions(this.ctx.getMaxVersions()).withNewVersionBehavior(this.ctx.getNewVersionBehavior()).withCellComparator(this.ctx.getComparator()).withIsCompaction(params.isCompaction());
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference createReference(Reference reference, Path path) throws IOException {
        try (FSDataOutputStream out = this.ctx.getRegionFileSystem().getFileSystem().create(path, false);){
            out.write(reference.toByteArray());
        }
        return reference;
    }

    @Override
    public boolean hasReferences() throws IOException {
        Path storeDir = this.ctx.getRegionFileSystem().getStoreDir(this.ctx.getFamily().getNameAsString());
        FileStatus[] files = CommonFSUtils.listStatus((FileSystem)this.ctx.getRegionFileSystem().getFileSystem(), (Path)storeDir);
        if (files != null) {
            for (FileStatus stat : files) {
                if (stat.isDirectory() || !StoreFileInfo.isReference(stat.getPath())) continue;
                LOG.trace("Reference {}", (Object)stat.getPath());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference readReference(Path p) throws IOException {
        try (Object in = this.ctx.getRegionFileSystem().getFileSystem().open(p);){
            in = ((InputStream)in).markSupported() ? in : new BufferedInputStream((InputStream)in);
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ((InputStream)in).mark(pblen);
            byte[] pbuf = new byte[pblen];
            IOUtils.readFully((InputStream)in, (byte[])pbuf, (int)0, (int)pblen);
            if (ProtobufUtil.isPBMagicPrefix((byte[])pbuf)) {
                Reference reference = Reference.convert(FSProtos.Reference.parseFrom((InputStream)in));
                return reference;
            }
            ((InputStream)in).reset();
            Reference r = new Reference();
            DataInputStream dis = new DataInputStream((InputStream)in);
            in = dis;
            r.readFields(dis);
            Reference reference = r;
            return reference;
        }
    }

    @Override
    public StoreFileInfo getStoreFileInfo(Path initialPath, boolean primaryReplica) throws IOException {
        return this.getStoreFileInfo(null, initialPath, primaryReplica);
    }

    @Override
    public StoreFileInfo getStoreFileInfo(FileStatus fileStatus, Path initialPath, boolean primaryReplica) throws IOException {
        FileSystem fs = this.ctx.getRegionFileSystem().getFileSystem();
        assert (fs != null);
        assert (initialPath != null);
        assert (this.conf != null);
        Reference reference = null;
        HFileLink link = null;
        long createdTimestamp = 0L;
        long size = 0L;
        Path p = initialPath;
        if (HFileLink.isHFileLink(p)) {
            reference = null;
            link = HFileLink.buildFromHFileLinkPattern(this.conf, p);
            LOG.trace("{} is a link", (Object)p);
        } else if (StoreFileInfo.isReference(p)) {
            reference = this.readReference(p);
            Path referencePath = StoreFileInfo.getReferredToFile(p);
            link = HFileLink.isHFileLink(referencePath) ? HFileLink.buildFromHFileLinkPattern(this.conf, referencePath) : null;
            LOG.trace("{} is a {} reference to {}", new Object[]{p, reference.getFileRegion(), referencePath});
        } else if (StoreFileInfo.isHFile(p) || StoreFileInfo.isMobFile(p) || StoreFileInfo.isMobRefFile(p)) {
            if (fileStatus != null) {
                createdTimestamp = fileStatus.getModificationTime();
                size = fileStatus.getLen();
            } else {
                FileStatus fStatus = fs.getFileStatus(initialPath);
                createdTimestamp = fStatus.getModificationTime();
                size = fStatus.getLen();
            }
        } else {
            throw new IOException("path=" + p + " doesn't look like a valid StoreFile");
        }
        return new StoreFileInfo(this.conf, fs, createdTimestamp, initialPath, size, reference, link, this.isPrimaryReplica);
    }

    protected abstract List<StoreFileInfo> doLoadStoreFiles(boolean var1) throws IOException;

    protected abstract void doAddNewStoreFiles(Collection<StoreFileInfo> var1) throws IOException;

    protected abstract void doAddCompactionResults(Collection<StoreFileInfo> var1, Collection<StoreFileInfo> var2) throws IOException;

    protected abstract void doSetStoreFiles(Collection<StoreFileInfo> var1) throws IOException;
}

