/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.kerby.config.Config;

public class ConfigObject {
    private ValueType valueType;
    private Object value;

    public ConfigObject(String value) {
        this.value = value;
        this.valueType = ValueType.PROPERTY;
    }

    public ConfigObject(String[] values) {
        ArrayList<String> valuesList = new ArrayList<String>();
        for (String v : values) {
            valuesList.add(v);
        }
        this.value = valuesList;
        this.valueType = ValueType.LIST;
    }

    public ConfigObject(List<String> values) {
        this.value = values != null ? new ArrayList<String>(values) : new ArrayList();
        this.valueType = ValueType.LIST;
    }

    public ConfigObject(Config value) {
        this.value = value;
        this.valueType = ValueType.CONFIG;
    }

    public String getPropertyValue() {
        String result = null;
        if (this.valueType == ValueType.PROPERTY) {
            result = (String)this.value;
        }
        return result;
    }

    public List<String> getListValues() {
        List results = null;
        if (this.valueType == ValueType.LIST && this.value instanceof List) {
            results = (List)this.value;
        }
        return results;
    }

    public Config getConfigValue() {
        Config result = null;
        if (this.valueType == ValueType.CONFIG) {
            result = (Config)this.value;
        }
        return result;
    }

    protected static enum ValueType {
        PROPERTY,
        LIST,
        CONFIG;

    }
}

