/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RestoreSnapshotFromClientTestBase;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;

public class RestoreSnapshotFromClientSimpleTestBase
extends RestoreSnapshotFromClientTestBase {
    @Test
    public void testRestoreSnapshot() throws IOException {
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot1Rows);
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName1, this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot0Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.emptySnapshot);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, 0L);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot1Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
        TEST_UTIL.deleteTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        this.verifyRowCount(TEST_UTIL, this.tableName, this.snapshot1Rows);
        SnapshotTestingUtils.verifyReplicasCameOnline(this.tableName, this.admin, this.getNumReplicas());
    }

    @Test
    public void testCorruptedSnapshot() throws IOException, InterruptedException {
        SnapshotTestingUtils.corruptSnapshot(TEST_UTIL, Bytes.toString((byte[])this.snapshotName0));
        TableName cloneName = TableName.valueOf((String)(this.getValidMethodName() + "-" + EnvironmentEdgeManager.currentTime()));
        try {
            this.admin.cloneSnapshot(this.snapshotName0, cloneName);
            Assert.fail((String)"Expected CorruptedSnapshotException, got succeeded cloneSnapshot()");
        }
        catch (CorruptedSnapshotException e) {
            Assert.assertFalse((boolean)this.admin.tableExists(cloneName));
        }
        catch (Exception e) {
            Assert.fail((String)("Expected CorruptedSnapshotException got: " + e));
        }
    }
}

