/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mob.MobTestUtil;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.RSMobFileCleanerChore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRSMobFileCleanerChore {
    private static final Logger LOG = LoggerFactory.getLogger(TestRSMobFileCleanerChore.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSMobFileCleanerChore.class);
    private HBaseTestingUtility HTU;
    private static final String famStr = "f1";
    private static final byte[] fam = Bytes.toBytes((String)"f1");
    private static final byte[] qualifier = Bytes.toBytes((String)"q1");
    private static final long mobLen = 10L;
    private static final byte[] mobVal = Bytes.toBytes((String)"01234567890123456789012345678901234567890123456789012345678901234567890123456789");
    private Configuration conf;
    private TableDescriptorBuilder.ModifyableTableDescriptor tableDescriptor;
    private ColumnFamilyDescriptor familyDescriptor;
    private Admin admin;
    private Table table = null;
    private RSMobFileCleanerChore chore;
    private long minAgeToArchive = 10000L;

    @Before
    public void setUp() throws Exception {
        this.HTU = new HBaseTestingUtility();
        this.conf = this.HTU.getConfiguration();
        this.initConf();
        this.HTU.startMiniCluster();
        this.admin = this.HTU.getAdmin();
        this.familyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])fam).setMobEnabled(true).setMobThreshold(10L).setMaxVersions(1).build();
        this.tableDescriptor = this.HTU.createModifyableTableDescriptor("testMobCompactTable").setColumnFamily(this.familyDescriptor);
        this.table = this.HTU.createTable((TableDescriptor)this.tableDescriptor, Bytes.toByteArrays((String)"1"));
    }

    private void initConf() {
        this.conf.setInt("hfile.format.version", 3);
        this.conf.setLong("hbase.master.hfilecleaner.ttl", 0L);
        this.conf.setInt("hbase.client.retries.number", 100);
        this.conf.setInt("hbase.hregion.max.filesize", 200000000);
        this.conf.setInt("hbase.hregion.memstore.flush.size", 800000);
        this.conf.setInt("hbase.hstore.blockingStoreFiles", 150);
        this.conf.setInt("hbase.hstore.compaction.throughput.lower.bound", 0x3200000);
        this.conf.setInt("hbase.hstore.compaction.throughput.higher.bound", 0x6400000);
        this.conf.setLong("hbase.mob.compaction.chore.period", 0L);
        this.conf.setLong("hbase.master.mob.cleaner.period", 0L);
        this.conf.setLong("hbase.mob.min.age.archive", this.minAgeToArchive);
        this.conf.setLong("hbase.hfile.compaction.discharger.interval", this.minAgeToArchive / 2L);
    }

    private void loadData(Table t, int start, int num) {
        try {
            for (int i = 0; i < num; ++i) {
                Put p = new Put(Bytes.toBytes((int)(start + i)));
                p.addColumn(fam, qualifier, mobVal);
                t.put(p);
            }
            this.admin.flush(t.getName());
        }
        catch (Exception e) {
            LOG.error("MOB file cleaner chore test FAILED", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.admin.disableTable(this.tableDescriptor.getTableName());
        this.admin.deleteTable(this.tableDescriptor.getTableName());
        this.HTU.shutdownMiniCluster();
    }

    @Test
    public void testMobFileCleanerChore() throws InterruptedException, IOException {
        this.loadData(this.table, 0, 10);
        this.loadData(this.table, 10, 10);
        long num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)2L, (long)num);
        this.admin.majorCompact(this.tableDescriptor.getTableName(), fam);
        while (this.admin.getCompactionState(this.tableDescriptor.getTableName()) != CompactionState.NONE) {
            Thread.sleep(100L);
        }
        num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)3L, (long)num);
        LOG.info("Waiting for {}ms", (Object)(this.minAgeToArchive + 1000L));
        Thread.sleep(this.minAgeToArchive + 1000L);
        LOG.info("Cleaning up MOB files");
        ServerName serverUsed = null;
        List serverRegions = null;
        for (ServerName sn : this.admin.getRegionServers()) {
            serverRegions = this.admin.getRegions(sn);
            if (serverRegions == null || serverRegions.size() <= 0) continue;
            if ((serverRegions = serverRegions.stream().filter(r -> r.getTable() == this.table.getName()).collect(Collectors.toList())).size() <= 0) break;
            serverUsed = sn;
            break;
        }
        this.chore = this.HTU.getMiniHBaseCluster().getRegionServer(serverUsed).getRSMobFileCleanerChore();
        this.chore.chore();
        num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)(3 - serverRegions.size()), (long)num);
        long scanned = this.scanTable();
        Assert.assertEquals((long)20L, (long)scanned);
        Path extraMOBFile = MobTestUtil.generateMOBFileForRegion(this.conf, this.table.getName(), this.familyDescriptor, "nonExistentRegion");
        num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)(4 - serverRegions.size()), (long)num);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Assert.assertTrue((boolean)fs.exists(extraMOBFile));
        LOG.info("Waiting for {}ms", (Object)(this.minAgeToArchive + 1000L));
        Thread.sleep(this.minAgeToArchive + 1000L);
        LOG.info("Cleaning up MOB files");
        this.chore.chore();
        num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)(4 - serverRegions.size()), (long)num);
        Assert.assertTrue((boolean)fs.exists(extraMOBFile));
        scanned = this.scanTable();
        Assert.assertEquals((long)20L, (long)scanned);
    }

    @Test
    public void testCleaningAndStoreFileReaderCreatedByOtherThreads() throws IOException, InterruptedException {
        TableName testTable = TableName.valueOf((String)"testCleaningAndStoreFileReaderCreatedByOtherThreads");
        ColumnFamilyDescriptor cfDesc = ColumnFamilyDescriptorBuilder.newBuilder((byte[])fam).setMobEnabled(true).setMobThreshold(10L).setMaxVersions(1).build();
        TableDescriptor tDesc = TableDescriptorBuilder.newBuilder((TableName)testTable).setColumnFamily(cfDesc).build();
        this.admin.createTable(tDesc);
        Assert.assertTrue((boolean)this.admin.tableExists(testTable));
        this.loadData(this.admin.getConnection().getTable(testTable), 0, 10);
        HRegion region = this.HTU.getHBaseCluster().getRegions(testTable).get(0);
        HStore store = region.getStore(fam);
        Collection storeFiles = store.getStorefiles();
        Assert.assertEquals((long)1L, (long)store.getStorefiles().size());
        HStoreFile sf = (HStoreFile)storeFiles.iterator().next();
        Assert.assertNotNull((Object)sf);
        long mobFileNum = this.getNumberOfMobFiles(this.conf, testTable, new String(fam));
        Assert.assertEquals((long)1L, (long)mobFileNum);
        ServerName serverName = null;
        for (ServerName sn : this.admin.getRegionServers()) {
            boolean flag = this.admin.getRegions(sn).stream().anyMatch(r -> r.getRegionNameAsString().equals(region.getRegionInfo().getRegionNameAsString()));
            if (!flag) continue;
            serverName = sn;
            break;
        }
        Assert.assertNotNull(serverName);
        RSMobFileCleanerChore cleanerChore = this.HTU.getHBaseCluster().getRegionServer(serverName).getRSMobFileCleanerChore();
        CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> {
            boolean readerIsNotNull = false;
            try {
                sf.initReader();
                Thread.sleep(10000L);
                readerIsNotNull = sf.getReader() != null;
                sf.closeStoreFile(true);
            }
            catch (Exception e) {
                LOG.error("We occur an exception", (Throwable)e);
            }
            return readerIsNotNull;
        });
        Thread.sleep(100L);
        cleanerChore.chore();
        Boolean readerIsNotNull = future.join();
        Assert.assertTrue((boolean)readerIsNotNull);
        this.admin.disableTable(testTable);
        this.admin.deleteTable(testTable);
    }

    private long getNumberOfMobFiles(Configuration conf, TableName tableName, String family) throws IOException {
        FileStatus[] stat;
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path dir = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)family);
        for (FileStatus st : stat = fs.listStatus(dir)) {
            LOG.debug("DDDD MOB Directory content: {} size={}", (Object)st.getPath(), (Object)st.getLen());
        }
        LOG.debug("MOB Directory content total files: {}", (Object)stat.length);
        return stat.length;
    }

    private long scanTable() {
        try {
            Result result;
            ResultScanner scanner = this.table.getScanner(fam);
            long counter = 0L;
            while ((result = scanner.next()) != null) {
                Assert.assertTrue((boolean)Arrays.equals(result.getValue(fam, qualifier), mobVal));
                ++counter;
            }
            return counter;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("MOB file cleaner chore test FAILED");
            if (this.HTU != null) {
                Assert.assertTrue((boolean)false);
            } else {
                System.exit(-1);
            }
            return 0L;
        }
    }
}

