/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.quotas.RegionSizeStoreImpl;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellChunkImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.CreateStoreFileWriterParams;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.ImmutableMemStoreLAB;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactionStrategy;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactor;
import org.apache.hadoop.hbase.regionserver.MemStoreLABImpl;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.NonThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.RegionServicesForStores;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentScanner;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.ThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.VersionedSegmentsList;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.EverythingPolicy;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestHStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHStore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHStore.class);
    @Rule
    public TestName name = new TestName();
    HRegion region;
    HStore store;
    byte[] table = Bytes.toBytes((String)"table");
    byte[] family = Bytes.toBytes((String)"family");
    byte[] row = Bytes.toBytes((String)"row");
    byte[] row2 = Bytes.toBytes((String)"row2");
    byte[] qf1 = Bytes.toBytes((String)"qf1");
    byte[] qf2 = Bytes.toBytes((String)"qf2");
    byte[] qf3 = Bytes.toBytes((String)"qf3");
    byte[] qf4 = Bytes.toBytes((String)"qf4");
    byte[] qf5 = Bytes.toBytes((String)"qf5");
    byte[] qf6 = Bytes.toBytes((String)"qf6");
    NavigableSet<byte[]> qualifiers = new ConcurrentSkipListSet<byte[]>(Bytes.BYTES_COMPARATOR);
    List<Cell> expected = new ArrayList<Cell>();
    List<Cell> result = new ArrayList<Cell>();
    long id = EnvironmentEdgeManager.currentTime();
    Get get = new Get(this.row);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String DIR = TEST_UTIL.getDataTestDir("TestStore").toString();
    private static final int BLOCKSIZE_SMALL = 8192;

    @Before
    public void setUp() throws IOException {
        this.qualifiers.clear();
        this.qualifiers.add(this.qf1);
        this.qualifiers.add(this.qf3);
        this.qualifiers.add(this.qf5);
        for (byte[] next : this.qualifiers) {
            this.expected.add((Cell)new KeyValue(this.row, this.family, next, 1L, (byte[])null));
            this.get.addColumn(this.family, next);
        }
    }

    private void init(String methodName) throws IOException {
        this.init(methodName, TEST_UTIL.getConfiguration());
    }

    private HStore init(String methodName, Configuration conf) throws IOException {
        return this.init(methodName, conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMaxVersions(4).build());
    }

    private HStore init(String methodName, Configuration conf, ColumnFamilyDescriptor hcd) throws IOException {
        return this.init(methodName, conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)), hcd);
    }

    private HStore init(String methodName, Configuration conf, TableDescriptorBuilder builder, ColumnFamilyDescriptor hcd) throws IOException {
        return this.init(methodName, conf, builder, hcd, null);
    }

    private HStore init(String methodName, Configuration conf, TableDescriptorBuilder builder, ColumnFamilyDescriptor hcd, MyStoreHook hook) throws IOException {
        return this.init(methodName, conf, builder, hcd, hook, false);
    }

    private void initHRegion(String methodName, Configuration conf, TableDescriptorBuilder builder, ColumnFamilyDescriptor hcd, MyStoreHook hook, boolean switchToPread) throws IOException {
        TableDescriptor htd = builder.setColumnFamily(hcd).build();
        Path basedir = new Path(DIR + methodName);
        Path tableDir = CommonFSUtils.getTableDir((Path)basedir, (TableName)htd.getTableName());
        Path logdir = new Path(basedir, AbstractFSWALProvider.getWALDirectoryName((String)methodName));
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(logdir, true);
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0x200000L, (float)1.0f, (float)0.0f, null, (float)0.1f);
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        Configuration walConf = new Configuration(conf);
        CommonFSUtils.setRootDir((Configuration)walConf, (Path)basedir);
        WALFactory wals = new WALFactory(walConf, methodName);
        this.region = new HRegion(new HRegionFileSystem(conf, fs, tableDir, info), wals.getWAL(info), conf, htd, null);
        this.region.regionServicesForStores = (RegionServicesForStores)Mockito.spy((Object)this.region.regionServicesForStores);
        ThreadPoolExecutor pool = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        Mockito.when((Object)this.region.regionServicesForStores.getInMemoryCompactionPool()).thenReturn((Object)pool);
    }

    private HStore init(String methodName, Configuration conf, TableDescriptorBuilder builder, ColumnFamilyDescriptor hcd, MyStoreHook hook, boolean switchToPread) throws IOException {
        this.initHRegion(methodName, conf, builder, hcd, hook, switchToPread);
        this.store = hook == null ? new HStore(this.region, hcd, conf, false) : new MyStore(this.region, hcd, conf, hook, switchToPread);
        this.region.stores.put(this.store.getColumnFamilyDescriptor().getName(), this.store);
        return this.store;
    }

    @Test
    public void testFlushSizeSizing() throws Exception {
        LOG.info("Setting up a faulty file system that cannot write in " + this.name.getMethodName());
        final Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        conf.setInt("hbase.hstore.flush.retries.number", 1);
        User user = User.createUserForTesting((Configuration)conf, (String)this.name.getMethodName(), (String[])new String[]{"foo"});
        conf.setClass("fs.file.impl", FaultyFileSystem.class, FileSystem.class);
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Assert.assertEquals(FaultyFileSystem.class, fs.getClass());
                FaultyFileSystem ffs = (FaultyFileSystem)fs;
                TestHStore.this.init(TestHStore.this.name.getMethodName(), conf);
                MemStoreSize mss = TestHStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)0L, (long)mss.getDataSize());
                LOG.info("Adding some data");
                NonThreadSafeMemStoreSizing kvSize = new NonThreadSafeMemStoreSizing();
                TestHStore.this.store.add((Cell)new KeyValue(TestHStore.this.row, TestHStore.this.family, TestHStore.this.qf1, 1L, (byte[])null), (MemStoreSizing)kvSize);
                kvSize.incMemStoreSize(0L, MutableSegment.DEEP_OVERHEAD, 0L, 0);
                mss = TestHStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((Object)kvSize.getMemStoreSize(), (Object)mss);
                try {
                    LOG.info("Flushing");
                    TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                    Assert.fail((String)"Didn't bubble up IOE!");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("Fault injected"));
                }
                kvSize.incMemStoreSize(0L, CSLMImmutableSegment.DEEP_OVERHEAD_CSLM - MutableSegment.DEEP_OVERHEAD, 0L, 0);
                mss = TestHStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((Object)kvSize.getMemStoreSize(), (Object)mss);
                NonThreadSafeMemStoreSizing kvSize2 = new NonThreadSafeMemStoreSizing();
                TestHStore.this.store.add((Cell)new KeyValue(TestHStore.this.row, TestHStore.this.family, TestHStore.this.qf2, 2L, (byte[])null), (MemStoreSizing)kvSize2);
                kvSize2.incMemStoreSize(0L, MutableSegment.DEEP_OVERHEAD, 0L, 0);
                Assert.assertEquals((Object)kvSize.getMemStoreSize(), (Object)mss);
                ffs.fault.set(false);
                TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                mss = TestHStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((Object)kvSize2.getMemStoreSize(), (Object)mss);
                TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                mss = TestHStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)0L, (long)mss.getDataSize());
                Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)mss.getHeapSize());
                return null;
            }
        });
    }

    @Test
    public void testStoreBloomFilterMetricsWithBloomRowCol() throws IOException {
        int numStoreFiles = 5;
        this.writeAndRead(BloomType.ROWCOL, numStoreFiles);
        Assert.assertEquals((long)0L, (long)this.store.getBloomFilterEligibleRequestsCount());
        Assert.assertTrue((this.store.getBloomFilterRequestsCount() >= (long)numStoreFiles ? 1 : 0) != 0);
        Assert.assertTrue((this.store.getBloomFilterNegativeResultsCount() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testStoreBloomFilterMetricsWithBloomRow() throws IOException {
        int numStoreFiles = 5;
        this.writeAndRead(BloomType.ROWCOL, numStoreFiles);
        Assert.assertEquals((long)0L, (long)this.store.getBloomFilterEligibleRequestsCount());
        Assert.assertTrue((this.store.getBloomFilterRequestsCount() >= (long)numStoreFiles ? 1 : 0) != 0);
        Assert.assertTrue((this.store.getBloomFilterNegativeResultsCount() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testStoreBloomFilterMetricsWithBloomRowPrefix() throws IOException {
        int numStoreFiles = 5;
        this.writeAndRead(BloomType.ROWPREFIX_FIXED_LENGTH, numStoreFiles);
        Assert.assertEquals((long)0L, (long)this.store.getBloomFilterEligibleRequestsCount());
        Assert.assertTrue((this.store.getBloomFilterRequestsCount() >= (long)numStoreFiles ? 1 : 0) != 0);
    }

    @Test
    public void testStoreBloomFilterMetricsWithBloomNone() throws IOException {
        int numStoreFiles = 5;
        this.writeAndRead(BloomType.NONE, numStoreFiles);
        Assert.assertEquals((long)0L, (long)this.store.getBloomFilterRequestsCount());
        Assert.assertEquals((long)0L, (long)this.store.getBloomFilterNegativeResultsCount());
        Assert.assertTrue((this.store.getBloomFilterEligibleRequestsCount() >= (long)numStoreFiles ? 1 : 0) != 0);
    }

    private void writeAndRead(BloomType bloomType, int numStoreFiles) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        ColumnFamilyDescriptor hcd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setCompressionType(Compression.Algorithm.GZ).setBloomFilterType(bloomType).setConfiguration("RowPrefixBloomFilter.prefix_length", "3").build();
        this.init(this.name.getMethodName(), conf, hcd);
        for (int i = 1; i <= numStoreFiles; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            LOG.info("Adding some data for the store file #" + i);
            long timeStamp = EnvironmentEdgeManager.currentTime();
            this.store.add((Cell)new KeyValue(row, this.family, this.qf1, timeStamp, (byte[])null), null);
            this.store.add((Cell)new KeyValue(row, this.family, this.qf2, timeStamp, (byte[])null), null);
            this.store.add((Cell)new KeyValue(row, this.family, this.qf3, timeStamp, (byte[])null), null);
            this.flush(i);
        }
        Assert.assertEquals((long)numStoreFiles, (long)this.store.getStorefiles().size());
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(this.qf1);
        for (int i = 1; i <= numStoreFiles; ++i) {
            KeyValueScanner scanner = this.store.getScanner(new Scan(new Get(Bytes.toBytes((String)("row" + i)))), columns, 0L);
            scanner.peek();
        }
    }

    @Test
    public void testCreateWriter() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        ColumnFamilyDescriptor hcd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setCompressionType(Compression.Algorithm.GZ).setDataBlockEncoding(DataBlockEncoding.DIFF).build();
        this.init(this.name.getMethodName(), conf, hcd);
        StoreFileWriter writer = this.store.getStoreEngine().createWriter(CreateStoreFileWriterParams.create().maxKeyCount(4L).compression(hcd.getCompressionType()).isCompaction(false).includeMVCCReadpoint(true).includesTag(false).shouldDropBehind(false));
        Path path = writer.getPath();
        writer.append((Cell)new KeyValue(this.row, this.family, this.qf1, Bytes.toBytes((int)1)));
        writer.append((Cell)new KeyValue(this.row, this.family, this.qf2, Bytes.toBytes((int)2)));
        writer.append((Cell)new KeyValue(this.row2, this.family, this.qf1, Bytes.toBytes((int)3)));
        writer.append((Cell)new KeyValue(this.row2, this.family, this.qf2, Bytes.toBytes((int)4)));
        writer.close();
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);
        Assert.assertEquals((Object)hcd.getCompressionType(), (Object)reader.getTrailer().getCompressionCodec());
        Assert.assertEquals((Object)hcd.getDataBlockEncoding(), (Object)reader.getDataBlockEncoding());
        reader.close();
    }

    @Test
    public void testDeleteExpiredStoreFiles() throws Exception {
        this.testDeleteExpiredStoreFiles(0);
        this.testDeleteExpiredStoreFiles(1);
    }

    public void testDeleteExpiredStoreFiles(int minVersions) throws Exception {
        long ts;
        int i;
        int storeFileNum = 4;
        int ttl = 4;
        IncrementingEnvironmentEdge edge = new IncrementingEnvironmentEdge();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)edge);
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.store.delete.expired.storefile", true);
        conf.setInt(CompactionConfiguration.HBASE_HSTORE_COMPACTION_MIN_KEY, 5);
        this.init(this.name.getMethodName() + "-" + minVersions, conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMinVersions(minVersions).setTimeToLive(ttl).build());
        long storeTtl = this.store.getScanInfo().getTtl();
        long sleepTime = storeTtl / (long)storeFileNum;
        for (i = 1; i <= storeFileNum; ++i) {
            LOG.info("Adding some data for the store file #" + i);
            long timeStamp = EnvironmentEdgeManager.currentTime();
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, timeStamp, (byte[])null), null);
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, timeStamp, (byte[])null), null);
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, timeStamp, (byte[])null), null);
            this.flush(i);
            edge.incrementTime(sleepTime);
        }
        Assert.assertEquals((long)storeFileNum, (long)this.store.getStorefiles().size());
        for (i = 1; i <= storeFileNum - 1; ++i) {
            Assert.assertFalse((boolean)this.store.requestCompaction().isPresent());
            Collection sfs = this.store.getStorefiles();
            if (minVersions == 0) {
                Assert.assertEquals((long)(storeFileNum - i), (long)sfs.size());
                for (HStoreFile sf : sfs) {
                    Assert.assertTrue((sf.getReader().getMaxTimestamp() >= edge.currentTime() - storeTtl ? 1 : 0) != 0);
                }
            } else {
                Assert.assertEquals((long)storeFileNum, (long)sfs.size());
            }
            edge.incrementTime(sleepTime);
        }
        Assert.assertFalse((boolean)this.store.requestCompaction().isPresent());
        Collection sfs = this.store.getStorefiles();
        if (minVersions == 0) {
            Assert.assertEquals((long)1L, (long)sfs.size());
        }
        Assert.assertTrue(((ts = ((HStoreFile)sfs.iterator().next()).getReader().getMaxTimestamp()) < edge.currentTime() - storeTtl ? 1 : 0) != 0);
        for (HStoreFile sf : sfs) {
            sf.closeStoreFile(true);
        }
    }

    @Test
    public void testLowestModificationTime() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.init(this.name.getMethodName(), conf);
        int storeFileNum = 4;
        for (int i = 1; i <= storeFileNum; ++i) {
            LOG.info("Adding some data for the store file #" + i);
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, (long)i, (byte[])null), null);
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, (long)i, (byte[])null), null);
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, (long)i, (byte[])null), null);
            this.flush(i);
        }
        long lowestTimeStampFromManager = StoreUtils.getLowestTimestamp((Collection)this.store.getStorefiles());
        long lowestTimeStampFromFS = TestHStore.getLowestTimeStampFromFS(fs, this.store.getStorefiles());
        Assert.assertEquals((long)lowestTimeStampFromManager, (long)lowestTimeStampFromFS);
        this.store.compact((CompactionContext)this.store.requestCompaction().get(), (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        lowestTimeStampFromManager = StoreUtils.getLowestTimestamp((Collection)this.store.getStorefiles());
        lowestTimeStampFromFS = TestHStore.getLowestTimeStampFromFS(fs, this.store.getStorefiles());
        Assert.assertEquals((long)lowestTimeStampFromManager, (long)lowestTimeStampFromFS);
    }

    private static long getLowestTimeStampFromFS(FileSystem fs, Collection<HStoreFile> candidates) throws IOException {
        long minTs = Long.MAX_VALUE;
        if (candidates.isEmpty()) {
            return minTs;
        }
        Path[] p = new Path[candidates.size()];
        int i = 0;
        for (HStoreFile sf : candidates) {
            p[i] = sf.getPath();
            ++i;
        }
        FileStatus[] stats = fs.listStatus(p);
        if (stats == null || stats.length == 0) {
            return minTs;
        }
        for (FileStatus s : stats) {
            minTs = Math.min(minTs, s.getModificationTime());
        }
        return minTs;
    }

    @Test
    public void testEmptyStoreFile() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null), null);
        this.flush(1);
        HStoreFile f = (HStoreFile)this.store.getStorefiles().iterator().next();
        Path storedir = f.getPath().getParent();
        long seqid = f.getMaxSequenceId();
        Configuration c = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)c);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter w = new StoreFileWriter.Builder(c, new CacheConfig(c), fs).withOutputDir(storedir).withFileContext(meta).build();
        w.appendMetadata(seqid + 1L, false);
        w.close();
        this.store.close();
        this.store = new HStore(this.store.getHRegion(), this.store.getColumnFamilyDescriptor(), c, false);
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Assert.assertEquals((long)1L, (long)this.result.size());
    }

    @Test
    public void testGet_FromMemStoreOnly() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null), null);
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        this.assertCheck();
    }

    @Test
    public void testTimeRangeIfSomeCellsAreDroppedInFlush() throws IOException {
        this.testTimeRangeIfSomeCellsAreDroppedInFlush(1);
        this.testTimeRangeIfSomeCellsAreDroppedInFlush(3);
        this.testTimeRangeIfSomeCellsAreDroppedInFlush(5);
    }

    private void testTimeRangeIfSomeCellsAreDroppedInFlush(int maxVersion) throws IOException {
        long currentTs;
        this.init(this.name.getMethodName(), TEST_UTIL.getConfiguration(), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMaxVersions(maxVersion).build());
        long minTs = currentTs = 100L;
        for (int i = 0; i != maxVersion + 1; ++i) {
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, ++currentTs, (byte[])null), null);
            if (i != 1) continue;
            minTs = currentTs;
        }
        TestHStore.flushStore(this.store, this.id++);
        Collection files = this.store.getStorefiles();
        Assert.assertEquals((long)1L, (long)files.size());
        HStoreFile f = (HStoreFile)files.iterator().next();
        f.initReader();
        StoreFileReader reader = f.getReader();
        Assert.assertEquals((long)minTs, (long)reader.timeRange.getMin());
        Assert.assertEquals((long)currentTs, (long)reader.timeRange.getMax());
    }

    @Test
    public void testGet_FromFilesOnly() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null), null);
        this.flush(1);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null), null);
        this.flush(2);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null), null);
        this.flush(3);
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Collections.sort(this.result, CellComparatorImpl.COMPARATOR);
        this.assertCheck();
    }

    @Test
    public void testGet_FromMemStoreAndFiles() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null), null);
        this.flush(1);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null), null);
        this.flush(2);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null), null);
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Collections.sort(this.result, CellComparatorImpl.COMPARATOR);
        this.assertCheck();
    }

    private void flush(int storeFilessize) throws IOException {
        TestHStore.flushStore(this.store, this.id++);
        Assert.assertEquals((long)storeFilessize, (long)this.store.getStorefiles().size());
        Assert.assertEquals((long)0L, (long)((AbstractMemStore)this.store.memstore).getActive().getCellsCount());
    }

    private void assertCheck() {
        Assert.assertEquals((long)this.expected.size(), (long)this.result.size());
        for (int i = 0; i < this.expected.size(); ++i) {
            Assert.assertEquals((Object)this.expected.get(i), (Object)this.result.get(i));
        }
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.store = null;
        }
        if (this.region != null) {
            this.region.close();
            this.region = null;
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testHandleErrorsInFlush() throws Exception {
        LOG.info("Setting up a faulty file system that cannot write");
        final Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        User user = User.createUserForTesting((Configuration)conf, (String)"testhandleerrorsinflush", (String[])new String[]{"foo"});
        conf.setClass("fs.file.impl", FaultyFileSystem.class, FileSystem.class);
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Assert.assertEquals(FaultyFileSystem.class, fs.getClass());
                TestHStore.this.init(TestHStore.this.name.getMethodName(), conf);
                LOG.info("Adding some data");
                TestHStore.this.store.add((Cell)new KeyValue(TestHStore.this.row, TestHStore.this.family, TestHStore.this.qf1, 1L, (byte[])null), null);
                TestHStore.this.store.add((Cell)new KeyValue(TestHStore.this.row, TestHStore.this.family, TestHStore.this.qf2, 1L, (byte[])null), null);
                TestHStore.this.store.add((Cell)new KeyValue(TestHStore.this.row, TestHStore.this.family, TestHStore.this.qf3, 1L, (byte[])null), null);
                LOG.info("Before flush, we should have no files");
                StoreFileTracker sft = StoreFileTrackerFactory.create((Configuration)conf, (boolean)false, (StoreContext)TestHStore.this.store.getStoreContext());
                List files = sft.load();
                Assert.assertEquals((long)0L, (long)(files != null ? (long)files.size() : 0L));
                try {
                    LOG.info("Flushing");
                    TestHStore.this.flush(1);
                    Assert.fail((String)"Didn't bubble up IOE!");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("Fault injected"));
                }
                LOG.info("After failed flush, we should still have no files!");
                files = sft.load();
                Assert.assertEquals((long)0L, (long)(files != null ? (long)files.size() : 0L));
                TestHStore.this.store.getHRegion().getWAL().close();
                return null;
            }
        });
        FileSystem.closeAllForUGI((UserGroupInformation)user.getUGI());
    }

    private static StoreFlushContext flushStore(HStore store, long id) throws IOException {
        StoreFlushContext storeFlushCtx = store.createFlushContext(id, FlushLifeCycleTracker.DUMMY);
        storeFlushCtx.prepare();
        storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
        storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
        return storeFlushCtx;
    }

    private List<Cell> getKeyValueSet(long[] timestamps, int numRows, byte[] qualifier, byte[] family) {
        ArrayList<Cell> kvList = new ArrayList<Cell>();
        for (int i = 1; i <= numRows; ++i) {
            byte[] b = Bytes.toBytes((int)i);
            for (long timestamp : timestamps) {
                kvList.add((Cell)new KeyValue(b, family, qualifier, timestamp, b));
            }
        }
        return kvList;
    }

    @Test
    public void testMultipleTimestamps() throws IOException {
        int numRows = 1;
        long[] timestamps1 = new long[]{1L, 5L, 10L, 20L};
        long[] timestamps2 = new long[]{30L, 80L};
        this.init(this.name.getMethodName());
        List<Cell> kvList1 = this.getKeyValueSet(timestamps1, numRows, this.qf1, this.family);
        for (Cell cell : kvList1) {
            this.store.add(cell, null);
        }
        TestHStore.flushStore(this.store, this.id++);
        List<Cell> kvList2 = this.getKeyValueSet(timestamps2, numRows, this.qf1, this.family);
        for (Cell kv : kvList2) {
            this.store.add(kv, null);
        }
        Get get = new Get(Bytes.toBytes((int)1));
        get.addColumn(this.family, this.qf1);
        get.setTimeRange(0L, 15L);
        List<Cell> list = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(40L, 90L);
        List<Cell> list2 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(10L, 45L);
        List<Cell> list3 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list3.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(80L, 145L);
        List<Cell> list4 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list4.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(1L, 2L);
        List<Cell> list5 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list5.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(90L, 200L);
        List<Cell> list6 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list6.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSplitWithEmptyColFam() throws IOException {
        this.init(this.name.getMethodName());
        Assert.assertFalse((boolean)this.store.getSplitPoint().isPresent());
    }

    @Test
    public void testStoreUsesConfigurationFromHcdAndHtd() throws Exception {
        String CONFIG_KEY = "hbase.regionserver.thread.compaction.throttle";
        long anyValue = 10L;
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.regionserver.thread.compaction.throttle", anyValue);
        this.init(this.name.getMethodName() + "-xml", conf);
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
        this.init(this.name.getMethodName() + "-htd", conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)).setValue("hbase.regionserver.thread.compaction.throttle", Long.toString(--anyValue)), ColumnFamilyDescriptorBuilder.of((byte[])this.family));
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
        this.init(this.name.getMethodName() + "-hcd", conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)).setValue("hbase.regionserver.thread.compaction.throttle", Long.toString(--anyValue)), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setValue("hbase.regionserver.thread.compaction.throttle", Long.toString(anyValue)).build());
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
    }

    @Test
    public void testStoreUsesSearchEngineOverride() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set(StoreEngine.STORE_ENGINE_CLASS_KEY, DummyStoreEngine.class.getName());
        this.init(this.name.getMethodName(), conf);
        Assert.assertEquals((Object)DummyStoreEngine.lastCreatedCompactor, (Object)this.store.storeEngine.getCompactor());
    }

    private void addStoreFile() throws IOException {
        HStoreFile f = (HStoreFile)this.store.getStorefiles().iterator().next();
        Path storedir = f.getPath().getParent();
        long seqid = this.store.getMaxSequenceId().orElse(0L);
        Configuration c = TEST_UTIL.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)c);
        HFileContext fileContext = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter w = new StoreFileWriter.Builder(c, new CacheConfig(c), fs).withOutputDir(storedir).withFileContext(fileContext).build();
        w.appendMetadata(seqid + 1L, false);
        w.close();
        LOG.info("Added store file:" + w.getPath());
    }

    private void archiveStoreFile(int index) throws IOException {
        Collection files = this.store.getStorefiles();
        HStoreFile sf = null;
        Iterator it = files.iterator();
        for (int i = 0; i <= index; ++i) {
            sf = (HStoreFile)it.next();
        }
        this.store.getRegionFileSystem().removeStoreFiles(this.store.getColumnFamilyName(), (Collection)Lists.newArrayList((Object[])new HStoreFile[]{sf}));
    }

    private void closeCompactedFile(int index) throws IOException {
        Collection files = this.store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        if (files.size() > 0) {
            HStoreFile sf = null;
            Iterator it = files.iterator();
            for (int i = 0; i <= index; ++i) {
                sf = (HStoreFile)it.next();
            }
            sf.closeStoreFile(true);
            this.store.getStoreEngine().getStoreFileManager().removeCompactedFiles(Collections.singletonList(sf));
        }
    }

    @Test
    public void testRefreshStoreFiles() throws Exception {
        this.init(this.name.getMethodName());
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.flush(1);
        Assert.assertEquals((long)1L, (long)this.store.getStorefilesCount());
        this.addStoreFile();
        Assert.assertEquals((long)1L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        this.addStoreFile();
        this.addStoreFile();
        this.addStoreFile();
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)5L, (long)this.store.getStorefilesCount());
        this.closeCompactedFile(0);
        this.archiveStoreFile(0);
        Assert.assertEquals((long)5L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)4L, (long)this.store.getStorefilesCount());
        this.archiveStoreFile(0);
        this.archiveStoreFile(1);
        this.archiveStoreFile(2);
        Assert.assertEquals((long)4L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)1L, (long)this.store.getStorefilesCount());
        this.archiveStoreFile(0);
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
    }

    @Test
    public void testRefreshStoreFilesNotChanged() throws IOException {
        this.init(this.name.getMethodName());
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.flush(1);
        this.addStoreFile();
        StoreEngine spiedStoreEngine = (StoreEngine)Mockito.spy((Object)this.store.getStoreEngine());
        spiedStoreEngine.refreshStoreFiles();
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        ((StoreEngine)Mockito.verify((Object)spiedStoreEngine, (VerificationMode)Mockito.times((int)1))).replaceStoreFiles((Collection)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any(), (StoreEngine.IOExceptionRunnable)ArgumentMatchers.any(), (Runnable)ArgumentMatchers.any());
        spiedStoreEngine.refreshStoreFiles();
        ((StoreEngine)Mockito.verify((Object)spiedStoreEngine, (VerificationMode)Mockito.times((int)1))).replaceStoreFiles((Collection)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any(), (StoreEngine.IOExceptionRunnable)ArgumentMatchers.any(), (Runnable)ArgumentMatchers.any());
    }

    @Test
    public void testScanWithCompactionAfterFlush() throws Exception {
        TEST_UTIL.getConfiguration().set(DefaultStoreEngine.DEFAULT_COMPACTION_POLICY_CLASS_KEY, EverythingPolicy.class.getName());
        this.init(this.name.getMethodName());
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
        KeyValue kv = new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null);
        this.store.add((Cell)kv, null);
        this.flush(1);
        kv = new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null);
        this.store.add((Cell)kv, null);
        this.flush(2);
        kv = new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null);
        this.store.add((Cell)kv, null);
        this.flush(3);
        ExecutorService service = Executors.newFixedThreadPool(2);
        Scan scan = new Scan(new Get(this.row));
        Future<KeyValueScanner> scanFuture = service.submit(() -> {
            try {
                LOG.info(">>>> creating scanner");
                return this.store.createScanner(scan, new ScanInfo(HBaseConfiguration.create(), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMaxVersions(4).build(), Long.MAX_VALUE, 0L, CellComparator.getInstance()), (NavigableSet)scan.getFamilyMap().get(this.store.getColumnFamilyDescriptor().getName()), 0L);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        });
        Future<?> compactFuture = service.submit(() -> {
            try {
                LOG.info(">>>>>> starting compaction");
                Optional opCompaction = this.store.requestCompaction();
                Assert.assertTrue((boolean)opCompaction.isPresent());
                this.store.compact((CompactionContext)opCompaction.get(), (ThroughputController)new NoLimitThroughputController(), User.getCurrent());
                LOG.info(">>>>>> Compaction is finished");
                this.store.closeAndArchiveCompactedFiles();
                LOG.info(">>>>>> Compacted files deleted");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        KeyValueScanner kvs = scanFuture.get();
        compactFuture.get();
        ((StoreScanner)kvs).currentScanners.forEach(s -> {
            if (s instanceof StoreFileScanner) {
                Assert.assertEquals((long)1L, (long)((StoreFileScanner)s).getReader().getRefCount());
            }
        });
        kvs.seek((Cell)kv);
        service.shutdownNow();
    }

    private long countMemStoreScanner(StoreScanner scanner) {
        if (scanner.currentScanners == null) {
            return 0L;
        }
        return scanner.currentScanners.stream().filter(s -> !s.isFileScanner()).count();
    }

    @Test
    public void testNumberOfMemStoreScannersAfterFlush() throws IOException {
        long seqId = 100L;
        long timestamp = EnvironmentEdgeManager.currentTime();
        Cell cell0 = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(this.row).setFamily(this.family).setQualifier(this.qf1).setTimestamp(timestamp).setType(Cell.Type.Put).setValue(this.qf1).build();
        PrivateCellUtil.setSequenceId((Cell)cell0, (long)seqId);
        this.testNumberOfMemStoreScannersAfterFlush(Arrays.asList(cell0), Collections.emptyList());
        Cell cell1 = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(this.row).setFamily(this.family).setQualifier(this.qf2).setTimestamp(timestamp).setType(Cell.Type.Put).setValue(this.qf1).build();
        PrivateCellUtil.setSequenceId((Cell)cell1, (long)seqId);
        this.testNumberOfMemStoreScannersAfterFlush(Arrays.asList(cell0), Arrays.asList(cell1));
        seqId = 101L;
        timestamp = EnvironmentEdgeManager.currentTime();
        Cell cell2 = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(this.row2).setFamily(this.family).setQualifier(this.qf2).setTimestamp(timestamp).setType(Cell.Type.Put).setValue(this.qf1).build();
        PrivateCellUtil.setSequenceId((Cell)cell2, (long)seqId);
        this.testNumberOfMemStoreScannersAfterFlush(Arrays.asList(cell0), Arrays.asList(cell1, cell2));
    }

    private void testNumberOfMemStoreScannersAfterFlush(List<Cell> inputCellsBeforeSnapshot, List<Cell> inputCellsAfterSnapshot) throws IOException {
        this.init(this.name.getMethodName() + "-" + inputCellsBeforeSnapshot.size());
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        long seqId = Long.MIN_VALUE;
        for (Cell c2 : inputCellsBeforeSnapshot) {
            quals.add(CellUtil.cloneQualifier((Cell)c2));
            seqId = Math.max(seqId, c2.getSequenceId());
        }
        for (Cell c2 : inputCellsAfterSnapshot) {
            quals.add(CellUtil.cloneQualifier((Cell)c2));
            seqId = Math.max(seqId, c2.getSequenceId());
        }
        inputCellsBeforeSnapshot.forEach(c -> this.store.add(c, null));
        StoreFlushContext storeFlushCtx = this.store.createFlushContext(this.id++, FlushLifeCycleTracker.DUMMY);
        storeFlushCtx.prepare();
        inputCellsAfterSnapshot.forEach(c -> this.store.add(c, null));
        int numberOfMemScannersBeforeFlush = inputCellsAfterSnapshot.isEmpty() ? 1 : 2;
        try (StoreScanner s = (StoreScanner)this.store.getScanner(new Scan(), quals, seqId);){
            boolean more;
            Assert.assertEquals((long)numberOfMemScannersBeforeFlush, (long)this.countMemStoreScanner(s));
            storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
            storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
            int numberOfMemScannersAfterFlush = inputCellsAfterSnapshot.isEmpty() ? 0 : 1;
            int cellCount = 0;
            do {
                ArrayList cells = new ArrayList();
                more = s.next(cells);
                cellCount += cells.size();
                Assert.assertEquals((long)(more ? (long)numberOfMemScannersAfterFlush : 0L), (long)this.countMemStoreScanner(s));
            } while (more);
            Assert.assertEquals((String)("The number of cells added before snapshot is " + inputCellsBeforeSnapshot.size() + ", The number of cells added after snapshot is " + inputCellsAfterSnapshot.size()), (long)(inputCellsBeforeSnapshot.size() + inputCellsAfterSnapshot.size()), (long)cellCount);
            Assert.assertEquals((long)0L, (long)this.countMemStoreScanner(s));
        }
    }

    private Cell createCell(byte[] qualifier, long ts, long sequenceId, byte[] value) throws IOException {
        return this.createCell(this.row, qualifier, ts, sequenceId, value);
    }

    private Cell createCell(byte[] row, byte[] qualifier, long ts, long sequenceId, byte[] value) throws IOException {
        Cell c = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(row).setFamily(this.family).setQualifier(qualifier).setTimestamp(ts).setType(Cell.Type.Put).setValue(value).build();
        PrivateCellUtil.setSequenceId((Cell)c, (long)sequenceId);
        return c;
    }

    private ExtendedCell createDeleteCell(byte[] row, byte[] qualifier, long ts, long sequenceId) {
        return ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(row).setFamily(this.family).setQualifier(qualifier).setTimestamp(ts).setType(Cell.Type.DeleteColumn).setSequenceId(sequenceId).build();
    }

    @Test
    public void testFlushBeforeCompletingScanWoFilter() throws IOException, InterruptedException {
        final AtomicBoolean timeToGoNextRow = new AtomicBoolean(false);
        int expectedSize = 3;
        this.testFlushBeforeCompletingScan(new MyListHook(){

            @Override
            public void hook(int currentSize) {
                if (currentSize == 2) {
                    try {
                        TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                        timeToGoNextRow.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, (Filter)new FilterBase(){

            public Filter.ReturnCode filterCell(Cell c) throws IOException {
                return Filter.ReturnCode.INCLUDE;
            }
        }, 3);
    }

    @Test
    public void testFlushBeforeCompletingScanWithFilter() throws IOException, InterruptedException {
        final AtomicBoolean timeToGoNextRow = new AtomicBoolean(false);
        int expectedSize = 2;
        this.testFlushBeforeCompletingScan(new MyListHook(){

            @Override
            public void hook(int currentSize) {
                if (currentSize == 1) {
                    try {
                        TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                        timeToGoNextRow.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, (Filter)new FilterBase(){

            public Filter.ReturnCode filterCell(Cell c) throws IOException {
                if (timeToGoNextRow.get()) {
                    timeToGoNextRow.set(false);
                    return Filter.ReturnCode.NEXT_ROW;
                }
                return Filter.ReturnCode.INCLUDE;
            }
        }, 2);
    }

    @Test
    public void testFlushBeforeCompletingScanWithFilterHint() throws IOException, InterruptedException {
        final AtomicBoolean timeToGetHint = new AtomicBoolean(false);
        int expectedSize = 2;
        this.testFlushBeforeCompletingScan(new MyListHook(){

            @Override
            public void hook(int currentSize) {
                if (currentSize == 1) {
                    try {
                        TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                        timeToGetHint.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, (Filter)new FilterBase(){

            public Filter.ReturnCode filterCell(Cell c) throws IOException {
                if (timeToGetHint.get()) {
                    timeToGetHint.set(false);
                    return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
                }
                return Filter.ReturnCode.INCLUDE;
            }

            public Cell getNextCellHint(Cell currentCell) throws IOException {
                return currentCell;
            }
        }, 2);
    }

    private void testFlushBeforeCompletingScan(MyListHook hook, Filter filter, int expectedSize) throws IOException, InterruptedException {
        Configuration conf = HBaseConfiguration.create();
        byte[] r0 = Bytes.toBytes((String)"row0");
        byte[] r1 = Bytes.toBytes((String)"row1");
        byte[] r2 = Bytes.toBytes((String)"row2");
        byte[] value0 = Bytes.toBytes((String)"value0");
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] value2 = Bytes.toBytes((String)"value2");
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = EnvironmentEdgeManager.currentTime();
        final long seqId = 100L;
        this.init(this.name.getMethodName(), conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMaxVersions(1).build(), new MyStoreHook(){

            @Override
            public long getSmallestReadPoint(HStore store) {
                return seqId + 3L;
            }
        });
        this.store.add(this.createCell(r0, this.qf1, ts, seqId, value0), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r0, this.qf2, ts, seqId, value0), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r0, this.qf3, ts, seqId, value0), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf1, ts + 1L, seqId + 1L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf2, ts + 1L, seqId + 1L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf3, ts + 1L, seqId + 1L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r2, this.qf1, ts + 2L, seqId + 2L, value2), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r2, this.qf2, ts + 2L, seqId + 2L, value2), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r2, this.qf3, ts + 2L, seqId + 2L, value2), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf1, ts + 3L, seqId + 3L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf2, ts + 3L, seqId + 3L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf3, ts + 3L, seqId + 3L, value1), (MemStoreSizing)memStoreSizing);
        MyList myList = new MyList(hook);
        Scan scan = new Scan().withStartRow(r1).setFilter(filter);
        try (InternalScanner scanner = (InternalScanner)this.store.getScanner(scan, null, seqId + 3L);){
            scanner.next(myList);
            Assert.assertEquals((long)expectedSize, (long)myList.size());
            for (Cell c : myList) {
                byte[] actualValue = CellUtil.cloneValue((Cell)c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary((byte[])value1) + ", actual:" + Bytes.toStringBinary((byte[])actualValue)), (boolean)Bytes.equals((byte[])actualValue, (byte[])value1));
            }
            ArrayList normalList = new ArrayList(3);
            scanner.next(normalList);
            Assert.assertEquals((long)3L, (long)normalList.size());
            for (Cell c : normalList) {
                byte[] actualValue = CellUtil.cloneValue((Cell)c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary((byte[])value2) + ", actual:" + Bytes.toStringBinary((byte[])actualValue)), (boolean)Bytes.equals((byte[])actualValue, (byte[])value2));
            }
        }
    }

    @Test
    public void testFlushBeforeCompletingScanWithDeleteCell() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        byte[] r1 = Bytes.toBytes((String)"row1");
        byte[] r2 = Bytes.toBytes((String)"row2");
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] value2 = Bytes.toBytes((String)"value2");
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        this.init(this.name.getMethodName(), conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMaxVersions(1).build(), new MyStoreHook(){

            @Override
            long getSmallestReadPoint(HStore store) {
                return 103L;
            }
        });
        this.store.add(this.createCell(r1, this.qf1, ts + 1L, 101L, value2), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf2, ts + 1L, 101L, value2), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf3, ts + 1L, 101L, value2), (MemStoreSizing)memStoreSizing);
        this.store.add((Cell)this.createDeleteCell(r1, this.qf1, ts + 2L, 102L), (MemStoreSizing)memStoreSizing);
        this.store.add((Cell)this.createDeleteCell(r1, this.qf2, ts + 2L, 102L), (MemStoreSizing)memStoreSizing);
        this.store.add((Cell)this.createDeleteCell(r1, this.qf3, ts + 2L, 102L), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r2, this.qf1, ts + 3L, 103L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r2, this.qf2, ts + 3L, 103L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r2, this.qf3, ts + 3L, 103L, value1), (MemStoreSizing)memStoreSizing);
        Scan scan = new Scan().withStartRow(r1);
        try (StoreScanner scanner = new StoreScanner(this.store, this.store.getScanInfo(), scan, null, 103L){

            protected KeyValueHeap newKVHeap(List<? extends KeyValueScanner> scanners, CellComparator comparator) throws IOException {
                return new MyKeyValueHeap(scanners, comparator, recordBlockSizeCallCount -> {
                    if (recordBlockSizeCallCount == 6) {
                        try {
                            TestHStore.flushStore(this.store, TestHStore.this.id++);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        };){
            ArrayList cellResult = new ArrayList();
            scanner.next(cellResult);
            Assert.assertEquals((long)0L, (long)cellResult.size());
            cellResult.clear();
            scanner.next(cellResult);
            Assert.assertEquals((long)3L, (long)cellResult.size());
            for (Cell cell : cellResult) {
                Assert.assertArrayEquals((byte[])r2, (byte[])CellUtil.cloneRow((Cell)cell));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateScannerAndSnapshotConcurrently() throws IOException, InterruptedException {
        Configuration conf = HBaseConfiguration.create();
        conf.set(HStore.MEMSTORE_CLASS_NAME, MyCompactingMemStore.class.getName());
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build());
        byte[] value = Bytes.toBytes((String)"value");
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        this.store.add(this.createCell(this.qf1, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf2, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf3, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        quals.add(this.qf3);
        StoreFlushContext storeFlushCtx = this.store.createFlushContext(this.id++, FlushLifeCycleTracker.DUMMY);
        MyCompactingMemStore.START_TEST.set(true);
        Runnable flush = () -> storeFlushCtx.prepare();
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(flush);
        InternalScanner scanner = (InternalScanner)this.store.getScanner(new Scan(new Get(this.row)), quals, seqId + 1L);
        service.shutdown();
        service.awaitTermination(20L, TimeUnit.SECONDS);
        try {
            try {
                ArrayList results = new ArrayList();
                scanner.next(results);
                Assert.assertEquals((long)3L, (long)results.size());
                for (Cell c : results) {
                    byte[] actualValue = CellUtil.cloneValue((Cell)c);
                    Assert.assertTrue((String)("expected:" + Bytes.toStringBinary((byte[])value) + ", actual:" + Bytes.toStringBinary((byte[])actualValue)), (boolean)Bytes.equals((byte[])actualValue, (byte[])value));
                }
            }
            finally {
                scanner.close();
            }
        }
        finally {
            MyCompactingMemStore.START_TEST.set(false);
            storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
            storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
        }
    }

    @Test
    public void testScanWithDoubleFlush() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        MyStore myStore = this.initMyStore(this.name.getMethodName(), conf, new MyStoreHook(){

            @Override
            public void getScanners(MyStore store) throws IOException {
                long tmpId = TestHStore.this.id++;
                ExecutorService s = Executors.newSingleThreadExecutor();
                s.execute(() -> {
                    try {
                        TestHStore.flushStore(store, tmpId);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                });
                s.shutdown();
                try {
                    s.awaitTermination(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        byte[] oldValue = Bytes.toBytes((String)"oldValue");
        byte[] currentValue = Bytes.toBytes((String)"currentValue");
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        myStore.add(this.createCell(this.qf1, ts, seqId, oldValue), (MemStoreSizing)memStoreSizing);
        myStore.add(this.createCell(this.qf2, ts, seqId, oldValue), (MemStoreSizing)memStoreSizing);
        myStore.add(this.createCell(this.qf3, ts, seqId, oldValue), (MemStoreSizing)memStoreSizing);
        long snapshotId = this.id++;
        StoreFlushContext storeFlushCtx = this.store.createFlushContext(snapshotId, FlushLifeCycleTracker.DUMMY);
        storeFlushCtx.prepare();
        myStore.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, currentValue), (MemStoreSizing)memStoreSizing);
        myStore.add(this.createCell(this.qf2, ts + 1L, seqId + 1L, currentValue), (MemStoreSizing)memStoreSizing);
        myStore.add(this.createCell(this.qf3, ts + 1L, seqId + 1L, currentValue), (MemStoreSizing)memStoreSizing);
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        quals.add(this.qf3);
        try (InternalScanner scanner = (InternalScanner)myStore.getScanner(new Scan(new Get(this.row)), quals, seqId + 1L);){
            storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
            storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
            ArrayList results = new ArrayList();
            scanner.next(results);
            Assert.assertEquals((long)3L, (long)results.size());
            for (Cell c : results) {
                byte[] actualValue = CellUtil.cloneValue((Cell)c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary((byte[])currentValue) + ", actual:" + Bytes.toStringBinary((byte[])actualValue)), (boolean)Bytes.equals((byte[])actualValue, (byte[])currentValue));
            }
        }
    }

    @Test
    public void testStoreScannerUpdateReadersWhenFlushAndCompactConcurrently() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.regionserver.hlog.enabled", false);
        conf.set(DefaultStoreEngine.DEFAULT_COMPACTION_POLICY_CLASS_KEY, EverythingPolicy.class.getName());
        byte[] r0 = Bytes.toBytes((String)"row0");
        byte[] r1 = Bytes.toBytes((String)"row1");
        final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
        final AtomicBoolean shouldWaitRef = new AtomicBoolean(false);
        MyStore myStore = this.initMyStore(this.name.getMethodName(), conf, new MyStoreHook(){

            @Override
            public void getScanners(MyStore store) throws IOException {
                try {
                    if (shouldWaitRef.get()) {
                        cyclicBarrier.await();
                        cyclicBarrier.await();
                    }
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        AtomicReference<Object> compactionExceptionRef = new AtomicReference<Object>(null);
        Runnable compactionTask = () -> {
            try {
                cyclicBarrier.await();
                this.region.compactStore(this.family, (ThroughputController)new NoLimitThroughputController());
                myStore.closeAndArchiveCompactedFiles();
                cyclicBarrier.await();
            }
            catch (Throwable e) {
                compactionExceptionRef.set(e);
            }
        };
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        byte[] value = Bytes.toBytes((String)"value");
        myStore.add(this.createCell(r0, this.qf1, ts, seqId, value), null);
        TestHStore.flushStore(myStore, this.id++);
        myStore.add(this.createCell(r0, this.qf2, ts, seqId, value), null);
        TestHStore.flushStore(myStore, this.id++);
        myStore.add(this.createCell(r0, this.qf3, ts, seqId, value), null);
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        quals.add(this.qf3);
        myStore.add(this.createCell(r1, this.qf1, ts, seqId, value), null);
        myStore.add(this.createCell(r1, this.qf2, ts, seqId, value), null);
        myStore.add(this.createCell(r1, this.qf3, ts, seqId, value), null);
        Thread.currentThread().setName("testStoreScannerUpdateReadersWhenFlushAndCompactConcurrently thread");
        Scan scan = new Scan();
        scan.withStartRow(r0, true);
        try (InternalScanner scanner = (InternalScanner)myStore.getScanner(scan, quals, seqId);){
            MyList results = new MyList(size -> {
                switch (size) {
                    case 1: {
                        shouldWaitRef.set(true);
                        Thread thread = new Thread(compactionTask);
                        thread.setName("MyCompacting Thread.");
                        thread.start();
                        try {
                            TestHStore.flushStore(myStore, this.id++);
                            thread.join();
                        }
                        catch (IOException | InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        shouldWaitRef.set(false);
                        break;
                    }
                }
            });
            scanner.next(results);
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertTrue((compactionExceptionRef.get() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testReclaimChunkWhenScaning() throws IOException {
        this.init("testReclaimChunkWhenScaning");
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        byte[] value = Bytes.toBytes((String)"value");
        this.store.add(this.createCell(this.qf1, ts, seqId, value), null);
        this.store.add(this.createCell(this.qf2, ts, seqId, value), null);
        this.store.add(this.createCell(this.qf3, ts, seqId, value), null);
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        quals.add(this.qf3);
        try (InternalScanner scanner = (InternalScanner)this.store.getScanner(new Scan(new Get(this.row)), quals, seqId);){
            MyList results = new MyList(size -> {
                switch (size) {
                    case 1: {
                        try {
                            TestHStore.flushStore(this.store, this.id++);
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case 2: {
                        try {
                            byte[] newValue = Bytes.toBytes((String)"newValue");
                            this.store.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, newValue), null);
                            this.store.add(this.createCell(this.qf2, ts + 1L, seqId + 1L, newValue), null);
                            this.store.add(this.createCell(this.qf3, ts + 1L, seqId + 1L, newValue), null);
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            scanner.next(results);
            Assert.assertEquals((long)3L, (long)results.size());
            for (Cell c : results) {
                byte[] actualValue = CellUtil.cloneValue((Cell)c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary((byte[])value) + ", actual:" + Bytes.toStringBinary((byte[])actualValue)), (boolean)Bytes.equals((byte[])actualValue, (byte[])value));
            }
        }
    }

    @Test
    public void testRunDoubleMemStoreCompactors() throws IOException, InterruptedException {
        int flushSize = 500;
        Configuration conf = HBaseConfiguration.create();
        conf.set(HStore.MEMSTORE_CLASS_NAME, MyCompactingMemStoreWithCustomCompactor.class.getName());
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.25);
        MyCompactingMemStoreWithCustomCompactor.RUNNER_COUNT.set(0);
        conf.set(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, String.valueOf(flushSize));
        conf.set("hbase.hregion.compacting.pipeline.segments.limit", String.valueOf(0));
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build());
        byte[] value = Bytes.toBytes((String)"thisisavarylargevalue");
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        this.store.add(this.createCell(this.qf1, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf2, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf3, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        Assert.assertEquals((long)1L, (long)MyCompactingMemStoreWithCustomCompactor.RUNNER_COUNT.get());
        StoreFlushContext storeFlushCtx = this.store.createFlushContext(this.id++, FlushLifeCycleTracker.DUMMY);
        storeFlushCtx.prepare();
        this.store.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, value), (MemStoreSizing)memStoreSizing);
        Assert.assertEquals((long)1L, (long)MyCompactingMemStoreWithCustomCompactor.RUNNER_COUNT.get());
        MyMemStoreCompactor.START_COMPACTOR_LATCH.countDown();
        CompactingMemStore mem = (CompactingMemStore)this.store.memstore;
        while (mem.isMemStoreFlushingInMemory()) {
            TimeUnit.SECONDS.sleep(1L);
        }
        this.store.add(this.createCell(this.qf1, ts + 2L, seqId + 2L, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf1, ts + 2L, seqId + 2L, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf1, ts + 2L, seqId + 2L, value), (MemStoreSizing)memStoreSizing);
        Assert.assertEquals((long)2L, (long)MyCompactingMemStoreWithCustomCompactor.RUNNER_COUNT.get());
        conf.set(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, String.valueOf(0x8000000L));
        storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
        storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
    }

    @Test
    public void testAge() throws IOException {
        final long currentTime = EnvironmentEdgeManager.currentTime();
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        edge.setValue(currentTime);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        Configuration conf = TEST_UTIL.getConfiguration();
        ColumnFamilyDescriptor hcd = ColumnFamilyDescriptorBuilder.of((byte[])this.family);
        this.initHRegion(this.name.getMethodName(), conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)), hcd, null, false);
        HStore store = new HStore(this.region, hcd, conf, false){

            protected StoreEngine<?, ?, ?, ?> createStoreEngine(HStore store, Configuration conf, CellComparator kvComparator) throws IOException {
                List<HStoreFile> storefiles = Arrays.asList(TestHStore.this.mockStoreFile(currentTime - 10L), TestHStore.this.mockStoreFile(currentTime - 100L), TestHStore.this.mockStoreFile(currentTime - 1000L), TestHStore.this.mockStoreFile(currentTime - 10000L));
                StoreFileManager sfm = (StoreFileManager)Mockito.mock(StoreFileManager.class);
                Mockito.when((Object)sfm.getStoreFiles()).thenReturn(storefiles);
                StoreEngine storeEngine = (StoreEngine)Mockito.mock(StoreEngine.class);
                Mockito.when((Object)storeEngine.getStoreFileManager()).thenReturn((Object)sfm);
                return storeEngine;
            }
        };
        Assert.assertEquals((long)10L, (long)store.getMinStoreFileAge().getAsLong());
        Assert.assertEquals((long)10000L, (long)store.getMaxStoreFileAge().getAsLong());
        Assert.assertEquals((double)2777.5, (double)store.getAvgStoreFileAge().getAsDouble(), (double)1.0E-4);
    }

    private HStoreFile mockStoreFile(long createdTime) {
        StoreFileInfo info = (StoreFileInfo)Mockito.mock(StoreFileInfo.class);
        Mockito.when((Object)info.getCreatedTimestamp()).thenReturn((Object)createdTime);
        HStoreFile sf = (HStoreFile)Mockito.mock(HStoreFile.class);
        Mockito.when((Object)sf.getReader()).thenReturn(Mockito.mock(StoreFileReader.class));
        Mockito.when((Object)sf.isHFile()).thenReturn((Object)true);
        Mockito.when((Object)sf.getFileInfo()).thenReturn((Object)info);
        return sf;
    }

    private MyStore initMyStore(String methodName, Configuration conf, MyStoreHook hook) throws IOException {
        return (MyStore)this.init(methodName, conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMaxVersions(5).build(), hook);
    }

    @Test
    public void testSwitchingPreadtoStreamParallelyWithCompactionDischarger() throws Exception {
        int i;
        int i2;
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hstore.engine.class", DummyStoreEngine.class.getName());
        conf.setLong(StoreScanner.STORESCANNER_PREAD_MAX_BYTES, 0L);
        MyStore store = this.initMyStore(this.name.getMethodName(), conf, new MyStoreHook(){});
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = EnvironmentEdgeManager.currentTime();
        long seqID = 1L;
        for (i2 = 1; i2 < 10; ++i2) {
            store.add(this.createCell(Bytes.toBytes((String)("row" + i2)), this.qf1, ts, seqID++, Bytes.toBytes((String)"")), (MemStoreSizing)memStoreSizing);
        }
        TestHStore.flushStore(store, seqID);
        for (i2 = 11; i2 < 20; ++i2) {
            store.add(this.createCell(Bytes.toBytes((String)("row" + i2)), this.qf1, ts, seqID++, Bytes.toBytes((String)"")), (MemStoreSizing)memStoreSizing);
        }
        TestHStore.flushStore(store, seqID);
        for (i2 = 21; i2 < 30; ++i2) {
            store.add(this.createCell(Bytes.toBytes((String)("row" + i2)), this.qf1, ts, seqID++, Bytes.toBytes((String)"")), (MemStoreSizing)memStoreSizing);
        }
        TestHStore.flushStore(store, seqID);
        Assert.assertEquals((long)3L, (long)store.getStorefilesCount());
        Scan scan = new Scan();
        scan.addFamily(this.family);
        Collection storefiles2 = store.getStorefiles();
        ArrayList actualStorefiles = Lists.newArrayList((Iterable)storefiles2);
        StoreScanner storeScanner = (StoreScanner)store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(this.family), Long.MAX_VALUE);
        KeyValueHeap heap = storeScanner.heap;
        for (i = 31; i < 40; ++i) {
            store.add(this.createCell(Bytes.toBytes((String)("row" + i)), this.qf1, ts, seqID++, Bytes.toBytes((String)"")), (MemStoreSizing)memStoreSizing);
        }
        TestHStore.flushStore(store, seqID);
        for (i = 41; i < 50; ++i) {
            store.add(this.createCell(Bytes.toBytes((String)("row" + i)), this.qf1, ts, seqID++, Bytes.toBytes((String)"")), (MemStoreSizing)memStoreSizing);
        }
        TestHStore.flushStore(store, seqID);
        storefiles2 = store.getStorefiles();
        ArrayList actualStorefiles1 = Lists.newArrayList((Iterable)storefiles2);
        actualStorefiles1.removeAll(actualStorefiles);
        MyThread thread = new MyThread(storeScanner);
        thread.start();
        store.replaceStoreFiles(actualStorefiles, actualStorefiles1, false);
        thread.join();
        KeyValueHeap heap2 = thread.getHeap();
        Assert.assertFalse((boolean)heap.equals(heap2));
    }

    @Test
    public void testMaxPreadBytesConfiguredToBeLessThanZero() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hstore.engine.class", DummyStoreEngine.class.getName());
        conf.setLong(StoreScanner.STORESCANNER_PREAD_MAX_BYTES, -1L);
        MyStore store = this.initMyStore(this.name.getMethodName(), conf, new MyStoreHook(){});
        Scan scan = new Scan();
        scan.addFamily(this.family);
        Assert.assertEquals((Object)Scan.ReadType.DEFAULT, (Object)scan.getReadType());
        StoreScanner storeScanner = (StoreScanner)store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(this.family), Long.MAX_VALUE);
        Assert.assertFalse((boolean)storeScanner.isScanUsePread());
    }

    @Test
    public void testInMemoryCompactionTypeWithLowerCase() throws IOException, InterruptedException {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.systemtables.compacting.memstore.type", "eager");
        this.init(this.name.getMethodName(), conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])NamespaceDescriptor.SYSTEM_NAMESPACE_NAME, (byte[])"meta".getBytes())), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.NONE).build());
        Assert.assertTrue((boolean)((CompactingMemStore)this.store.memstore).compactor.toString().startsWith("eager".toUpperCase()));
    }

    @Test
    public void testSpaceQuotaChangeAfterReplacement() throws IOException {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        this.init(this.name.getMethodName());
        RegionSizeStoreImpl sizeStore = new RegionSizeStoreImpl();
        HStoreFile sf1 = this.mockStoreFileWithLength(1024L);
        HStoreFile sf2 = this.mockStoreFileWithLength(2048L);
        HStoreFile sf3 = this.mockStoreFileWithLength(4096L);
        HStoreFile sf4 = this.mockStoreFileWithLength(8192L);
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build();
        sizeStore.put(regionInfo, 5120L);
        this.store.updateSpaceQuotaAfterFileReplacement((RegionSizeStore)sizeStore, regionInfo, Arrays.asList(sf1, sf3), Arrays.asList(sf2));
        Assert.assertEquals((long)2048L, (long)sizeStore.getRegionSize(regionInfo).getSize());
        this.store.updateSpaceQuotaAfterFileReplacement((RegionSizeStore)sizeStore, regionInfo, Arrays.asList(sf2), Arrays.asList(sf2));
        Assert.assertEquals((long)2048L, (long)sizeStore.getRegionSize(regionInfo).getSize());
        this.store.updateSpaceQuotaAfterFileReplacement((RegionSizeStore)sizeStore, regionInfo, Arrays.asList(sf2), Arrays.asList(sf3));
        Assert.assertEquals((long)4096L, (long)sizeStore.getRegionSize(regionInfo).getSize());
        RegionInfo regionInfo2 = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"b")).setEndKey(Bytes.toBytes((String)"c")).build();
        this.store.updateSpaceQuotaAfterFileReplacement((RegionSizeStore)sizeStore, regionInfo2, null, Arrays.asList(sf4));
        Assert.assertEquals((long)8192L, (long)sizeStore.getRegionSize(regionInfo2).getSize());
    }

    @Test
    public void testHFileContextSetWithCFAndTable() throws Exception {
        this.init(this.name.getMethodName());
        StoreFileWriter writer = this.store.getStoreEngine().createWriter(CreateStoreFileWriterParams.create().maxKeyCount(10000L).compression(Compression.Algorithm.NONE).isCompaction(true).includeMVCCReadpoint(true).includesTag(false).shouldDropBehind(true));
        HFileContext hFileContext = writer.getLiveFileWriter().getFileContext();
        Assert.assertArrayEquals((byte[])this.family, (byte[])hFileContext.getColumnFamily());
        Assert.assertArrayEquals((byte[])this.table, (byte[])hFileContext.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompactingMemStoreNoCellButDataSizeExceedsInmemoryFlushSize() throws IOException, InterruptedException {
        Configuration conf = HBaseConfiguration.create();
        byte[] smallValue = new byte[3];
        byte[] largeValue = new byte[9];
        long timestamp = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        Cell smallCell = this.createCell(this.qf1, timestamp, 100L, smallValue);
        Cell largeCell = this.createCell(this.qf2, timestamp, 100L, largeValue);
        int smallCellByteSize = MutableSegment.getCellLength((Cell)smallCell);
        int largeCellByteSize = MutableSegment.getCellLength((Cell)largeCell);
        int flushByteSize = smallCellByteSize + largeCellByteSize - 2;
        conf.set(HStore.MEMSTORE_CLASS_NAME, MyCompactingMemStore2.class.getName());
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.005);
        conf.set(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, String.valueOf(flushByteSize * 200));
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build());
        MyCompactingMemStore2 myCompactingMemStore = (MyCompactingMemStore2)this.store.memstore;
        Assert.assertTrue(((int)myCompactingMemStore.getInmemoryFlushSize() == flushByteSize ? 1 : 0) != 0);
        myCompactingMemStore.smallCellPreUpdateCounter.set(0);
        myCompactingMemStore.largeCellPreUpdateCounter.set(0);
        AtomicReference exceptionRef = new AtomicReference();
        Thread smallCellThread = new Thread(() -> {
            try {
                this.store.add(smallCell, (MemStoreSizing)new NonThreadSafeMemStoreSizing());
            }
            catch (Throwable exception) {
                exceptionRef.set(exception);
            }
        });
        smallCellThread.setName("smallCellThread");
        smallCellThread.start();
        String oldThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("largeCellThread");
            this.store.add(largeCell, (MemStoreSizing)new NonThreadSafeMemStoreSizing());
            smallCellThread.join();
            for (int i = 0; i < 100; ++i) {
                long currentTimestamp = timestamp + 100L + (long)i;
                Cell cell = this.createCell(this.qf2, currentTimestamp, 100L, largeValue);
                this.store.add(cell, (MemStoreSizing)new NonThreadSafeMemStoreSizing());
            }
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
        Assert.assertTrue((exceptionRef.get() == null ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testCompactingMemStoreCellExceedInmemoryFlushSize() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set(HStore.MEMSTORE_CLASS_NAME, MyCompactingMemStore6.class.getName());
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build());
        MyCompactingMemStore6 myCompactingMemStore = (MyCompactingMemStore6)this.store.memstore;
        int size = (int)myCompactingMemStore.getInmemoryFlushSize();
        byte[] value = new byte[size + 1];
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long timestamp = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        Cell cell = this.createCell(this.qf1, timestamp, seqId, value);
        int cellByteSize = MutableSegment.getCellLength((Cell)cell);
        this.store.add(cell, (MemStoreSizing)memStoreSizing);
        Assert.assertTrue((memStoreSizing.getCellsCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((memStoreSizing.getDataSize() == (long)cellByteSize ? 1 : 0) != 0);
        myCompactingMemStore.inMemoryCompactionEndCyclicBarrier.await();
    }

    @Test
    public void testForceCloneOfBigCellForCellChunkImmutableSegment() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int maxAllocByteSize = conf.getInt("hbase.hregion.memstore.mslab.max.allocation", 262144);
        byte[] cellValue = new byte[maxAllocByteSize + 1];
        long timestamp = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        byte[] rowKey1 = Bytes.toBytes((String)"rowKey1");
        Cell originalCell1 = this.createCell(rowKey1, this.qf1, timestamp, 100L, cellValue);
        byte[] rowKey2 = Bytes.toBytes((String)"rowKey2");
        Cell originalCell2 = this.createCell(rowKey2, this.qf1, timestamp, 100L, cellValue);
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        int cellByteSize = MutableSegment.getCellLength((Cell)originalCell1);
        int inMemoryFlushByteSize = cellByteSize - 1;
        conf.set(HStore.MEMSTORE_CLASS_NAME, MyCompactingMemStore6.class.getName());
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.005);
        conf.set(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, String.valueOf(inMemoryFlushByteSize * 200));
        conf.setBoolean("hbase.regionserver.hlog.enabled", false);
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.EAGER).build());
        MyCompactingMemStore6 myCompactingMemStore = (MyCompactingMemStore6)this.store.memstore;
        Assert.assertTrue(((int)myCompactingMemStore.getInmemoryFlushSize() == inMemoryFlushByteSize ? 1 : 0) != 0);
        Assert.assertTrue((ChunkCreator.getInstance().getMaxCount(ChunkCreator.ChunkType.DATA_CHUNK) == 0 ? 1 : 0) != 0);
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        this.store.add(originalCell1, (MemStoreSizing)memStoreSizing);
        myCompactingMemStore.inMemoryCompactionEndCyclicBarrier.await();
        StoreScanner storeScanner = (StoreScanner)this.store.getScanner(new Scan(new Get(rowKey1)), quals, 101L);
        SegmentScanner segmentScanner = this.getTypeKeyValueScanner(storeScanner, SegmentScanner.class);
        Cell resultCell1 = segmentScanner.next();
        Assert.assertTrue((boolean)CellUtil.equals((Cell)resultCell1, (Cell)originalCell1));
        int cell1ChunkId = ((ExtendedCell)resultCell1).getChunkId();
        Assert.assertTrue((cell1ChunkId != -1 ? 1 : 0) != 0);
        Assert.assertNull((Object)segmentScanner.next());
        segmentScanner.close();
        storeScanner.close();
        Segment segment = segmentScanner.segment;
        Assert.assertTrue((boolean)(segment instanceof CellChunkImmutableSegment));
        MemStoreLABImpl memStoreLAB1 = (MemStoreLABImpl)segmentScanner.segment.getMemStoreLAB();
        Assert.assertTrue((!memStoreLAB1.isClosed() ? 1 : 0) != 0);
        Assert.assertTrue((!memStoreLAB1.chunks.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!memStoreLAB1.isReclaimed() ? 1 : 0) != 0);
        this.store.add(originalCell2, (MemStoreSizing)memStoreSizing);
        myCompactingMemStore.inMemoryCompactionEndCyclicBarrier.await();
        storeScanner = (StoreScanner)this.store.getScanner(new Scan(new Get(rowKey1)), quals, 101L);
        segmentScanner = this.getTypeKeyValueScanner(storeScanner, SegmentScanner.class);
        Cell newResultCell1 = segmentScanner.next();
        Assert.assertTrue((newResultCell1 != resultCell1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)CellUtil.equals((Cell)newResultCell1, (Cell)originalCell1));
        Cell resultCell2 = segmentScanner.next();
        Assert.assertTrue((boolean)CellUtil.equals((Cell)resultCell2, (Cell)originalCell2));
        Assert.assertNull((Object)segmentScanner.next());
        segmentScanner.close();
        storeScanner.close();
        segment = segmentScanner.segment;
        Assert.assertTrue((boolean)(segment instanceof CellChunkImmutableSegment));
        MemStoreLABImpl memStoreLAB2 = (MemStoreLABImpl)segmentScanner.segment.getMemStoreLAB();
        Assert.assertTrue((!memStoreLAB2.isClosed() ? 1 : 0) != 0);
        Assert.assertTrue((!memStoreLAB2.chunks.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!memStoreLAB2.isReclaimed() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)memStoreLAB1.isClosed());
        Assert.assertTrue((boolean)memStoreLAB1.chunks.isEmpty());
        Assert.assertTrue((boolean)memStoreLAB1.isReclaimed());
    }

    @Test
    public void testCompactingMemStoreWriteLargeCellAndSmallCellConcurrently() throws IOException, InterruptedException {
        this.doWriteTestLargeCellAndSmallCellConcurrently((smallCellByteSize, largeCellByteSize) -> largeCellByteSize - 1);
        this.doWriteTestLargeCellAndSmallCellConcurrently((smallCellByteSize, largeCellByteSize) -> largeCellByteSize);
        this.doWriteTestLargeCellAndSmallCellConcurrently((smallCellByteSize, largeCellByteSize) -> smallCellByteSize + largeCellByteSize - 1);
        this.doWriteTestLargeCellAndSmallCellConcurrently((smallCellByteSize, largeCellByteSize) -> smallCellByteSize + largeCellByteSize);
        this.doWriteTestLargeCellAndSmallCellConcurrently((smallCellByteSize, largeCellByteSize) -> smallCellByteSize + largeCellByteSize + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteTestLargeCellAndSmallCellConcurrently(IntBinaryOperator getFlushByteSize) throws IOException, InterruptedException {
        int largeCellByteSize;
        Configuration conf = HBaseConfiguration.create();
        byte[] smallValue = new byte[3];
        byte[] largeValue = new byte[100];
        long timestamp = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        Cell smallCell = this.createCell(this.qf1, timestamp, 100L, smallValue);
        Cell largeCell = this.createCell(this.qf2, timestamp, 100L, largeValue);
        int smallCellByteSize = MutableSegment.getCellLength((Cell)smallCell);
        int flushByteSize = getFlushByteSize.applyAsInt(smallCellByteSize, largeCellByteSize = MutableSegment.getCellLength((Cell)largeCell));
        boolean flushByteSizeLessThanSmallAndLargeCellSize = flushByteSize < smallCellByteSize + largeCellByteSize;
        conf.set(HStore.MEMSTORE_CLASS_NAME, MyCompactingMemStore3.class.getName());
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.005);
        conf.set(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, String.valueOf(flushByteSize * 200));
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build());
        MyCompactingMemStore3 myCompactingMemStore = (MyCompactingMemStore3)this.store.memstore;
        Assert.assertTrue(((int)myCompactingMemStore.getInmemoryFlushSize() == flushByteSize ? 1 : 0) != 0);
        myCompactingMemStore.disableCompaction();
        if (flushByteSizeLessThanSmallAndLargeCellSize) {
            myCompactingMemStore.flushByteSizeLessThanSmallAndLargeCellSize = true;
        } else {
            myCompactingMemStore.flushByteSizeLessThanSmallAndLargeCellSize = false;
        }
        ThreadSafeMemStoreSizing memStoreSizing = new ThreadSafeMemStoreSizing();
        AtomicLong totalCellByteSize = new AtomicLong(0L);
        AtomicReference exceptionRef = new AtomicReference();
        Thread smallCellThread = new Thread(() -> {
            try {
                for (int i = 1; i <= 5; ++i) {
                    long currentTimestamp = timestamp + (long)i;
                    Cell cell = this.createCell(this.qf1, currentTimestamp, 100L, smallValue);
                    totalCellByteSize.addAndGet(MutableSegment.getCellLength((Cell)cell));
                    this.store.add(cell, (MemStoreSizing)memStoreSizing);
                }
            }
            catch (Throwable exception) {
                exceptionRef.set(exception);
            }
        });
        smallCellThread.setName("smallCellThread");
        smallCellThread.start();
        String oldThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("largeCellThread");
            for (int i = 1; i <= 5; ++i) {
                long currentTimestamp = timestamp + (long)i;
                Cell cell = this.createCell(this.qf2, currentTimestamp, 100L, largeValue);
                totalCellByteSize.addAndGet(MutableSegment.getCellLength((Cell)cell));
                this.store.add(cell, (MemStoreSizing)memStoreSizing);
            }
            smallCellThread.join();
            Assert.assertTrue((exceptionRef.get() == null ? 1 : 0) != 0);
            Assert.assertTrue((memStoreSizing.getCellsCount() == 10 ? 1 : 0) != 0);
            Assert.assertTrue((memStoreSizing.getDataSize() == totalCellByteSize.get() ? 1 : 0) != 0);
            if (flushByteSizeLessThanSmallAndLargeCellSize) {
                Assert.assertTrue((myCompactingMemStore.flushCounter.get() == 5 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((myCompactingMemStore.flushCounter.get() <= 4 ? 1 : 0) != 0);
            }
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlattenAndSnapshotCompactingMemStoreConcurrently() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        byte[] smallValue = new byte[3];
        byte[] largeValue = new byte[9];
        long timestamp = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        Cell smallCell = this.createCell(this.qf1, timestamp, 100L, smallValue);
        Cell largeCell = this.createCell(this.qf2, timestamp, 100L, largeValue);
        int smallCellByteSize = MutableSegment.getCellLength((Cell)smallCell);
        int largeCellByteSize = MutableSegment.getCellLength((Cell)largeCell);
        int totalCellByteSize = smallCellByteSize + largeCellByteSize;
        int flushByteSize = totalCellByteSize - 2;
        conf.set(HStore.MEMSTORE_CLASS_NAME, MyCompactingMemStore4.class.getName());
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.005);
        conf.set(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, String.valueOf(flushByteSize * 200));
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build());
        MyCompactingMemStore4 myCompactingMemStore = (MyCompactingMemStore4)this.store.memstore;
        Assert.assertTrue(((int)myCompactingMemStore.getInmemoryFlushSize() == flushByteSize ? 1 : 0) != 0);
        this.store.add(smallCell, (MemStoreSizing)new NonThreadSafeMemStoreSizing());
        this.store.add(largeCell, (MemStoreSizing)new NonThreadSafeMemStoreSizing());
        String oldThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("takeSnapShotThread");
            myCompactingMemStore.snapShotStartCyclicCyclicBarrier.await();
            MemStoreSnapshot memStoreSnapshot = myCompactingMemStore.snapshot();
            myCompactingMemStore.inMemoryCompactionEndCyclicBarrier.await();
            Assert.assertTrue((memStoreSnapshot.getCellsCount() == 2 ? 1 : 0) != 0);
            Assert.assertTrue(((int)memStoreSnapshot.getDataSize() == totalCellByteSize ? 1 : 0) != 0);
            VersionedSegmentsList segments = myCompactingMemStore.getImmutableSegments();
            Assert.assertTrue((segments.getNumOfSegments() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((segments.getNumOfCells() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((myCompactingMemStore.setInMemoryCompactionFlagCounter.get() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((myCompactingMemStore.swapPipelineWithNullCounter.get() == 2 ? 1 : 0) != 0);
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlattenSnapshotWriteCompactingMemeStoreConcurrently() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        byte[] smallValue = new byte[3];
        byte[] largeValue = new byte[9];
        long timestamp = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        Cell smallCell = this.createCell(this.qf1, timestamp, 100L, smallValue);
        Cell largeCell = this.createCell(this.qf2, timestamp, 100L, largeValue);
        int smallCellByteSize = MutableSegment.getCellLength((Cell)smallCell);
        int largeCellByteSize = MutableSegment.getCellLength((Cell)largeCell);
        int firstWriteCellByteSize = smallCellByteSize + largeCellByteSize;
        int flushByteSize = firstWriteCellByteSize - 2;
        conf.set(HStore.MEMSTORE_CLASS_NAME, MyCompactingMemStore5.class.getName());
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.005);
        conf.set(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, String.valueOf(flushByteSize * 200));
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build());
        MyCompactingMemStore5 myCompactingMemStore = (MyCompactingMemStore5)this.store.memstore;
        Assert.assertTrue(((int)myCompactingMemStore.getInmemoryFlushSize() == flushByteSize ? 1 : 0) != 0);
        this.store.add(smallCell, (MemStoreSizing)new NonThreadSafeMemStoreSizing());
        this.store.add(largeCell, (MemStoreSizing)new NonThreadSafeMemStoreSizing());
        AtomicReference exceptionRef = new AtomicReference();
        Cell writeAgainCell1 = this.createCell(this.qf3, timestamp, 101L, largeValue);
        Cell writeAgainCell2 = this.createCell(this.qf4, timestamp, 101L, largeValue);
        int writeAgainCellByteSize = MutableSegment.getCellLength((Cell)writeAgainCell1) + MutableSegment.getCellLength((Cell)writeAgainCell2);
        Thread writeAgainThread = new Thread(() -> {
            try {
                myCompactingMemStore.writeMemStoreAgainStartCyclicBarrier.await();
                this.store.add(writeAgainCell1, (MemStoreSizing)new NonThreadSafeMemStoreSizing());
                this.store.add(writeAgainCell2, (MemStoreSizing)new NonThreadSafeMemStoreSizing());
                myCompactingMemStore.writeMemStoreAgainEndCyclicBarrier.await();
            }
            catch (Throwable exception) {
                exceptionRef.set(exception);
            }
        });
        writeAgainThread.setName("writeAgainThread");
        writeAgainThread.start();
        String oldThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("takeSnapShotThread");
            myCompactingMemStore.snapShotStartCyclicCyclicBarrier.await();
            MemStoreSnapshot memStoreSnapshot = myCompactingMemStore.snapshot();
            myCompactingMemStore.inMemoryCompactionEndCyclicBarrier.await();
            writeAgainThread.join();
            Assert.assertTrue((memStoreSnapshot.getCellsCount() == 2 ? 1 : 0) != 0);
            Assert.assertTrue(((int)memStoreSnapshot.getDataSize() == firstWriteCellByteSize ? 1 : 0) != 0);
            VersionedSegmentsList segments = myCompactingMemStore.getImmutableSegments();
            Assert.assertTrue((segments.getNumOfSegments() == 1 ? 1 : 0) != 0);
            Assert.assertTrue(((int)((ImmutableSegment)segments.getStoreSegments().get(0)).getDataSize() == writeAgainCellByteSize ? 1 : 0) != 0);
            Assert.assertTrue((segments.getNumOfCells() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((myCompactingMemStore.setInMemoryCompactionFlagCounter.get() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((exceptionRef.get() == null ? 1 : 0) != 0);
            Assert.assertTrue((myCompactingMemStore.swapPipelineWithNullCounter.get() == 2 ? 1 : 0) != 0);
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearSnapshotGetScannerConcurrently() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        byte[] smallValue = new byte[3];
        byte[] largeValue = new byte[9];
        long timestamp = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        Cell smallCell = this.createCell(this.qf1, timestamp, 100L, smallValue);
        Cell largeCell = this.createCell(this.qf2, timestamp, 100L, largeValue);
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        conf.set(HStore.MEMSTORE_CLASS_NAME, MyDefaultMemStore.class.getName());
        conf.setBoolean("hbase.regionserver.hlog.enabled", false);
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).build());
        MyDefaultMemStore myDefaultMemStore = (MyDefaultMemStore)this.store.memstore;
        myDefaultMemStore.store = this.store;
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        this.store.add(smallCell, (MemStoreSizing)memStoreSizing);
        this.store.add(largeCell, (MemStoreSizing)memStoreSizing);
        AtomicReference exceptionRef = new AtomicReference();
        Thread flushThread = new Thread(() -> {
            try {
                TestHStore.flushStore(this.store, this.id++);
            }
            catch (Throwable exception) {
                exceptionRef.set(exception);
            }
        });
        flushThread.setName("flushMyThread");
        flushThread.start();
        String oldThreadName = Thread.currentThread().getName();
        StoreScanner storeScanner = null;
        try {
            Thread.currentThread().setName("getScannerMyThread");
            myDefaultMemStore.getScannerCyclicBarrier.await();
            storeScanner = (StoreScanner)this.store.getScanner(new Scan(new Get(this.row)), quals, 101L);
            flushThread.join();
            if (myDefaultMemStore.shouldWait) {
                SegmentScanner segmentScanner = this.getTypeKeyValueScanner(storeScanner, SegmentScanner.class);
                MemStoreLABImpl memStoreLAB = (MemStoreLABImpl)segmentScanner.segment.getMemStoreLAB();
                Assert.assertTrue((boolean)memStoreLAB.isClosed());
                Assert.assertTrue((!memStoreLAB.chunks.isEmpty() ? 1 : 0) != 0);
                Assert.assertTrue((!memStoreLAB.isReclaimed() ? 1 : 0) != 0);
                Cell cell1 = segmentScanner.next();
                CellUtil.equals((Cell)smallCell, (Cell)cell1);
                Cell cell2 = segmentScanner.next();
                CellUtil.equals((Cell)largeCell, (Cell)cell2);
                Assert.assertNull((Object)segmentScanner.next());
            } else {
                ArrayList results = new ArrayList();
                storeScanner.next(results);
                Assert.assertEquals((long)2L, (long)results.size());
                CellUtil.equals((Cell)smallCell, (Cell)((Cell)results.get(0)));
                CellUtil.equals((Cell)largeCell, (Cell)((Cell)results.get(1)));
            }
            Assert.assertTrue((exceptionRef.get() == null ? 1 : 0) != 0);
        }
        finally {
            if (storeScanner != null) {
                storeScanner.close();
            }
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private <T> T getTypeKeyValueScanner(StoreScanner storeScanner, Class<T> keyValueScannerClass) {
        ArrayList<KeyValueScanner> resultScanners = new ArrayList<KeyValueScanner>();
        for (KeyValueScanner keyValueScanner : storeScanner.currentScanners) {
            if (!keyValueScannerClass.isInstance(keyValueScanner)) continue;
            resultScanners.add(keyValueScanner);
        }
        Assert.assertTrue((resultScanners.size() == 1 ? 1 : 0) != 0);
        return (T)resultScanners.get(0);
    }

    @Test
    public void testOnConfigurationChange() throws IOException {
        int COMMON_MAX_FILES_TO_COMPACT = 10;
        int NEW_COMMON_MAX_FILES_TO_COMPACT = 8;
        int STORE_MAX_FILES_TO_COMPACT = 6;
        Configuration conf = HBaseConfiguration.create();
        conf.setInt(CompactionConfiguration.HBASE_HSTORE_COMPACTION_MAX_KEY, 10);
        conf.setBoolean("hbase.block.data.cacheonread", false);
        conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
        conf.setBoolean("hbase.rs.evictblocksonclose", true);
        ColumnFamilyDescriptor hcd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setConfiguration(CompactionConfiguration.HBASE_HSTORE_COMPACTION_MAX_KEY, String.valueOf(6)).build();
        this.init(this.name.getMethodName(), conf, hcd);
        conf.setInt(CompactionConfiguration.HBASE_HSTORE_COMPACTION_MAX_KEY, 8);
        this.store.onConfigurationChange(conf);
        Assert.assertEquals((long)6L, (long)this.store.getStoreEngine().getCompactionPolicy().getConf().getMaxFilesToCompact());
        Assert.assertEquals((Object)conf.getBoolean("hbase.block.data.cacheonread", true), (Object)false);
        Assert.assertEquals((Object)conf.getBoolean("hbase.rs.cacheblocksonwrite", false), (Object)true);
        Assert.assertEquals((Object)conf.getBoolean("hbase.rs.evictblocksonclose", false), (Object)true);
        conf.getBoolean("hbase.block.data.cacheonread", true);
        conf.getBoolean("hbase.rs.cacheblocksonwrite", false);
        conf.getBoolean("hbase.rs.evictblocksonclose", false);
        this.store.onConfigurationChange(conf);
    }

    @Test
    public void testExtendsDefaultMemStore() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.regionserver.hlog.enabled", false);
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).build());
        Assert.assertTrue((this.store.memstore.getClass() == DefaultMemStore.class ? 1 : 0) != 0);
        this.tearDown();
        conf.set(HStore.MEMSTORE_CLASS_NAME, CustomDefaultMemStore.class.getName());
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).build());
        Assert.assertTrue((this.store.memstore.getClass() == CustomDefaultMemStore.class ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemoryLeakWhenFlushMemStoreRetrying() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        byte[] smallValue = new byte[3];
        byte[] largeValue = new byte[9];
        long timestamp = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        Cell smallCell = this.createCell(this.qf1, timestamp, 100L, smallValue);
        Cell largeCell = this.createCell(this.qf2, timestamp, 100L, largeValue);
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        conf.set(HStore.MEMSTORE_CLASS_NAME, MyDefaultMemStore1.class.getName());
        conf.setBoolean("hbase.regionserver.hlog.enabled", false);
        conf.set(DefaultStoreEngine.DEFAULT_STORE_FLUSHER_CLASS_KEY, MyDefaultStoreFlusher.class.getName());
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).build());
        MyDefaultMemStore1 myDefaultMemStore = (MyDefaultMemStore1)this.store.memstore;
        Assert.assertTrue((boolean)(this.store.storeEngine.getStoreFlusher() instanceof MyDefaultStoreFlusher));
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        this.store.add(smallCell, (MemStoreSizing)memStoreSizing);
        this.store.add(largeCell, (MemStoreSizing)memStoreSizing);
        TestHStore.flushStore(this.store, this.id++);
        MemStoreLABImpl memStoreLAB = (MemStoreLABImpl)myDefaultMemStore.snapshotImmutableSegment.getMemStoreLAB();
        Assert.assertTrue((boolean)memStoreLAB.isClosed());
        Assert.assertTrue((memStoreLAB.getRefCntValue() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)memStoreLAB.isReclaimed());
        Assert.assertTrue((boolean)memStoreLAB.chunks.isEmpty());
        try (StoreScanner storeScanner = null;){
            storeScanner = (StoreScanner)this.store.getScanner(new Scan(new Get(this.row)), quals, 101L);
            Assert.assertTrue((this.store.storeEngine.getStoreFileManager().getStorefileCount() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((this.store.memstore.size().getCellsCount() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.store.memstore.getSnapshotSize().getCellsCount() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((storeScanner.currentScanners.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(storeScanner.currentScanners.get(0) instanceof StoreFileScanner));
            ArrayList results = new ArrayList();
            storeScanner.next(results);
            Assert.assertEquals((long)2L, (long)results.size());
            CellUtil.equals((Cell)smallCell, (Cell)((Cell)results.get(0)));
            CellUtil.equals((Cell)largeCell, (Cell)((Cell)results.get(1)));
        }
    }

    @Test
    public void testImmutableMemStoreLABRefCnt() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        byte[] smallValue = new byte[3];
        byte[] largeValue = new byte[9];
        long timestamp = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        Cell smallCell1 = this.createCell(this.qf1, timestamp, 100L, smallValue);
        Cell largeCell1 = this.createCell(this.qf2, timestamp, 100L, largeValue);
        Cell smallCell2 = this.createCell(this.qf3, timestamp, 101L, smallValue);
        Cell largeCell2 = this.createCell(this.qf4, timestamp, 101L, largeValue);
        Cell smallCell3 = this.createCell(this.qf5, timestamp, 102L, smallValue);
        Cell largeCell3 = this.createCell(this.qf6, timestamp, 102L, largeValue);
        int smallCellByteSize = MutableSegment.getCellLength((Cell)smallCell1);
        int largeCellByteSize = MutableSegment.getCellLength((Cell)largeCell1);
        int firstWriteCellByteSize = smallCellByteSize + largeCellByteSize;
        int flushByteSize = firstWriteCellByteSize - 2;
        conf.set(HStore.MEMSTORE_CLASS_NAME, CompactingMemStore.class.getName());
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.005);
        conf.set(HConstants.HREGION_MEMSTORE_FLUSH_SIZE, String.valueOf(flushByteSize * 200));
        conf.setBoolean("hbase.regionserver.hlog.enabled", false);
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build());
        CompactingMemStore myCompactingMemStore = (CompactingMemStore)this.store.memstore;
        Assert.assertTrue(((int)myCompactingMemStore.getInmemoryFlushSize() == flushByteSize ? 1 : 0) != 0);
        myCompactingMemStore.allowCompaction.set(false);
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        this.store.add(smallCell1, (MemStoreSizing)memStoreSizing);
        this.store.add(largeCell1, (MemStoreSizing)memStoreSizing);
        this.store.add(smallCell2, (MemStoreSizing)memStoreSizing);
        this.store.add(largeCell2, (MemStoreSizing)memStoreSizing);
        this.store.add(smallCell3, (MemStoreSizing)memStoreSizing);
        this.store.add(largeCell3, (MemStoreSizing)memStoreSizing);
        VersionedSegmentsList versionedSegmentsList = myCompactingMemStore.getImmutableSegments();
        Assert.assertTrue((versionedSegmentsList.getNumOfSegments() == 3 ? 1 : 0) != 0);
        List segments = versionedSegmentsList.getStoreSegments();
        ArrayList<MemStoreLABImpl> memStoreLABs = new ArrayList<MemStoreLABImpl>(segments.size());
        for (Object segment : segments) {
            memStoreLABs.add((MemStoreLABImpl)segment.getMemStoreLAB());
        }
        List scanners1 = myCompactingMemStore.getScanners(Long.MAX_VALUE);
        for (MemStoreLABImpl memStoreLABImpl : memStoreLABs) {
            Assert.assertTrue((memStoreLABImpl.getRefCntValue() == 2 ? 1 : 0) != 0);
        }
        myCompactingMemStore.allowCompaction.set(true);
        myCompactingMemStore.flushInMemory();
        versionedSegmentsList = myCompactingMemStore.getImmutableSegments();
        Assert.assertTrue((versionedSegmentsList.getNumOfSegments() == 1 ? 1 : 0) != 0);
        ImmutableMemStoreLAB immutableMemStoreLAB = (ImmutableMemStoreLAB)((ImmutableSegment)versionedSegmentsList.getStoreSegments().get(0)).getMemStoreLAB();
        for (MemStoreLABImpl memStoreLAB : memStoreLABs) {
            Assert.assertTrue((memStoreLAB.getRefCntValue() == 2 ? 1 : 0) != 0);
        }
        List list = myCompactingMemStore.getScanners(Long.MAX_VALUE);
        for (MemStoreLABImpl memStoreLAB : memStoreLABs) {
            Assert.assertTrue((memStoreLAB.getRefCntValue() == 2 ? 1 : 0) != 0);
        }
        Assert.assertTrue((immutableMemStoreLAB.getRefCntValue() == 2 ? 1 : 0) != 0);
        for (KeyValueScanner scanner : scanners1) {
            scanner.close();
        }
        for (MemStoreLABImpl memStoreLAB : memStoreLABs) {
            Assert.assertTrue((memStoreLAB.getRefCntValue() == 1 ? 1 : 0) != 0);
        }
        for (KeyValueScanner scanner : list) {
            scanner.close();
        }
        for (MemStoreLABImpl memStoreLAB : memStoreLABs) {
            Assert.assertTrue((memStoreLAB.getRefCntValue() == 1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((immutableMemStoreLAB.getRefCntValue() == 1 ? 1 : 0) != 0);
        TestHStore.flushStore(this.store, this.id++);
        for (MemStoreLABImpl memStoreLAB : memStoreLABs) {
            Assert.assertTrue((memStoreLAB.getRefCntValue() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((immutableMemStoreLAB.getRefCntValue() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)immutableMemStoreLAB.isClosed());
        for (MemStoreLABImpl memStoreLAB : memStoreLABs) {
            Assert.assertTrue((boolean)memStoreLAB.isClosed());
            Assert.assertTrue((boolean)memStoreLAB.isReclaimed());
            Assert.assertTrue((boolean)memStoreLAB.chunks.isEmpty());
        }
    }

    private HStoreFile mockStoreFileWithLength(long length) {
        HStoreFile sf = (HStoreFile)Mockito.mock(HStoreFile.class);
        StoreFileReader sfr = (StoreFileReader)Mockito.mock(StoreFileReader.class);
        Mockito.when((Object)sf.isHFile()).thenReturn((Object)true);
        Mockito.when((Object)sf.getReader()).thenReturn((Object)sfr);
        Mockito.when((Object)sfr.length()).thenReturn((Object)length);
        return sf;
    }

    public static class MyDefaultMemStore
    extends DefaultMemStore {
        private static final String GET_SCANNER_THREAD_NAME = "getScannerMyThread";
        private static final String FLUSH_THREAD_NAME = "flushMyThread";
        private final CyclicBarrier getScannerCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier preClearSnapShotCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier postClearSnapShotCyclicBarrier = new CyclicBarrier(2);
        private final AtomicInteger getSnapshotSegmentsCounter = new AtomicInteger(0);
        private final AtomicInteger clearSnapshotCounter = new AtomicInteger(0);
        private volatile boolean shouldWait = true;
        private volatile HStore store = null;

        public MyDefaultMemStore(Configuration conf, CellComparator cellComparator, RegionServicesForStores regionServices) throws IOException {
            super(conf, cellComparator, regionServices);
        }

        protected List<Segment> getSnapshotSegments() {
            int currentCount;
            List result = super.getSnapshotSegments();
            if (Thread.currentThread().getName().equals(GET_SCANNER_THREAD_NAME) && (currentCount = this.getSnapshotSegmentsCounter.incrementAndGet()) == 1 && this.shouldWait) {
                try {
                    this.preClearSnapShotCyclicBarrier.await();
                    this.postClearSnapShotCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }

        protected void doClearSnapShot() {
            int currentCount;
            if (Thread.currentThread().getName().equals(FLUSH_THREAD_NAME) && (currentCount = this.clearSnapshotCounter.incrementAndGet()) == 1) {
                try {
                    if (((ReentrantReadWriteLock)this.store.getStoreEngine().getLock()).isWriteLockedByCurrentThread()) {
                        this.shouldWait = false;
                    }
                    this.getScannerCyclicBarrier.await();
                    if (this.shouldWait) {
                        this.preClearSnapShotCyclicBarrier.await();
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            super.doClearSnapShot();
            if (Thread.currentThread().getName().equals(FLUSH_THREAD_NAME) && (currentCount = this.clearSnapshotCounter.get()) == 1 && this.shouldWait) {
                try {
                    this.postClearSnapShotCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class MyCompactingMemStore6
    extends CompactingMemStore {
        private final CyclicBarrier inMemoryCompactionEndCyclicBarrier = new CyclicBarrier(2);

        public MyCompactingMemStore6(Configuration conf, CellComparatorImpl cellComparator, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
            super(conf, (CellComparator)cellComparator, store, regionServices, compactionPolicy);
        }

        void inMemoryCompaction() {
            try {
                super.inMemoryCompaction();
            }
            finally {
                try {
                    this.inMemoryCompactionEndCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class MyCompactingMemStore5
    extends CompactingMemStore {
        private static final String TAKE_SNAPSHOT_THREAD_NAME = "takeSnapShotThread";
        private static final String WRITE_AGAIN_THREAD_NAME = "writeAgainThread";
        private final CyclicBarrier flattenOneSegmentPreCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier flattenOneSegmentPostCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier snapShotStartCyclicCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier inMemoryCompactionEndCyclicBarrier = new CyclicBarrier(2);
        private final AtomicInteger getImmutableSegmentsListCounter = new AtomicInteger(0);
        private final AtomicInteger swapPipelineWithNullCounter = new AtomicInteger(0);
        private final AtomicInteger flattenOneSegmentCounter = new AtomicInteger(0);
        private final AtomicInteger setInMemoryCompactionFlagCounter = new AtomicInteger(0);
        private final CyclicBarrier writeMemStoreAgainStartCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier writeMemStoreAgainEndCyclicBarrier = new CyclicBarrier(3);

        public MyCompactingMemStore5(Configuration conf, CellComparatorImpl cellComparator, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
            super(conf, (CellComparator)cellComparator, store, regionServices, compactionPolicy);
        }

        public VersionedSegmentsList getImmutableSegments() {
            int currentCount;
            VersionedSegmentsList result = super.getImmutableSegments();
            if (Thread.currentThread().getName().equals(TAKE_SNAPSHOT_THREAD_NAME) && (currentCount = this.getImmutableSegmentsListCounter.incrementAndGet()) <= 1) {
                try {
                    this.flattenOneSegmentPreCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }

        protected boolean swapPipelineWithNull(VersionedSegmentsList segments) {
            if (Thread.currentThread().getName().equals(TAKE_SNAPSHOT_THREAD_NAME)) {
                int currentCount = this.swapPipelineWithNullCounter.incrementAndGet();
                if (currentCount <= 1) {
                    try {
                        this.flattenOneSegmentPostCyclicBarrier.await();
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
                if (currentCount == 2) {
                    try {
                        this.writeMemStoreAgainStartCyclicBarrier.await();
                        this.writeMemStoreAgainEndCyclicBarrier.await();
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            boolean result = super.swapPipelineWithNull(segments);
            if (Thread.currentThread().getName().equals(TAKE_SNAPSHOT_THREAD_NAME)) {
                int currentCount = this.swapPipelineWithNullCounter.get();
                if (currentCount <= 1) {
                    Assert.assertTrue((!result ? 1 : 0) != 0);
                }
                if (currentCount == 2) {
                    Assert.assertTrue((boolean)result);
                }
            }
            return result;
        }

        public void flattenOneSegment(long requesterVersion, MemStoreCompactionStrategy.Action action) {
            int currentCount = this.flattenOneSegmentCounter.incrementAndGet();
            if (currentCount <= 1) {
                try {
                    this.snapShotStartCyclicCyclicBarrier.await();
                    this.flattenOneSegmentPreCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            super.flattenOneSegment(requesterVersion, action);
            if (currentCount <= 1) {
                try {
                    this.flattenOneSegmentPostCyclicBarrier.await();
                    this.writeMemStoreAgainEndCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }

        protected boolean setInMemoryCompactionFlag() {
            boolean result = super.setInMemoryCompactionFlag();
            int count = this.setInMemoryCompactionFlagCounter.incrementAndGet();
            if (count <= 1) {
                Assert.assertTrue((boolean)result);
            }
            if (count == 2) {
                Assert.assertTrue((!result ? 1 : 0) != 0);
            }
            return result;
        }

        void inMemoryCompaction() {
            try {
                super.inMemoryCompaction();
            }
            finally {
                try {
                    this.inMemoryCompactionEndCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class MyCompactingMemStore4
    extends CompactingMemStore {
        private static final String TAKE_SNAPSHOT_THREAD_NAME = "takeSnapShotThread";
        private final CyclicBarrier flattenOneSegmentPreCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier flattenOneSegmentPostCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier snapShotStartCyclicCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier inMemoryCompactionEndCyclicBarrier = new CyclicBarrier(2);
        private final AtomicInteger getImmutableSegmentsListCounter = new AtomicInteger(0);
        private final AtomicInteger swapPipelineWithNullCounter = new AtomicInteger(0);
        private final AtomicInteger flattenOneSegmentCounter = new AtomicInteger(0);
        private final AtomicInteger setInMemoryCompactionFlagCounter = new AtomicInteger(0);

        public MyCompactingMemStore4(Configuration conf, CellComparatorImpl cellComparator, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
            super(conf, (CellComparator)cellComparator, store, regionServices, compactionPolicy);
        }

        public VersionedSegmentsList getImmutableSegments() {
            int currentCount;
            VersionedSegmentsList result = super.getImmutableSegments();
            if (Thread.currentThread().getName().equals(TAKE_SNAPSHOT_THREAD_NAME) && (currentCount = this.getImmutableSegmentsListCounter.incrementAndGet()) <= 1) {
                try {
                    this.flattenOneSegmentPreCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }

        protected boolean swapPipelineWithNull(VersionedSegmentsList segments) {
            int currentCount;
            if (Thread.currentThread().getName().equals(TAKE_SNAPSHOT_THREAD_NAME) && (currentCount = this.swapPipelineWithNullCounter.incrementAndGet()) <= 1) {
                try {
                    this.flattenOneSegmentPostCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            boolean result = super.swapPipelineWithNull(segments);
            if (Thread.currentThread().getName().equals(TAKE_SNAPSHOT_THREAD_NAME)) {
                int currentCount2 = this.swapPipelineWithNullCounter.get();
                if (currentCount2 <= 1) {
                    Assert.assertTrue((!result ? 1 : 0) != 0);
                }
                if (currentCount2 == 2) {
                    Assert.assertTrue((boolean)result);
                }
            }
            return result;
        }

        public void flattenOneSegment(long requesterVersion, MemStoreCompactionStrategy.Action action) {
            int currentCount = this.flattenOneSegmentCounter.incrementAndGet();
            if (currentCount <= 1) {
                try {
                    this.snapShotStartCyclicCyclicBarrier.await();
                    this.flattenOneSegmentPreCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            super.flattenOneSegment(requesterVersion, action);
            if (currentCount <= 1) {
                try {
                    this.flattenOneSegmentPostCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }

        protected boolean setInMemoryCompactionFlag() {
            boolean result = super.setInMemoryCompactionFlag();
            Assert.assertTrue((boolean)result);
            this.setInMemoryCompactionFlagCounter.incrementAndGet();
            return result;
        }

        void inMemoryCompaction() {
            try {
                super.inMemoryCompaction();
            }
            finally {
                try {
                    this.inMemoryCompactionEndCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class MyCompactingMemStore3
    extends CompactingMemStore {
        private static final String LARGE_CELL_THREAD_NAME = "largeCellThread";
        private static final String SMALL_CELL_THREAD_NAME = "smallCellThread";
        private final CyclicBarrier preCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier postCyclicBarrier = new CyclicBarrier(2);
        private final AtomicInteger flushCounter = new AtomicInteger(0);
        private static final int CELL_COUNT = 5;
        private boolean flushByteSizeLessThanSmallAndLargeCellSize = true;

        public MyCompactingMemStore3(Configuration conf, CellComparatorImpl cellComparator, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
            super(conf, (CellComparator)cellComparator, store, regionServices, compactionPolicy);
        }

        protected boolean checkAndAddToActiveSize(MutableSegment currActive, Cell cellToAdd, MemStoreSizing memstoreSizing) {
            if (!this.flushByteSizeLessThanSmallAndLargeCellSize) {
                return super.checkAndAddToActiveSize(currActive, cellToAdd, memstoreSizing);
            }
            if (Thread.currentThread().getName().equals(LARGE_CELL_THREAD_NAME)) {
                try {
                    this.preCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            boolean returnValue = super.checkAndAddToActiveSize(currActive, cellToAdd, memstoreSizing);
            if (Thread.currentThread().getName().equals(SMALL_CELL_THREAD_NAME)) {
                try {
                    this.preCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return returnValue;
        }

        protected void postUpdate(MutableSegment currentActiveMutableSegment) {
            super.postUpdate(currentActiveMutableSegment);
            if (!this.flushByteSizeLessThanSmallAndLargeCellSize) {
                try {
                    this.postCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return;
            }
            if (Thread.currentThread().getName().equals(SMALL_CELL_THREAD_NAME)) {
                try {
                    this.postCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }

        protected void flushInMemory(MutableSegment currentActiveMutableSegment) {
            super.flushInMemory(currentActiveMutableSegment);
            this.flushCounter.incrementAndGet();
            if (!this.flushByteSizeLessThanSmallAndLargeCellSize) {
                return;
            }
            Assert.assertTrue((boolean)Thread.currentThread().getName().equals(LARGE_CELL_THREAD_NAME));
            try {
                this.postCyclicBarrier.await();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        void disableCompaction() {
            this.allowCompaction.set(false);
        }

        void enableCompaction() {
            this.allowCompaction.set(true);
        }
    }

    public static class MyCompactingMemStore2
    extends CompactingMemStore {
        private static final String LARGE_CELL_THREAD_NAME = "largeCellThread";
        private static final String SMALL_CELL_THREAD_NAME = "smallCellThread";
        private final CyclicBarrier preCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier postCyclicBarrier = new CyclicBarrier(2);
        private final AtomicInteger largeCellPreUpdateCounter = new AtomicInteger(0);
        private final AtomicInteger smallCellPreUpdateCounter = new AtomicInteger(0);

        public MyCompactingMemStore2(Configuration conf, CellComparatorImpl cellComparator, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
            super(conf, (CellComparator)cellComparator, store, regionServices, compactionPolicy);
        }

        protected boolean checkAndAddToActiveSize(MutableSegment currActive, Cell cellToAdd, MemStoreSizing memstoreSizing) {
            int currentCount;
            if (Thread.currentThread().getName().equals(LARGE_CELL_THREAD_NAME) && (currentCount = this.largeCellPreUpdateCounter.incrementAndGet()) <= 1) {
                try {
                    this.preCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            boolean returnValue = super.checkAndAddToActiveSize(currActive, cellToAdd, memstoreSizing);
            if (Thread.currentThread().getName().equals(SMALL_CELL_THREAD_NAME)) {
                try {
                    this.preCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return returnValue;
        }

        protected void doAdd(MutableSegment currentActive, Cell cell, MemStoreSizing memstoreSizing) {
            if (Thread.currentThread().getName().equals(SMALL_CELL_THREAD_NAME)) {
                try {
                    this.postCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            super.doAdd(currentActive, cell, memstoreSizing);
        }

        protected void flushInMemory(MutableSegment currentActiveMutableSegment) {
            super.flushInMemory(currentActiveMutableSegment);
            if (Thread.currentThread().getName().equals(LARGE_CELL_THREAD_NAME) && this.largeCellPreUpdateCounter.get() <= 1) {
                try {
                    this.postCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class MyKeyValueHeap
    extends KeyValueHeap {
        private final MyKeyValueHeapHook hook;
        private int recordBlockSizeCallCount;

        public MyKeyValueHeap(List<? extends KeyValueScanner> scanners, CellComparator comparator, MyKeyValueHeapHook hook) throws IOException {
            super(scanners, comparator);
            this.hook = hook;
        }

        public void recordBlockSize(IntConsumer blockSizeConsumer) {
            ++this.recordBlockSizeCallCount;
            this.hook.onRecordBlockSize(this.recordBlockSizeCallCount);
            super.recordBlockSize(blockSizeConsumer);
        }
    }

    private static interface MyKeyValueHeapHook {
        public void onRecordBlockSize(int var1);
    }

    private static class MyList<T>
    implements List<T> {
        private final List<T> delegatee = new ArrayList<T>();
        private final MyListHook hookAtAdd;

        MyList(MyListHook hookAtAdd) {
            this.hookAtAdd = hookAtAdd;
        }

        @Override
        public int size() {
            return this.delegatee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegatee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegatee.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegatee.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegatee.toArray();
        }

        @Override
        public <R> R[] toArray(R[] a) {
            return this.delegatee.toArray(a);
        }

        @Override
        public boolean add(T e) {
            this.hookAtAdd.hook(this.size());
            return this.delegatee.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegatee.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegatee.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return this.delegatee.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            return this.delegatee.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegatee.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.delegatee.retainAll(c);
        }

        @Override
        public void clear() {
            this.delegatee.clear();
        }

        @Override
        public T get(int index) {
            return this.delegatee.get(index);
        }

        @Override
        public T set(int index, T element) {
            return this.delegatee.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            this.delegatee.add(index, element);
        }

        @Override
        public T remove(int index) {
            return this.delegatee.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.delegatee.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegatee.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.delegatee.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return this.delegatee.listIterator(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return this.delegatee.subList(fromIndex, toIndex);
        }
    }

    static interface MyListHook {
        public void hook(int var1);
    }

    public static class MyCompactingMemStore
    extends CompactingMemStore {
        private static final AtomicBoolean START_TEST = new AtomicBoolean(false);
        private final CountDownLatch getScannerLatch = new CountDownLatch(1);
        private final CountDownLatch snapshotLatch = new CountDownLatch(1);

        public MyCompactingMemStore(Configuration conf, CellComparatorImpl c, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
            super(conf, (CellComparator)c, store, regionServices, compactionPolicy);
        }

        protected List<KeyValueScanner> createList(int capacity) {
            if (START_TEST.get()) {
                try {
                    this.getScannerLatch.countDown();
                    this.snapshotLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return new ArrayList<KeyValueScanner>(capacity);
        }

        protected void pushActiveToPipeline(MutableSegment active, boolean checkEmpty) {
            if (START_TEST.get()) {
                try {
                    this.getScannerLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            super.pushActiveToPipeline(active, checkEmpty);
            if (START_TEST.get()) {
                this.snapshotLatch.countDown();
            }
        }
    }

    public static class MyCompactingMemStoreWithCustomCompactor
    extends CompactingMemStore {
        private static final AtomicInteger RUNNER_COUNT = new AtomicInteger(0);

        public MyCompactingMemStoreWithCustomCompactor(Configuration conf, CellComparatorImpl c, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
            super(conf, (CellComparator)c, store, regionServices, compactionPolicy);
        }

        protected MemStoreCompactor createMemStoreCompactor(MemoryCompactionPolicy compactionPolicy) throws IllegalArgumentIOException {
            return new MyMemStoreCompactor(this, compactionPolicy);
        }

        protected boolean setInMemoryCompactionFlag() {
            boolean rval = super.setInMemoryCompactionFlag();
            if (rval) {
                RUNNER_COUNT.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("runner count: " + RUNNER_COUNT.get());
                }
            }
            return rval;
        }
    }

    private static class MyMemStoreCompactor
    extends MemStoreCompactor {
        private static final AtomicInteger RUNNER_COUNT = new AtomicInteger(0);
        private static final CountDownLatch START_COMPACTOR_LATCH = new CountDownLatch(1);

        public MyMemStoreCompactor(CompactingMemStore compactingMemStore, MemoryCompactionPolicy compactionPolicy) throws IllegalArgumentIOException {
            super(compactingMemStore, compactionPolicy);
        }

        public boolean start() throws IOException {
            boolean isFirst;
            boolean bl = isFirst = RUNNER_COUNT.getAndIncrement() == 0;
            if (isFirst) {
                try {
                    START_COMPACTOR_LATCH.await();
                    return super.start();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return super.start();
        }
    }

    private static class MyThread
    extends Thread {
        private StoreScanner scanner;
        private KeyValueHeap heap;

        public MyThread(StoreScanner scanner) {
            this.scanner = scanner;
        }

        public KeyValueHeap getHeap() {
            return this.heap;
        }

        @Override
        public void run() {
            this.scanner.trySwitchToStreamRead();
            this.heap = this.scanner.heap;
        }
    }

    public static class MyDefaultStoreFlusher
    extends DefaultStoreFlusher {
        private static final AtomicInteger failCounter = new AtomicInteger(1);
        private static final AtomicInteger counter = new AtomicInteger(0);

        public MyDefaultStoreFlusher(Configuration conf, HStore store) {
            super(conf, store);
        }

        public List<Path> flushSnapshot(MemStoreSnapshot snapshot, long cacheFlushId, MonitoredTask status, ThroughputController throughputController, FlushLifeCycleTracker tracker, Consumer<Path> writerCreationTracker) throws IOException {
            counter.incrementAndGet();
            return super.flushSnapshot(snapshot, cacheFlushId, status, throughputController, tracker, writerCreationTracker);
        }

        protected void performFlush(InternalScanner scanner, CellSink sink, ThroughputController throughputController) throws IOException {
            int currentCount = counter.get();
            CellSink newCellSink = cell -> {
                if (currentCount <= failCounter.get()) {
                    throw new IOException("Simulated exception by tests");
                }
                sink.append(cell);
            };
            super.performFlush(scanner, newCellSink, throughputController);
        }
    }

    static class MyDefaultMemStore1
    extends DefaultMemStore {
        private ImmutableSegment snapshotImmutableSegment;

        public MyDefaultMemStore1(Configuration conf, CellComparator c, RegionServicesForStores regionServices) {
            super(conf, c, regionServices);
        }

        public MemStoreSnapshot snapshot() {
            MemStoreSnapshot result = super.snapshot();
            this.snapshotImmutableSegment = this.snapshot;
            return result;
        }
    }

    static class CustomDefaultMemStore
    extends DefaultMemStore {
        public CustomDefaultMemStore(Configuration conf, CellComparator c, RegionServicesForStores regionServices) {
            super(conf, c, regionServices);
        }
    }

    private static abstract class MyStoreHook {
        private MyStoreHook() {
        }

        void getScanners(MyStore store) throws IOException {
        }

        long getSmallestReadPoint(HStore store) {
            return store.getHRegion().getSmallestReadPoint();
        }
    }

    private static class MyStore
    extends HStore {
        private final MyStoreHook hook;

        MyStore(HRegion region, ColumnFamilyDescriptor family, Configuration confParam, MyStoreHook hook, boolean switchToPread) throws IOException {
            super(region, family, confParam, false);
            this.hook = hook;
        }

        public List<KeyValueScanner> getScanners(List<HStoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt, boolean includeMemstoreScanner, boolean onlyLatestVersion) throws IOException {
            this.hook.getScanners(this);
            return super.getScanners(files, cacheBlocks, usePread, isCompaction, matcher, startRow, true, stopRow, false, readPt, includeMemstoreScanner, onlyLatestVersion);
        }

        public long getSmallestReadPoint() {
            return this.hook.getSmallestReadPoint(this);
        }
    }

    public static class DummyStoreEngine
    extends DefaultStoreEngine {
        public static DefaultCompactor lastCreatedCompactor = null;

        protected void createComponents(Configuration conf, HStore store, CellComparator comparator) throws IOException {
            super.createComponents(conf, store, comparator);
            lastCreatedCompactor = (DefaultCompactor)this.compactor;
        }
    }

    static class FaultyOutputStream
    extends FSDataOutputStream {
        volatile long faultPos = Long.MAX_VALUE;
        private final AtomicBoolean fault;

        public FaultyOutputStream(FSDataOutputStream out, long faultPos, AtomicBoolean fault) throws IOException {
            super((OutputStream)out, null);
            this.faultPos = faultPos;
            this.fault = fault;
        }

        public synchronized void write(byte[] buf, int offset, int length) throws IOException {
            LOG.info("faulty stream write at pos " + this.getPos());
            this.injectFault();
            super.write(buf, offset, length);
        }

        private void injectFault() throws IOException {
            if (this.fault.get() && this.getPos() >= this.faultPos) {
                throw new IOException("Fault injected");
            }
        }
    }

    static class FaultyFileSystem
    extends FilterFileSystem {
        List<SoftReference<FaultyOutputStream>> outStreams = new ArrayList<SoftReference<FaultyOutputStream>>();
        private long faultPos = 200L;
        AtomicBoolean fault = new AtomicBoolean(true);

        public FaultyFileSystem() {
            super((FileSystem)new LocalFileSystem());
            LOG.info("Creating faulty!");
        }

        public FSDataOutputStream create(Path p) throws IOException {
            return new FaultyOutputStream(super.create(p), this.faultPos, this.fault);
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return new FaultyOutputStream(super.create(f, permission, overwrite, bufferSize, replication, blockSize, progress), this.faultPos, this.fault);
        }

        public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return this.create(f, overwrite, bufferSize, replication, blockSize, progress);
        }
    }
}

