/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.RegionReplicaGroupingCostFunction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionReplicaRackCostFunction
extends RegionReplicaGroupingCostFunction {
    private static final String REGION_REPLICA_RACK_COST_KEY = "hbase.master.balancer.stochastic.regionReplicaRackCostKey";
    private static final float DEFAULT_REGION_REPLICA_RACK_COST_KEY = 10000.0f;

    public RegionReplicaRackCostFunction(Configuration conf) {
        this.setMultiplier(conf.getFloat(REGION_REPLICA_RACK_COST_KEY, 10000.0f));
    }

    @Override
    protected void loadCosts() {
        if (this.cluster.numRacks <= 1) {
            this.maxCost = 0L;
            return;
        }
        this.maxCost = this.getMaxCost(this.cluster);
        this.costsPerGroup = new long[this.cluster.numRacks];
        for (int i = 0; i < this.cluster.colocatedReplicaCountsPerRack.length; ++i) {
            this.costsPerGroup[i] = this.costPerGroup(this.cluster.colocatedReplicaCountsPerRack[i]);
        }
    }

    @Override
    protected void regionMoved(int region, int oldServer, int newServer) {
        if (this.maxCost <= 0L) {
            return;
        }
        int newRack = this.cluster.serverIndexToRackIndex[newServer];
        int oldRack = this.cluster.serverIndexToRackIndex[oldServer];
        if (newRack != oldRack) {
            this.costsPerGroup[oldRack] = this.costPerGroup(this.cluster.colocatedReplicaCountsPerRack[oldRack]);
            this.costsPerGroup[newRack] = this.costPerGroup(this.cluster.colocatedReplicaCountsPerRack[newRack]);
        }
    }
}

