/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ChaosUtils {
    public static String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public static String getZKQuorum(Configuration conf) {
        String port = Integer.toString(conf.getInt("hbase.zookeeper.property.clientPort", 2181));
        CharSequence[] serverHosts = conf.getStrings("hbase.zookeeper.quorum", new String[]{"localhost"});
        for (int i = 0; i < serverHosts.length; ++i) {
            serverHosts[i] = (String)serverHosts[i] + ":" + port;
        }
        return String.join((CharSequence)",", serverHosts);
    }
}

