/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.terminal.impl;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.hbase.hbtop.terminal.CursorPosition;
import org.apache.hadoop.hbase.hbtop.terminal.KeyPress;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalPrinter;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalSize;
import org.apache.hadoop.hbase.hbtop.terminal.impl.EscapeSequences;
import org.apache.hadoop.hbase.hbtop.terminal.impl.KeyPressGenerator;
import org.apache.hadoop.hbase.hbtop.terminal.impl.ScreenBuffer;
import org.apache.hadoop.hbase.hbtop.terminal.impl.TerminalPrinterImpl;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TerminalImpl
implements Terminal {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminalImpl.class);
    private TerminalSize cachedTerminalSize;
    private final PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
    private final ScreenBuffer screenBuffer;
    private final Queue<KeyPress> keyPressQueue;
    private final KeyPressGenerator keyPressGenerator;

    public TerminalImpl() {
        this(null);
    }

    public TerminalImpl(@Nullable String title) {
        this.sttyRaw();
        if (title != null) {
            this.setTitle(title);
        }
        this.screenBuffer = new ScreenBuffer();
        this.cachedTerminalSize = this.queryTerminalSize();
        this.updateTerminalSize(this.cachedTerminalSize.getColumns(), this.cachedTerminalSize.getRows());
        this.keyPressQueue = new ConcurrentLinkedQueue<KeyPress>();
        this.keyPressGenerator = new KeyPressGenerator(System.in, this.keyPressQueue);
        this.keyPressGenerator.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.output.printf("%s%s%s%s", EscapeSequences.moveCursor(0, 0), EscapeSequences.cursor(true), EscapeSequences.normal(), EscapeSequences.clearAll());
            this.output.flush();
            this.sttyCooked();
        }));
        this.output.write(EscapeSequences.clearAll());
        this.output.flush();
    }

    private void setTitle(String title) {
        this.output.write(EscapeSequences.setTitle(title));
        this.output.flush();
    }

    private void updateTerminalSize(int columns, int rows) {
        this.screenBuffer.reallocate(columns, rows);
    }

    @Override
    public void clear() {
        this.screenBuffer.clear();
    }

    @Override
    public void refresh() {
        this.screenBuffer.flush(this.output);
    }

    @Override
    public TerminalSize getSize() {
        return this.cachedTerminalSize;
    }

    @Override
    @Nullable
    public TerminalSize doResizeIfNecessary() {
        TerminalSize currentTerminalSize = this.queryTerminalSize();
        if (!currentTerminalSize.equals(this.cachedTerminalSize)) {
            this.cachedTerminalSize = currentTerminalSize;
            this.updateTerminalSize(this.cachedTerminalSize.getColumns(), this.cachedTerminalSize.getRows());
            return this.cachedTerminalSize;
        }
        return null;
    }

    @Override
    @Nullable
    public KeyPress pollKeyPress() {
        return this.keyPressQueue.poll();
    }

    @Override
    public CursorPosition getCursorPosition() {
        return this.screenBuffer.getCursorPosition();
    }

    @Override
    public void setCursorPosition(int column, int row) {
        this.screenBuffer.setCursorPosition(column, row);
    }

    @Override
    public void hideCursor() {
        this.screenBuffer.hideCursor();
    }

    @Override
    public TerminalPrinter getTerminalPrinter(int startRow) {
        return new TerminalPrinterImpl(this.screenBuffer, startRow);
    }

    @Override
    public void close() {
        this.keyPressGenerator.stop();
    }

    private TerminalSize queryTerminalSize() {
        String sizeString = this.doStty("size");
        int rows = 0;
        int columns = 0;
        StringTokenizer tokenizer = new StringTokenizer(sizeString);
        int rc = Integer.parseInt(tokenizer.nextToken());
        if (rc > 0) {
            rows = rc;
        }
        if ((rc = Integer.parseInt(tokenizer.nextToken())) > 0) {
            columns = rc;
        }
        return new TerminalSize(columns, rows);
    }

    private void sttyRaw() {
        this.doStty("-ignbrk -brkint -parmrk -istrip -inlcr -igncr -icrnl -ixon -opost -echo -echonl -icanon -isig -iexten -parenb cs8 min 1");
    }

    private void sttyCooked() {
        this.doStty("sane cooked");
    }

    private String doStty(String sttyOptionsString) {
        String[] cmd = new String[]{"/bin/sh", "-c", "stty " + sttyOptionsString + " < /dev/tty"};
        try {
            String ret;
            Process process = Runtime.getRuntime().exec(cmd);
            try (BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                ret = stdout.readLine();
            }
            var6_8 = null;
            try (BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
                String line = stderr.readLine();
                if (line != null && line.length() > 0) {
                    LOGGER.error("Error output from stty: " + line);
                }
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                LOGGER.error("stty returned error code: " + exitValue);
            }
            return ret;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

