/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;

public class LessEqNode<T>
extends SimpleNode<T> {
    public LessEqNode(AttributeType attributeType, Value<T> value) {
        super(attributeType, value, AssertionType.LESSEQ);
    }

    public LessEqNode(String attribute, Value<T> value) {
        super(attribute, value, AssertionType.LESSEQ);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (this.attributeType != null) {
            buf.append(this.attributeType.getName());
        } else {
            buf.append(this.attribute);
        }
        buf.append("<=");
        Value<?> escapedValue = this.getEscapedValue();
        if (!escapedValue.isNull()) {
            buf.append(escapedValue);
        }
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

