/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import org.apache.directory.api.ldap.model.message.AbstractAbandonableRequest;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;

public class ModifyDnRequestImpl
extends AbstractAbandonableRequest
implements ModifyDnRequest {
    static final long serialVersionUID = 1233507339633051696L;
    private Dn name;
    private Rdn newRdn;
    private Dn newSuperior;
    private boolean deleteOldRdn = false;
    private ModifyDnResponse response;

    public ModifyDnRequestImpl() {
        super(-1, TYPE);
    }

    @Override
    public boolean getDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    @Override
    public ModifyDnRequest setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
        return this;
    }

    @Override
    public boolean isMove() {
        return this.newSuperior != null;
    }

    @Override
    public Dn getName() {
        return this.name;
    }

    @Override
    public ModifyDnRequest setName(Dn name) {
        this.name = name;
        return this;
    }

    @Override
    public Rdn getNewRdn() {
        return this.newRdn;
    }

    @Override
    public ModifyDnRequest setNewRdn(Rdn newRdn) {
        this.newRdn = newRdn;
        return this;
    }

    @Override
    public Dn getNewSuperior() {
        return this.newSuperior;
    }

    @Override
    public ModifyDnRequest setNewSuperior(Dn newSuperior) {
        this.newSuperior = newSuperior;
        return this;
    }

    @Override
    public ModifyDnRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public ModifyDnRequest addControl(Control control) {
        return (ModifyDnRequest)super.addControl(control);
    }

    @Override
    public ModifyDnRequest addAllControls(Control[] controls) {
        return (ModifyDnRequest)super.addAllControls(controls);
    }

    @Override
    public ModifyDnRequest removeControl(Control control) {
        return (ModifyDnRequest)super.removeControl(control);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    @Override
    public ModifyDnResponse getResultResponse() {
        if (this.response == null) {
            this.response = new ModifyDnResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public int hashCode() {
        int hash = 37;
        if (this.name != null) {
            hash = hash * 17 + this.name.hashCode();
        }
        hash = hash * 17 + (this.deleteOldRdn ? 0 : 1);
        if (this.newRdn != null) {
            hash = hash * 17 + this.newRdn.hashCode();
        }
        if (this.newSuperior != null) {
            hash = hash * 17 + this.newSuperior.hashCode();
        }
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ModifyDnRequest req = (ModifyDnRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (this.deleteOldRdn != req.getDeleteOldRdn()) {
            return false;
        }
        if (this.newRdn != null && req.getNewRdn() == null) {
            return false;
        }
        if (this.newRdn == null && req.getNewRdn() != null) {
            return false;
        }
        if (this.newRdn != null && req.getNewRdn() != null && !this.newRdn.equals(req.getNewRdn())) {
            return false;
        }
        if (this.newSuperior != null && req.getNewSuperior() == null) {
            return false;
        }
        if (this.newSuperior == null && req.getNewSuperior() != null) {
            return false;
        }
        return this.newSuperior == null || req.getNewSuperior() == null || this.newSuperior.equals(req.getNewSuperior());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    ModifyDN Response\n");
        sb.append("        Entry : '").append(this.name).append("'\n");
        if (this.newRdn != null) {
            sb.append("        New Rdn : '").append(this.newRdn.toString()).append("'\n");
        }
        sb.append("        Delete old Rdn : ").append(this.deleteOldRdn).append("\n");
        if (this.newSuperior != null) {
            sb.append("        New superior : '").append(this.newSuperior.toString()).append("'\n");
        }
        sb.append(super.toString());
        return super.toString(sb.toString());
    }
}

