/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.agrona.BitUtil;

public class LongArrayQueue
extends AbstractQueue<Long>
implements Serializable {
    public static final long DEFAULT_NULL_VALUE = Long.MIN_VALUE;
    public static final int MIN_CAPACITY = 8;
    private static final long serialVersionUID = 8043508567156267834L;
    private final boolean shouldAvoidAllocation;
    private int head;
    private int tail;
    private final long nullValue;
    private long[] elements;
    private LongIterator iterator;

    public LongArrayQueue() {
        this(8, Long.MIN_VALUE, true);
    }

    public LongArrayQueue(long nullValue) {
        this(8, nullValue, true);
    }

    public LongArrayQueue(int initialCapacity, long nullValue) {
        this(initialCapacity, nullValue, true);
    }

    public LongArrayQueue(int initialCapacity, long nullValue, boolean shouldAvoidAllocation) {
        this.nullValue = nullValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        if (initialCapacity < 8) {
            throw new IllegalArgumentException("initial capacity < MIN_INITIAL_CAPACITY : " + initialCapacity);
        }
        int capacity = BitUtil.findNextPositivePowerOfTwo(initialCapacity);
        if (capacity < 8) {
            throw new IllegalArgumentException("invalid initial capacity: " + initialCapacity);
        }
        this.elements = new long[capacity];
        Arrays.fill(this.elements, nullValue);
    }

    public long nullValue() {
        return this.nullValue;
    }

    public int capacity() {
        return this.elements.length;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public void clear() {
        if (this.head != this.tail) {
            Arrays.fill(this.elements, this.nullValue);
            this.head = 0;
            this.tail = 0;
        }
    }

    @Override
    public boolean offer(Long element) {
        return this.offerLong(element);
    }

    public boolean offerLong(long element) {
        if (this.nullValue == element) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = element;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.increaseCapacity();
        }
        return true;
    }

    @Override
    public boolean add(Long element) {
        return this.offerLong(element);
    }

    public boolean addLong(long element) {
        return this.offerLong(element);
    }

    @Override
    public Long peek() {
        long element = this.elements[this.head];
        return element == this.nullValue ? null : Long.valueOf(element);
    }

    public long peekLong() {
        return this.elements[this.head];
    }

    @Override
    public Long poll() {
        long element = this.pollLong();
        return element == this.nullValue ? null : Long.valueOf(element);
    }

    public long pollLong() {
        long element = this.elements[this.head];
        if (this.nullValue == element) {
            return this.nullValue;
        }
        this.elements[this.head] = this.nullValue;
        this.head = this.head + 1 & this.elements.length - 1;
        return element;
    }

    @Override
    public Long remove() {
        long element = this.pollLong();
        if (this.nullValue == element) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public Long element() {
        long element = this.elements[this.head];
        if (this.nullValue == element) {
            throw new NoSuchElementException();
        }
        return element;
    }

    public long elementLong() {
        long element = this.elements[this.head];
        if (this.nullValue == element) {
            throw new NoSuchElementException();
        }
        return element;
    }

    public long removeLong() {
        long element = this.pollLong();
        if (this.nullValue == element) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = this.head;
        while (i != this.tail) {
            sb.append(this.elements[i]).append(", ");
            i = i + 1 & this.elements.length - 1;
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void forEach(Consumer<? super Long> action) {
        int i = this.head;
        while (i != this.tail) {
            action.accept((Long)this.elements[i]);
            i = i + 1 & this.elements.length - 1;
        }
    }

    public void forEachLong(LongConsumer action) {
        int i = this.head;
        while (i != this.tail) {
            action.accept(this.elements[i]);
            i = i + 1 & this.elements.length - 1;
        }
    }

    public LongIterator iterator() {
        LongIterator iterator = this.iterator;
        if (null == iterator) {
            iterator = new LongIterator();
            if (this.shouldAvoidAllocation) {
                this.iterator = iterator;
            }
        }
        return iterator.reset();
    }

    private void increaseCapacity() {
        int oldHead = this.head;
        int oldCapacity = this.elements.length;
        int toEndOfArray = oldCapacity - oldHead;
        int newCapacity = oldCapacity << 1;
        if (newCapacity < 8) {
            throw new IllegalStateException("max capacity reached");
        }
        long[] array = new long[newCapacity];
        Arrays.fill(array, oldCapacity, newCapacity, this.nullValue);
        System.arraycopy(this.elements, oldHead, array, 0, toEndOfArray);
        System.arraycopy(this.elements, 0, array, toEndOfArray, oldHead);
        this.elements = array;
        this.head = 0;
        this.tail = oldCapacity;
    }

    public final class LongIterator
    implements Iterator<Long>,
    Serializable {
        private static final long serialVersionUID = -7596692870537894897L;
        private int index;

        LongIterator reset() {
            this.index = LongArrayQueue.this.head;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.index != LongArrayQueue.this.tail;
        }

        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            if (this.index == LongArrayQueue.this.tail) {
                throw new NoSuchElementException();
            }
            long element = LongArrayQueue.this.elements[this.index];
            this.index = this.index + 1 & LongArrayQueue.this.elements.length - 1;
            return element;
        }
    }
}

