/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TestProtobufRpcServiceImpl
implements TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface,
TestRpcServiceProtos.TestProtobufRpcProto.Interface {
    public static final BlockingService SERVICE = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService((TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface)new TestProtobufRpcServiceImpl());
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).build());

    public static TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface newBlockingStub(RpcClient client, InetSocketAddress addr) throws IOException {
        return TestProtobufRpcServiceImpl.newBlockingStub(client, addr, User.getCurrent());
    }

    public static TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface newBlockingStub(RpcClient client, InetSocketAddress addr, User user) throws IOException {
        return TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub((BlockingRpcChannel)client.createBlockingRpcChannel(ServerName.valueOf((String)addr.getHostName(), (int)addr.getPort(), (long)EnvironmentEdgeManager.currentTime()), user, 0));
    }

    public static TestRpcServiceProtos.TestProtobufRpcProto.Interface newStub(RpcClient client, InetSocketAddress addr) throws IOException {
        return TestRpcServiceProtos.TestProtobufRpcProto.newStub((RpcChannel)client.createRpcChannel(ServerName.valueOf((String)addr.getHostName(), (int)addr.getPort(), (long)EnvironmentEdgeManager.currentTime()), User.getCurrent(), 0));
    }

    public TestProtos.EmptyResponseProto ping(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
        return TestProtos.EmptyResponseProto.getDefaultInstance();
    }

    public TestProtos.EchoResponseProto echo(RpcController controller, TestProtos.EchoRequestProto request) throws ServiceException {
        if (controller instanceof HBaseRpcController) {
            HBaseRpcController pcrc = (HBaseRpcController)controller;
            CellScanner cellScanner = pcrc.cellScanner();
            ArrayList<Cell> list = null;
            if (cellScanner != null) {
                list = new ArrayList<Cell>();
                try {
                    while (cellScanner.advance()) {
                        list.add(cellScanner.current());
                    }
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            cellScanner = CellUtil.createCellScanner(list);
            pcrc.setCellScanner(cellScanner);
        }
        return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
    }

    public TestProtos.EmptyResponseProto error(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("server error!"));
    }

    public TestProtos.EmptyResponseProto pause(RpcController controller, TestProtos.PauseRequestProto request) throws ServiceException {
        Threads.sleepWithoutInterrupt((long)request.getMs());
        return TestProtos.EmptyResponseProto.getDefaultInstance();
    }

    public TestProtos.AddrResponseProto addr(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
        return TestProtos.AddrResponseProto.newBuilder().setAddr(((InetAddress)RpcServer.getRemoteAddress().get()).getHostAddress()).build();
    }

    public void ping(RpcController controller, TestProtos.EmptyRequestProto request, RpcCallback<TestProtos.EmptyResponseProto> done) {
        done.run((Object)TestProtos.EmptyResponseProto.getDefaultInstance());
    }

    public void echo(RpcController controller, TestProtos.EchoRequestProto request, RpcCallback<TestProtos.EchoResponseProto> done) {
        if (controller instanceof HBaseRpcController) {
            HBaseRpcController pcrc = (HBaseRpcController)controller;
            CellScanner cellScanner = pcrc.cellScanner();
            ArrayList<Cell> list = null;
            if (cellScanner != null) {
                list = new ArrayList<Cell>();
                try {
                    while (cellScanner.advance()) {
                        list.add(cellScanner.current());
                    }
                }
                catch (IOException e) {
                    pcrc.setFailed(e);
                    return;
                }
            }
            cellScanner = CellUtil.createCellScanner(list);
            pcrc.setCellScanner(cellScanner);
        }
        done.run((Object)TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build());
    }

    public void error(RpcController controller, TestProtos.EmptyRequestProto request, RpcCallback<TestProtos.EmptyResponseProto> done) {
        if (controller instanceof HBaseRpcController) {
            ((HBaseRpcController)controller).setFailed((IOException)((Object)new DoNotRetryIOException("server error!")));
        } else {
            controller.setFailed("server error!");
        }
    }

    public void pause(RpcController controller, TestProtos.PauseRequestProto request, RpcCallback<TestProtos.EmptyResponseProto> done) {
        this.executor.schedule(() -> done.run((Object)TestProtos.EmptyResponseProto.getDefaultInstance()), (long)request.getMs(), TimeUnit.MILLISECONDS);
    }

    public void addr(RpcController controller, TestProtos.EmptyRequestProto request, RpcCallback<TestProtos.AddrResponseProto> done) {
        done.run((Object)TestProtos.AddrResponseProto.newBuilder().setAddr(((InetAddress)RpcServer.getRemoteAddress().get()).getHostAddress()).build());
    }
}

