/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.util.tree.DnNode;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.ReferralManager;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.PartitionNexus;

public class ReferralManagerImpl
implements ReferralManager {
    private DnNode<Entry> referrals;
    private ReentrantReadWriteLock mutex = new ReentrantReadWriteLock();
    private AttributeType OBJECT_CLASS_AT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferralManagerImpl(DirectoryService directoryService) throws LdapException {
        this.lockWrite();
        try {
            this.referrals = new DnNode();
            PartitionNexus nexus = directoryService.getPartitionNexus();
            Set suffixes = nexus.listSuffixes();
            this.OBJECT_CLASS_AT = directoryService.getSchemaManager().getAttributeType("objectClass");
            this.init(directoryService, suffixes.toArray(new String[0]));
        }
        finally {
            this.unlock();
        }
    }

    public void lockRead() {
        this.mutex.readLock().lock();
    }

    public void lockWrite() {
        this.mutex.writeLock().lock();
    }

    public void unlock() {
        if (this.mutex.isWriteLockedByCurrentThread()) {
            this.mutex.writeLock().unlock();
        } else {
            this.mutex.readLock().unlock();
        }
    }

    public void addReferral(Entry entry) {
        try {
            this.referrals.add(entry.getDn(), (Object)entry);
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DirectoryService directoryService, String ... suffixes) throws LdapException {
        EqualityNode referralFilter = new EqualityNode(this.OBJECT_CLASS_AT, (Value)new StringValue("referral"));
        SearchControls searchControl = new SearchControls();
        searchControl.setReturningObjFlag(false);
        searchControl.setSearchScope(2);
        CoreSession adminSession = directoryService.getAdminSession();
        PartitionNexus nexus = directoryService.getPartitionNexus();
        for (String suffix : suffixes) {
            Dn suffixDn = directoryService.getDnFactory().create(suffix);
            SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, suffixDn, (ExprNode)referralFilter, searchControl);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            EntryFilteringCursor cursor = nexus.search(searchOperationContext);
            try {
                cursor.beforeFirst();
                while (cursor.next()) {
                    Entry entry = (Entry)cursor.get();
                    this.lockWrite();
                    try {
                        this.addReferral(entry);
                    }
                    finally {
                        this.unlock();
                    }
                }
                cursor.close();
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void remove(DirectoryService directoryService, Dn suffix) throws Exception {
        EqualityNode referralFilter = new EqualityNode(this.OBJECT_CLASS_AT, (Value)new StringValue("referral"));
        SearchControls searchControl = new SearchControls();
        searchControl.setReturningObjFlag(false);
        searchControl.setSearchScope(2);
        CoreSession adminSession = directoryService.getAdminSession();
        PartitionNexus nexus = directoryService.getPartitionNexus();
        SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, suffix, (ExprNode)referralFilter, searchControl);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
        EntryFilteringCursor cursor = nexus.search(searchOperationContext);
        cursor.beforeFirst();
        while (cursor.next()) {
            Entry entry = (Entry)cursor.get();
            this.removeReferral(entry);
        }
    }

    public boolean hasParentReferral(Dn dn) {
        DnNode referral = this.referrals.getNode(dn);
        return referral != null && referral.isLeaf();
    }

    public Entry getParentReferral(Dn dn) {
        if (!this.hasParentReferral(dn)) {
            return null;
        }
        return (Entry)this.referrals.getElement(dn);
    }

    public boolean isReferral(Dn dn) {
        Entry parent = (Entry)this.referrals.getElement(dn);
        if (parent != null) {
            return dn.equals((Object)parent.getDn());
        }
        return false;
    }

    public void removeReferral(Entry entry) throws LdapException {
        this.referrals.remove(entry.getDn());
    }
}

