/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.SortedSet;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLayoutVersion {
    public static final LayoutVersion.LayoutFeature LAST_NON_RESERVED_COMMON_FEATURE;
    public static final LayoutVersion.LayoutFeature LAST_COMMON_FEATURE;

    @Test
    public void testFeaturesFromAncestorSupported() {
        for (LayoutVersion.Feature f : LayoutVersion.Feature.values()) {
            this.validateFeatureList((LayoutVersion.LayoutFeature)f);
        }
    }

    @Test
    public void testRelease203() {
        Assert.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.DELEGATION_TOKEN, (int)LayoutVersion.Feature.RESERVED_REL20_203.getInfo().getLayoutVersion()));
    }

    @Test
    public void testRelease204() {
        Assert.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.DELEGATION_TOKEN, (int)LayoutVersion.Feature.RESERVED_REL20_204.getInfo().getLayoutVersion()));
    }

    @Test
    public void testRelease1_2_0() {
        Assert.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.CONCAT, (int)LayoutVersion.Feature.RESERVED_REL1_2_0.getInfo().getLayoutVersion()));
    }

    @Test
    public void testNameNodeFeature() {
        NameNodeLayoutVersion.Feature first = NameNodeLayoutVersion.Feature.ROLLING_UPGRADE;
        Assert.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LAST_NON_RESERVED_COMMON_FEATURE, (int)first.getInfo().getLayoutVersion()));
        Assert.assertEquals((long)(LAST_COMMON_FEATURE.getInfo().getLayoutVersion() - 1), (long)first.getInfo().getLayoutVersion());
    }

    @Test
    public void testDataNodeFeature() {
        DataNodeLayoutVersion.Feature first = DataNodeLayoutVersion.Feature.FIRST_LAYOUT;
        Assert.assertTrue((boolean)DataNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LAST_NON_RESERVED_COMMON_FEATURE, (int)first.getInfo().getLayoutVersion()));
        Assert.assertEquals((long)(LAST_COMMON_FEATURE.getInfo().getLayoutVersion() - 1), (long)first.getInfo().getLayoutVersion());
    }

    @Test
    public void testNameNodeFeatureMinimumCompatibleLayoutVersions() {
        int baseLV = NameNodeLayoutVersion.Feature.TRUNCATE.getInfo().getLayoutVersion();
        EnumSet<NameNodeLayoutVersion.Feature> compatibleFeatures = EnumSet.of(NameNodeLayoutVersion.Feature.TRUNCATE, NameNodeLayoutVersion.Feature.APPEND_NEW_BLOCK, NameNodeLayoutVersion.Feature.QUOTA_BY_STORAGE_TYPE);
        for (LayoutVersion.LayoutFeature layoutFeature : compatibleFeatures) {
            Assert.assertEquals((String)String.format("Expected minimum compatible layout version %d for feature %s.", baseLV, layoutFeature), (long)baseLV, (long)layoutFeature.getInfo().getMinimumCompatibleLayoutVersion());
        }
        ArrayList<Object> features = new ArrayList<Object>();
        features.addAll(EnumSet.allOf(LayoutVersion.Feature.class));
        features.addAll(EnumSet.allOf(NameNodeLayoutVersion.Feature.class));
        for (LayoutVersion.LayoutFeature layoutFeature : features) {
            if (compatibleFeatures.contains(layoutFeature)) continue;
            Assert.assertEquals((String)String.format("Expected feature %s to have minimum compatible layout version set to itself.", layoutFeature), (long)layoutFeature.getInfo().getLayoutVersion(), (long)layoutFeature.getInfo().getMinimumCompatibleLayoutVersion());
        }
    }

    @Test
    public void testNameNodeFeatureMinimumCompatibleLayoutVersionAscending() {
        LayoutVersion.LayoutFeature prevF = null;
        for (LayoutVersion.LayoutFeature layoutFeature : EnumSet.allOf(NameNodeLayoutVersion.Feature.class)) {
            if (prevF != null) {
                Assert.assertTrue((String)String.format("Features %s and %s not listed in order of minimum compatible layout version.", prevF, layoutFeature), (layoutFeature.getInfo().getMinimumCompatibleLayoutVersion() <= prevF.getInfo().getMinimumCompatibleLayoutVersion() ? 1 : 0) != 0);
                continue;
            }
            prevF = layoutFeature;
        }
    }

    @Test(expected=AssertionError.class)
    public void testNameNodeFeatureMinimumCompatibleLayoutVersionOutOfOrder() {
        LayoutVersion.FeatureInfo ancestorF = LayoutVersion.Feature.RESERVED_REL2_4_0.getInfo();
        LayoutVersion.LayoutFeature f = (LayoutVersion.LayoutFeature)Mockito.mock(LayoutVersion.LayoutFeature.class);
        Mockito.when((Object)f.getInfo()).thenReturn((Object)new LayoutVersion.FeatureInfo(ancestorF.getLayoutVersion() - 1, ancestorF.getLayoutVersion(), Integer.valueOf(ancestorF.getMinimumCompatibleLayoutVersion() + 1), "Invalid feature.", false, new LayoutVersion.LayoutFeature[0]));
        HashMap features = new HashMap();
        LayoutVersion.updateMap(features, (LayoutVersion.LayoutFeature[])LayoutVersion.Feature.values());
        LayoutVersion.updateMap(features, (LayoutVersion.LayoutFeature[])new LayoutVersion.LayoutFeature[]{f});
    }

    @Test
    public void testCurrentMinimumCompatibleLayoutVersion() {
        int expectedMinCompatLV = NameNodeLayoutVersion.Feature.TRUNCATE.getInfo().getLayoutVersion();
        int actualMinCompatLV = LayoutVersion.getMinimumCompatibleLayoutVersion((LayoutVersion.LayoutFeature[])NameNodeLayoutVersion.Feature.values());
        Assert.assertEquals((String)"The minimum compatible layout version has changed.  Downgrade to prior versions is no longer possible.  Please either restore compatibility, or if the incompatibility is intentional, then update this assertion.", (long)expectedMinCompatLV, (long)actualMinCompatLV);
    }

    private void validateFeatureList(LayoutVersion.LayoutFeature f) {
        LayoutVersion.FeatureInfo info = f.getInfo();
        int lv = info.getLayoutVersion();
        int ancestorLV = info.getAncestorLayoutVersion();
        SortedSet ancestorSet = NameNodeLayoutVersion.getFeatures((int)ancestorLV);
        Assert.assertNotNull((Object)ancestorSet);
        for (LayoutVersion.LayoutFeature feature : ancestorSet) {
            Assert.assertTrue((String)("LV " + lv + " does nto support " + feature + " supported by the ancestor LV " + info.getAncestorLayoutVersion()), (boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)feature, (int)lv));
        }
    }

    @Test
    public void testSNAPSHOT() {
        for (LayoutVersion.Feature f : LayoutVersion.Feature.values()) {
            int version = f.getInfo().getLayoutVersion();
            if (!NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.SNAPSHOT, (int)version)) continue;
            Assert.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, (int)version));
        }
    }

    static {
        LayoutVersion.Feature[] features = LayoutVersion.Feature.values();
        LAST_COMMON_FEATURE = features[features.length - 1];
        LAST_NON_RESERVED_COMMON_FEATURE = LayoutVersion.getLastNonReservedFeature((LayoutVersion.LayoutFeature[])features);
    }
}

