/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.comparator.BooleanComparator;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;

public class BooleanSerializer
extends AbstractElementSerializer<Boolean> {
    public BooleanSerializer() {
        super(new BooleanComparator());
    }

    @Override
    public byte[] serialize(Boolean element) {
        byte[] bytes = new byte[1];
        return BooleanSerializer.serialize(bytes, 0, element);
    }

    public static byte[] serialize(boolean element) {
        byte[] bytes = new byte[1];
        return BooleanSerializer.serialize(bytes, 0, element);
    }

    public static byte[] serialize(byte[] buffer, int start, boolean element) {
        buffer[start] = element ? (byte)1 : 0;
        return buffer;
    }

    public static Boolean deserialize(byte[] in) {
        return BooleanSerializer.deserialize(in, 0);
    }

    public static Boolean deserialize(byte[] in, int start) {
        if (in == null || in.length < 1 + start) {
            throw new RuntimeException("Cannot extract a Boolean from a buffer with not enough bytes");
        }
        return in[start] == 1;
    }

    @Override
    public Boolean deserialize(ByteBuffer buffer) throws IOException {
        return buffer.get() != 0;
    }

    @Override
    public Boolean deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] in = bufferHandler.read(1);
        return BooleanSerializer.deserialize(in);
    }
}

