/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.comparator.ShortComparator;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;

public class ShortSerializer
extends AbstractElementSerializer<Short> {
    public ShortSerializer() {
        super(new ShortComparator());
    }

    @Override
    public byte[] serialize(Short element) {
        byte[] bytes = new byte[2];
        return ShortSerializer.serialize(bytes, 0, element);
    }

    public static byte[] serialize(short value) {
        byte[] bytes = new byte[2];
        return ShortSerializer.serialize(bytes, 0, value);
    }

    public static byte[] serialize(byte[] buffer, int start, short value) {
        buffer[start] = (byte)(value >>> 8);
        buffer[start + 1] = (byte)value;
        return buffer;
    }

    public static Short deserialize(byte[] in) {
        return ShortSerializer.deserialize(in, 0);
    }

    public static Short deserialize(byte[] in, int start) {
        if (in == null || in.length < 2 + start) {
            throw new RuntimeException("Cannot extract a Short from a buffer with not enough bytes");
        }
        return (short)((in[start] << 8) + (in[start + 1] & 0xFF));
    }

    @Override
    public Short deserialize(ByteBuffer buffer) throws IOException {
        return buffer.getShort();
    }

    @Override
    public Short deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] in = bufferHandler.read(2);
        return ShortSerializer.deserialize(in);
    }
}

